/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetricAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

class ScriptedMetricAggregatorFactory
extends AggregatorFactory {
    private final ScriptedMetricAggContexts.MapScript.Factory mapScript;
    private final Map<String, Object> mapScriptParams;
    private final ScriptedMetricAggContexts.CombineScript.Factory combineScript;
    private final Map<String, Object> combineScriptParams;
    private final Script reduceScript;
    private final Map<String, Object> aggParams;
    private final SearchLookup lookup;
    private final ScriptedMetricAggContexts.InitScript.Factory initScript;
    private final Map<String, Object> initScriptParams;

    ScriptedMetricAggregatorFactory(String name, ScriptedMetricAggContexts.MapScript.Factory mapScript, Map<String, Object> mapScriptParams, ScriptedMetricAggContexts.InitScript.Factory initScript, Map<String, Object> initScriptParams, ScriptedMetricAggContexts.CombineScript.Factory combineScript, Map<String, Object> combineScriptParams, Script reduceScript, Map<String, Object> aggParams, SearchLookup lookup, SearchContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.mapScript = mapScript;
        this.mapScriptParams = mapScriptParams;
        this.initScript = initScript;
        this.initScriptParams = initScriptParams;
        this.combineScript = combineScript;
        this.combineScriptParams = combineScriptParams;
        this.reduceScript = reduceScript;
        this.lookup = lookup;
        this.aggParams = aggParams;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return ScriptedMetricAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        Map<String, Object> aggParams = this.aggParams;
        aggParams = aggParams != null ? ScriptedMetricAggregatorFactory.deepCopyParams(aggParams, this.context) : new HashMap<String, Object>();
        HashMap<String, Object> aggState = new HashMap<String, Object>();
        ScriptedMetricAggContexts.InitScript initScript = this.initScript.newInstance(ScriptedMetricAggregatorFactory.mergeParams(aggParams, this.initScriptParams), aggState);
        ScriptedMetricAggContexts.MapScript.LeafFactory mapScript = this.mapScript.newFactory(ScriptedMetricAggregatorFactory.mergeParams(aggParams, this.mapScriptParams), aggState, this.lookup);
        ScriptedMetricAggContexts.CombineScript combineScript = this.combineScript.newInstance(ScriptedMetricAggregatorFactory.mergeParams(aggParams, this.combineScriptParams), aggState);
        Script reduceScript = ScriptedMetricAggregatorFactory.deepCopyScript(this.reduceScript, this.context, aggParams);
        if (initScript != null) {
            initScript.execute();
            CollectionUtils.ensureNoSelfReferences(aggState, "Scripted metric aggs init script");
        }
        return new ScriptedMetricAggregator(this.name, mapScript, combineScript, reduceScript, aggState, this.context, parent, pipelineAggregators, metaData);
    }

    private static Script deepCopyScript(Script script, SearchContext context, Map<String, Object> aggParams) {
        if (script != null) {
            Map<String, Object> params = ScriptedMetricAggregatorFactory.mergeParams(aggParams, ScriptedMetricAggregatorFactory.deepCopyParams(script.getParams(), context));
            return new Script(script.getType(), script.getLang(), script.getIdOrCode(), params);
        }
        return null;
    }

    private static <T> T deepCopyParams(T original, SearchContext context) {
        Object clone;
        if (original instanceof Map) {
            Map originalMap = (Map)original;
            HashMap clonedMap = new HashMap();
            for (Map.Entry e : originalMap.entrySet()) {
                clonedMap.put(ScriptedMetricAggregatorFactory.deepCopyParams(e.getKey(), context), ScriptedMetricAggregatorFactory.deepCopyParams(e.getValue(), context));
            }
            clone = clonedMap;
        } else if (original instanceof List) {
            List originalList = (List)original;
            ArrayList clonedList = new ArrayList();
            for (Object o : originalList) {
                clonedList.add(ScriptedMetricAggregatorFactory.deepCopyParams(o, context));
            }
            clone = clonedList;
        } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
            clone = original;
        } else {
            throw new SearchParseException(context, "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName(), null);
        }
        return clone;
    }

    private static Map<String, Object> mergeParams(Map<String, Object> agg, Map<String, Object> script) {
        HashMap<String, Object> combined = new HashMap<String, Object>(script);
        for (Map.Entry<String, Object> aggEntry : agg.entrySet()) {
            if (combined.putIfAbsent(aggEntry.getKey(), aggEntry.getValue()) == null) continue;
            throw new IllegalArgumentException("Parameter name \"" + aggEntry.getKey() + "\" used in both aggregation and script parameters");
        }
        return combined;
    }
}

