/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.ChildMemoryCircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

public class HierarchyCircuitBreakerService
extends CircuitBreakerService {
    private static final Logger logger = LogManager.getLogger(HierarchyCircuitBreakerService.class);
    private static final String CHILD_LOGGER_PREFIX = "org.elasticsearch.indices.breaker.";
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private final ConcurrentMap<String, CircuitBreaker> breakers = new ConcurrentHashMap<String, CircuitBreaker>();
    public static final Setting<Boolean> USE_REAL_MEMORY_USAGE_SETTING = Setting.boolSetting("indices.breaker.total.use_real_memory", true, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.total.limit", settings -> {
        if (USE_REAL_MEMORY_USAGE_SETTING.get((Settings)settings).booleanValue()) {
            return "95%";
        }
        return "70%";
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.fielddata.limit", "40%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.fielddata.overhead", 1.03, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.fielddata.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.request.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.request.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> REQUEST_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.request.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> ACCOUNTING_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.accounting.limit", "100%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> ACCOUNTING_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.accounting.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> ACCOUNTING_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.accounting.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("network.breaker.inflight_requests.limit", "100%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("network.breaker.inflight_requests.overhead", 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("network.breaker.inflight_requests.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    private final boolean trackRealMemoryUsage;
    private volatile BreakerSettings parentSettings;
    private volatile BreakerSettings fielddataSettings;
    private volatile BreakerSettings inFlightRequestsSettings;
    private volatile BreakerSettings requestSettings;
    private volatile BreakerSettings accountingSettings;
    private final AtomicLong parentTripCount = new AtomicLong(0L);

    public HierarchyCircuitBreakerService(Settings settings, ClusterSettings clusterSettings) {
        this.fielddataSettings = new BreakerSettings("fielddata", FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.PERMANENT);
        this.inFlightRequestsSettings = new BreakerSettings("in_flight_requests", IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.TRANSIENT);
        this.requestSettings = new BreakerSettings("request", REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), REQUEST_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.TRANSIENT);
        this.accountingSettings = new BreakerSettings("accounting", ACCOUNTING_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), ACCOUNTING_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), ACCOUNTING_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.PERMANENT);
        this.parentSettings = new BreakerSettings("parent", TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), 1.0, CircuitBreaker.Type.PARENT, null);
        if (logger.isTraceEnabled()) {
            logger.trace("parent circuit breaker with settings {}", (Object)this.parentSettings);
        }
        this.trackRealMemoryUsage = USE_REAL_MEMORY_USAGE_SETTING.get(settings);
        this.registerBreaker(this.requestSettings);
        this.registerBreaker(this.fielddataSettings);
        this.registerBreaker(this.inFlightRequestsSettings);
        this.registerBreaker(this.accountingSettings);
        clusterSettings.addSettingsUpdateConsumer(TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, this::setTotalCircuitBreakerLimit, this::validateTotalCircuitBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, this::setFieldDataBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING, IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING, this::setInFlightRequestsBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, this::setRequestBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(ACCOUNTING_CIRCUIT_BREAKER_LIMIT_SETTING, ACCOUNTING_CIRCUIT_BREAKER_OVERHEAD_SETTING, this::setAccountingBreakerLimit);
    }

    private void setRequestBreakerLimit(ByteSizeValue newRequestMax, Double newRequestOverhead) {
        BreakerSettings newRequestSettings = new BreakerSettings("request", newRequestMax.getBytes(), newRequestOverhead, this.requestSettings.getType(), this.requestSettings.getDurability());
        this.registerBreaker(newRequestSettings);
        this.requestSettings = newRequestSettings;
        logger.info("Updated breaker settings request: {}", (Object)newRequestSettings);
    }

    private void setInFlightRequestsBreakerLimit(ByteSizeValue newInFlightRequestsMax, Double newInFlightRequestsOverhead) {
        BreakerSettings newInFlightRequestsSettings = new BreakerSettings("in_flight_requests", newInFlightRequestsMax.getBytes(), newInFlightRequestsOverhead, this.inFlightRequestsSettings.getType(), this.inFlightRequestsSettings.getDurability());
        this.registerBreaker(newInFlightRequestsSettings);
        this.inFlightRequestsSettings = newInFlightRequestsSettings;
        logger.info("Updated breaker settings for in-flight requests: {}", (Object)newInFlightRequestsSettings);
    }

    private void setFieldDataBreakerLimit(ByteSizeValue newFielddataMax, Double newFielddataOverhead) {
        long newFielddataLimitBytes = newFielddataMax == null ? this.fielddataSettings.getLimit() : newFielddataMax.getBytes();
        newFielddataOverhead = newFielddataOverhead == null ? this.fielddataSettings.getOverhead() : newFielddataOverhead.doubleValue();
        BreakerSettings newFielddataSettings = new BreakerSettings("fielddata", newFielddataLimitBytes, newFielddataOverhead, this.fielddataSettings.getType(), this.fielddataSettings.getDurability());
        this.registerBreaker(newFielddataSettings);
        this.fielddataSettings = newFielddataSettings;
        logger.info("Updated breaker settings field data: {}", (Object)newFielddataSettings);
    }

    private void setAccountingBreakerLimit(ByteSizeValue newAccountingMax, Double newAccountingOverhead) {
        BreakerSettings newAccountingSettings = new BreakerSettings("accounting", newAccountingMax.getBytes(), newAccountingOverhead, this.accountingSettings.getType(), this.accountingSettings.getDurability());
        this.registerBreaker(newAccountingSettings);
        this.accountingSettings = newAccountingSettings;
        logger.info("Updated breaker settings for accounting requests: {}", (Object)newAccountingSettings);
    }

    private boolean validateTotalCircuitBreakerLimit(ByteSizeValue byteSizeValue) {
        BreakerSettings newParentSettings = new BreakerSettings("parent", byteSizeValue.getBytes(), 1.0, CircuitBreaker.Type.PARENT, null);
        HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{newParentSettings});
        return true;
    }

    private void setTotalCircuitBreakerLimit(ByteSizeValue byteSizeValue) {
        BreakerSettings newParentSettings;
        this.parentSettings = newParentSettings = new BreakerSettings("parent", byteSizeValue.getBytes(), 1.0, CircuitBreaker.Type.PARENT, null);
    }

    public static void validateSettings(BreakerSettings[] childrenSettings) throws IllegalStateException {
        for (BreakerSettings childSettings : childrenSettings) {
            if (childSettings.getLimit() == -1L || !(childSettings.getOverhead() < 0.0)) continue;
            throw new IllegalStateException("Child breaker overhead " + childSettings + " must be non-negative");
        }
    }

    @Override
    public CircuitBreaker getBreaker(String name) {
        return (CircuitBreaker)this.breakers.get(name);
    }

    @Override
    public AllCircuitBreakerStats stats() {
        ArrayList<CircuitBreakerStats> allStats = new ArrayList<CircuitBreakerStats>(this.breakers.size());
        for (CircuitBreaker breaker : this.breakers.values()) {
            allStats.add(this.stats(breaker.getName()));
        }
        allStats.add(new CircuitBreakerStats("parent", this.parentSettings.getLimit(), this.memoryUsed((long)0L).totalUsage, 1.0, this.parentTripCount.get()));
        return new AllCircuitBreakerStats(allStats.toArray(new CircuitBreakerStats[allStats.size()]));
    }

    @Override
    public CircuitBreakerStats stats(String name) {
        CircuitBreaker breaker = (CircuitBreaker)this.breakers.get(name);
        return new CircuitBreakerStats(breaker.getName(), breaker.getLimit(), breaker.getUsed(), breaker.getOverhead(), breaker.getTrippedCount());
    }

    private MemoryUsage memoryUsed(long newBytesReserved) {
        long transientUsage = 0L;
        long permanentUsage = 0L;
        for (CircuitBreaker breaker : this.breakers.values()) {
            long breakerUsed = (long)((double)breaker.getUsed() * breaker.getOverhead());
            if (breaker.getDurability() == CircuitBreaker.Durability.TRANSIENT) {
                transientUsage += breakerUsed;
                continue;
            }
            if (breaker.getDurability() != CircuitBreaker.Durability.PERMANENT) continue;
            permanentUsage += breakerUsed;
        }
        if (this.trackRealMemoryUsage) {
            long current = this.currentMemoryUsage();
            return new MemoryUsage(current, current + newBytesReserved, transientUsage, permanentUsage);
        }
        long parentEstimated = transientUsage + permanentUsage;
        return new MemoryUsage(parentEstimated, parentEstimated, transientUsage, permanentUsage);
    }

    long currentMemoryUsage() {
        try {
            return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
        }
        catch (IllegalArgumentException ex) {
            assert (ex.getMessage().matches("committed = \\d+ should be < max = \\d+"));
            logger.info("Cannot determine current memory usage due to JDK-8207200.", (Throwable)ex);
            return 0L;
        }
    }

    public void checkParentLimit(long newBytesReserved, String label) throws CircuitBreakingException {
        MemoryUsage memoryUsed = this.memoryUsed(newBytesReserved);
        long parentLimit = this.parentSettings.getLimit();
        if (memoryUsed.totalUsage > parentLimit) {
            this.parentTripCount.incrementAndGet();
            StringBuilder message = new StringBuilder("[parent] Data too large, data for [" + label + "] would be [" + memoryUsed.totalUsage + "/" + new ByteSizeValue(memoryUsed.totalUsage) + "], which is larger than the limit of [" + parentLimit + "/" + new ByteSizeValue(parentLimit) + "]");
            if (this.trackRealMemoryUsage) {
                long realUsage = memoryUsed.baseUsage;
                message.append(", real usage: [");
                message.append(realUsage);
                message.append("/");
                message.append(new ByteSizeValue(realUsage));
                message.append("], new bytes reserved: [");
                message.append(newBytesReserved);
                message.append("/");
                message.append(new ByteSizeValue(newBytesReserved));
                message.append("]");
            }
            message.append(", usages [");
            message.append(String.join((CharSequence)", ", this.breakers.entrySet().stream().map(e -> {
                CircuitBreaker breaker = (CircuitBreaker)e.getValue();
                long breakerUsed = (long)((double)breaker.getUsed() * breaker.getOverhead());
                return (String)e.getKey() + "=" + breakerUsed + "/" + new ByteSizeValue(breakerUsed);
            }).collect(Collectors.toList())));
            message.append("]");
            CircuitBreaker.Durability durability = memoryUsed.transientChildUsage >= memoryUsed.permanentChildUsage ? CircuitBreaker.Durability.TRANSIENT : CircuitBreaker.Durability.PERMANENT;
            logger.debug("{}", (Object)message);
            throw new CircuitBreakingException(message.toString(), memoryUsed.totalUsage, parentLimit, durability);
        }
    }

    @Override
    public void registerBreaker(BreakerSettings breakerSettings) {
        HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{breakerSettings});
        if (breakerSettings.getType() != CircuitBreaker.Type.NOOP) {
            CircuitBreaker oldBreaker;
            ChildMemoryCircuitBreaker breaker = new ChildMemoryCircuitBreaker(breakerSettings, LogManager.getLogger((String)(CHILD_LOGGER_PREFIX + breakerSettings.getName())), this, breakerSettings.getName());
            do {
                if ((oldBreaker = this.breakers.putIfAbsent(breakerSettings.getName(), breaker)) == null) {
                    return;
                }
                breaker = new ChildMemoryCircuitBreaker(breakerSettings, (ChildMemoryCircuitBreaker)oldBreaker, LogManager.getLogger((String)(CHILD_LOGGER_PREFIX + breakerSettings.getName())), this, breakerSettings.getName());
            } while (!this.breakers.replace(breakerSettings.getName(), oldBreaker, breaker));
            return;
        }
        NoopCircuitBreaker breaker = new NoopCircuitBreaker(breakerSettings.getName());
        this.breakers.put(breakerSettings.getName(), breaker);
    }

    private static class MemoryUsage {
        final long baseUsage;
        final long totalUsage;
        final long transientChildUsage;
        final long permanentChildUsage;

        MemoryUsage(long baseUsage, long totalUsage, long transientChildUsage, long permanentChildUsage) {
            this.baseUsage = baseUsage;
            this.totalUsage = totalUsage;
            this.transientChildUsage = transientChildUsage;
            this.permanentChildUsage = permanentChildUsage;
        }
    }
}

