/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.slm;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class SnapshotLifecyclePolicy
implements ToXContentObject {
    private final String id;
    private final String name;
    private final String schedule;
    private final String repository;
    private final Map<String, Object> configuration;
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField SCHEDULE = new ParseField("schedule", new String[0]);
    private static final ParseField REPOSITORY = new ParseField("repository", new String[0]);
    private static final ParseField CONFIG = new ParseField("config", new String[0]);
    private static final ConstructingObjectParser<SnapshotLifecyclePolicy, String> PARSER = new ConstructingObjectParser<SnapshotLifecyclePolicy, String>("snapshot_lifecycle", true, (a, id) -> {
        String name = (String)a[0];
        String schedule = (String)a[1];
        String repo = (String)a[2];
        Map config = (Map)a[3];
        return new SnapshotLifecyclePolicy((String)id, name, schedule, repo, config);
    });

    public SnapshotLifecyclePolicy(String id, String name, String schedule, String repository, @Nullable Map<String, Object> configuration) {
        this.id = Objects.requireNonNull(id);
        this.name = name;
        this.schedule = schedule;
        this.repository = repository;
        this.configuration = configuration;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getRepository() {
        return this.repository;
    }

    @Nullable
    public Map<String, Object> getConfig() {
        return this.configuration;
    }

    public static SnapshotLifecyclePolicy parse(XContentParser parser, String id) {
        return PARSER.apply(parser, id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(SCHEDULE.getPreferredName(), this.schedule);
        builder.field(REPOSITORY.getPreferredName(), this.repository);
        if (this.configuration != null) {
            builder.field(CONFIG.getPreferredName(), this.configuration);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.schedule, this.repository, this.configuration);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecyclePolicy other = (SnapshotLifecyclePolicy)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.repository, other.repository) && Objects.equals(this.configuration, other.configuration);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SCHEDULE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REPOSITORY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), CONFIG);
    }
}

