/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.process.ModelSnapshot;

public class DeleteModelSnapshotRequest
extends ActionRequest {
    private final String jobId;
    private final String snapshotId;

    public DeleteModelSnapshotRequest(String jobId, String snapshotId) {
        this.jobId = Objects.requireNonNull(jobId, "[" + Job.ID + "] must not be null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "[" + ModelSnapshot.SNAPSHOT_ID + "] must not be null");
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.snapshotId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DeleteModelSnapshotRequest other = (DeleteModelSnapshotRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId);
    }
}

