/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.aries.blueprint.compendium.cm.ManagedObject;
import org.apache.aries.blueprint.compendium.cm.ManagedObjectManager;
import org.apache.aries.blueprint.ext.PropertyPlaceholderExt;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmPropertyPlaceholder
extends PropertyPlaceholderExt
implements ManagedObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPropertyPlaceholder.class);
    private ExtendedBlueprintContainer blueprintContainer;
    private ConfigurationAdmin configAdmin;
    private String persistentId;
    private String updateStrategy;
    private ManagedObjectManager managedObjectManager;
    private Dictionary<String, Object> properties;
    private boolean initialized;

    public ExtendedBlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    @Override
    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public String getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    public void setManagedObjectManager(ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
    }

    public void init() throws Exception {
        LOGGER.debug("Initializing CmPropertyPlaceholder");
        Properties props = new Properties();
        props.put("service.pid", this.persistentId);
        Bundle bundle = this.blueprintContainer.getBundleContext().getBundle();
        props.put("Bundle-SymbolicName", bundle.getSymbolicName());
        props.put("Bundle-Version", bundle.getHeaders().get("Bundle-Version"));
        this.managedObjectManager.register(this, props);
    }

    public void destroy() {
        LOGGER.debug("Destroying CmPropertyPlaceholder");
        this.managedObjectManager.unregister(this);
    }

    protected Object getProperty(String val) {
        LOGGER.debug("Retrieving property value {} from configuration with pid {}", (Object)val, (Object)this.persistentId);
        Object v = null;
        if (this.properties != null) {
            v = this.properties.get(val);
            if (v != null) {
                LOGGER.debug("Found property value {}", v);
            } else {
                LOGGER.debug("Property not found in configuration");
            }
        }
        if (v == null) {
            v = super.getProperty(val);
        }
        return v;
    }

    @Override
    public Bundle getBundle() {
        return this.blueprintContainer.getBundleContext().getBundle();
    }

    @Override
    public void updated(Dictionary props) {
        if (!this.initialized) {
            this.properties = props;
            this.initialized = true;
            return;
        }
        if ("reload".equalsIgnoreCase(this.updateStrategy) && !this.equals(this.properties, props)) {
            LOGGER.debug("Configuration updated for pid={}", (Object)this.persistentId);
            new Thread(){

                @Override
                public void run() {
                    CmPropertyPlaceholder.this.blueprintContainer.reload();
                }
            }.start();
        }
    }

    private <T, U> boolean equals(Dictionary<T, U> d1, Dictionary<T, U> d2) {
        if (d1 == null || d1.isEmpty()) {
            return d2 == null || d2.isEmpty();
        }
        if (d2 == null || d1.size() != d2.size()) {
            return false;
        }
        Enumeration<T> e = d1.keys();
        while (e.hasMoreElements()) {
            T k = e.nextElement();
            U v1 = d1.get(k);
            U v2 = d2.get(k);
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return true;
    }
}

