/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.ParallelStep;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;

public class AdvancedFixedFlowController
extends CasFlowController_ImplBase {
    public static final String PARAM_ACTION_AFTER_CAS_MULTIPLIER = "ActionAfterCasMultiplier";
    public static final String PARAM_ALLOW_CONTINUE_ON_FAILURE = "AllowContinueOnFailure";
    public static final String PARAM_FLOW = "Flow";
    private static final int ACTION_CONTINUE = 0;
    private static final int ACTION_STOP = 1;
    private static final int ACTION_DROP = 2;
    private static final int ACTION_DROP_IF_NEW_CAS_PRODUCED = 3;
    private ArrayList<Step> mSequence;
    private int mActionAfterCasMultiplier;
    private Set<String> mAEsAllowingContinueOnFailure = new HashSet<String>();

    public void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        String[] flow = (String[])aContext.getConfigParameterValue(PARAM_FLOW);
        this.mSequence = new ArrayList();
        for (int i = 0; i < flow.length; ++i) {
            String[] aes = flow[i].split(",");
            if (aes.length == 1) {
                this.mSequence.add((Step)new SimpleStep(aes[0]));
                continue;
            }
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(Arrays.asList(aes));
            this.mSequence.add((Step)new ParallelStep(keys));
        }
        String actionAfterCasMultiplier = (String)aContext.getConfigParameterValue(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        if ("continue".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 0;
        } else if ("stop".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 1;
        } else if ("drop".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 2;
        } else if ("dropIfNewCasProduced".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 3;
        } else if (actionAfterCasMultiplier == null) {
            this.mActionAfterCasMultiplier = 3;
        } else {
            throw new ResourceInitializationException();
        }
        String[] aeKeysAllowingContinue = (String[])aContext.getConfigParameterValue(PARAM_ALLOW_CONTINUE_ON_FAILURE);
        if (aeKeysAllowingContinue != null) {
            this.mAEsAllowingContinueOnFailure.addAll(Arrays.asList(aeKeysAllowingContinue));
        }
    }

    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        return new FixedFlowObject(0);
    }

    public synchronized void addAnalysisEngines(Collection<String> aKeys) {
        this.mSequence.add((Step)new ParallelStep(new ArrayList<String>(aKeys)));
    }

    public synchronized void removeAnalysisEngines(Collection<String> aKeys) throws AnalysisEngineProcessException {
        for (int i = 0; i < this.mSequence.size(); ++i) {
            Step step = this.mSequence.get(i);
            if (step instanceof SimpleStep && aKeys.contains(((SimpleStep)step).getAnalysisEngineKey())) {
                this.mSequence.set(i, null);
                continue;
            }
            if (!(step instanceof ParallelStep)) continue;
            ArrayList keys = new ArrayList(((ParallelStep)step).getAnalysisEngineKeys());
            keys.removeAll(aKeys);
            if (keys.isEmpty()) {
                this.mSequence.set(i, null);
                continue;
            }
            this.mSequence.set(i, (Step)new ParallelStep(keys));
        }
    }

    class FixedFlowObject
    extends CasFlow_ImplBase {
        private int currentStep;
        private boolean wasPassedToCasMultiplier = false;
        private boolean casMultiplierProducedNewCas = false;
        private boolean internallyCreatedCas = false;

        public FixedFlowObject(int startStep) {
            this(startStep, false);
        }

        public FixedFlowObject(int startStep, boolean internallyCreatedCas) {
            this.currentStep = startStep;
            this.internallyCreatedCas = internallyCreatedCas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Step next() throws AnalysisEngineProcessException {
            Step nextStep;
            if (this.wasPassedToCasMultiplier) {
                switch (AdvancedFixedFlowController.this.mActionAfterCasMultiplier) {
                    case 1: {
                        return new FinalStep();
                    }
                    case 2: {
                        return new FinalStep(this.internallyCreatedCas);
                    }
                    case 3: {
                        if (!this.casMultiplierProducedNewCas) break;
                        return new FinalStep(this.internallyCreatedCas);
                    }
                }
                this.wasPassedToCasMultiplier = false;
                this.casMultiplierProducedNewCas = false;
            }
            AdvancedFixedFlowController advancedFixedFlowController = AdvancedFixedFlowController.this;
            synchronized (advancedFixedFlowController) {
                do {
                    if (this.currentStep < AdvancedFixedFlowController.this.mSequence.size()) continue;
                    return new FinalStep();
                } while ((nextStep = AdvancedFixedFlowController.this.mSequence.get(this.currentStep++)) == null);
            }
            if (this.stepContainsCasMultiplier(nextStep)) {
                this.wasPassedToCasMultiplier = true;
            }
            return nextStep;
        }

        private boolean stepContainsCasMultiplier(Step nextStep) {
            if (nextStep instanceof SimpleStep) {
                AnalysisEngineMetaData md = (AnalysisEngineMetaData)AdvancedFixedFlowController.this.getContext().getAnalysisEngineMetaDataMap().get(((SimpleStep)nextStep).getAnalysisEngineKey());
                return md != null && md.getOperationalProperties() != null && md.getOperationalProperties().getOutputsNewCASes();
            }
            if (nextStep instanceof ParallelStep) {
                for (String key : ((ParallelStep)nextStep).getAnalysisEngineKeys()) {
                    AnalysisEngineMetaData md = (AnalysisEngineMetaData)AdvancedFixedFlowController.this.getContext().getAnalysisEngineMetaDataMap().get(key);
                    if (md == null || md.getOperationalProperties() == null || !md.getOperationalProperties().getOutputsNewCASes()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public synchronized Flow newCasProduced(CAS newCas, String producedBy) throws AnalysisEngineProcessException {
            this.casMultiplierProducedNewCas = true;
            int i = 0;
            while (!this.stepContains(AdvancedFixedFlowController.this.mSequence.get(i), producedBy)) {
                ++i;
            }
            return new FixedFlowObject(i + 1, true);
        }

        private boolean stepContains(Step step, String producedBy) {
            if (step instanceof SimpleStep) {
                return ((SimpleStep)step).getAnalysisEngineKey().equals(producedBy);
            }
            if (step instanceof ParallelStep) {
                for (String key : ((ParallelStep)step).getAnalysisEngineKeys()) {
                    if (!key.equals(producedBy)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public boolean continueOnFailure(String failedAeKey, Exception failure) {
            return AdvancedFixedFlowController.this.mAEsAllowingContinueOnFailure.contains(failedAeKey);
        }
    }
}

