/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.impl.ConfigurationGroup_impl;
import org.apache.uima.resource.metadata.impl.ConfigurationParameter_impl;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSectionParm;
import org.apache.uima.taeconfigurator.editors.ui.ParameterSettingsSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddParameterDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.CommonInputDialog;
import org.apache.uima.taeconfigurator.files.PickOverrideKeysAndParmName;
import org.apache.uima.taeconfigurator.model.ConfigGroup;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class ParameterSection
extends AbstractSectionParm {
    public static final int NEW_OVERRIDE = -1;
    public static final boolean REMOVE_FROM_GUI = true;
    public static final boolean GIVE_WARNING_MESSAGE = true;
    private Text defaultGroup;
    private CCombo searchStrategy;
    private Button addButton;
    private Button addGroupButton;
    private Button editButton;
    private Button removeButton;
    private Button usingGroupsButton;
    private Composite groupingControl;
    private boolean firstTime = true;

    public ParameterSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Configuration Parameters", "This section shows all configuration parameters defined for this engine.");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.newComposite((Composite)this.getSection());
        this.usingGroupsButton = this.newCheckBox(sectionClient, "Use Parameter Groups", "Check this box if Groups are being used with Parameters");
        this.groupingControl = this.new2ColumnComposite(sectionClient);
        ((GridData)this.groupingControl.getLayoutData()).grabExcessVerticalSpace = false;
        this.enableBorders(this.groupingControl);
        this.toolkit.paintBordersFor(this.groupingControl);
        this.defaultGroup = this.newLabeledTextField(this.groupingControl, "Default Group", "Specify the name of the default group.");
        this.newLabelWithTip(this.groupingControl, "SearchStrategy", "Fallback strategy when a parameter is not found in the specified group");
        this.searchStrategy = this.newCComboWithTip(this.groupingControl, "Fallback strategy when a parameter is not found in the specified group");
        this.searchStrategy.add("language_fallback");
        this.searchStrategy.add("default_fallback");
        this.searchStrategy.add("none");
        Composite tableContainer = this.new2ColumnComposite(sectionClient);
        this.enableBorders(tableContainer);
        this.toolkit.paintBordersFor(tableContainer);
        this.parameterSectionTree = this.tree = this.newTree(tableContainer);
        Composite buttonContainer = this.newButtonContainer(tableContainer);
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add a new parameter");
        this.addGroupButton = this.newPushButton(buttonContainer, "AddGroup", "Click here to add a group specification.  A group specification names one or more group names.");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        this.tree.addListener(8, (Listener)this);
        this.tree.addListener(32, (Listener)this);
    }

    public void refresh() {
        super.refresh();
        this.cpd = this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        if (this.firstTime && this.isParmGroup() || this.isAggregate() || !this.firstTime && this.usingGroupsButton.getSelection()) {
            this.usingGroupsButton.setSelection(true);
            this.groupingControl.setVisible(true);
            this.defaultGroup.setText(ParameterSection.convertNull(this.cpd.getDefaultGroupName()));
            if (null == this.cpd.getSearchStrategy()) {
                this.cpd.setSearchStrategy("language_fallback");
            }
            this.searchStrategy.setText(this.cpd.getSearchStrategy());
        } else {
            this.groupingControl.setVisible(false);
            this.usingGroupsButton.setSelection(false);
        }
        this.firstTime = false;
        this.showOverrides = true;
        this.splitGroupNames = false;
        this.clearAndRefillTree(this.usingGroupsButton.getSelection());
        ParameterSection.maybeSetSelection(this.tree, 0);
        this.enable();
        ParameterSettingsSection settingsSection = this.editor.getSettingsPage().getParameterSettingsSection();
        if (null != settingsSection) {
            this.setSettings(settingsSection);
            this.settings.refresh();
        }
    }

    @Override
    public void handleEvent(Event event) {
        this.cpd = this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        if (event.type == 32) {
            this.showDescriptionAsToolTip(event);
        } else if (event.widget == this.usingGroupsButton) {
            if (!this.usingGroupsButton.getSelection()) {
                if (1 == Utility.popOkCancel("Confirm Remove Groups", "This action will delete any group information that may be present in this descriptor.  Proceed?", 4)) {
                    this.usingGroupsButton.setSelection(true);
                    return;
                }
                TreeItem[] items = this.tree.getItems();
                TreeItem[] removeItems = new TreeItem[items.length - 1];
                System.arraycopy(items, 1, removeItems, 0, removeItems.length);
                this.removeItems(removeItems, false);
                this.cpd.setCommonParameters(AbstractSection.configurationParameterArray0);
                this.cpd.setConfigurationGroups(AbstractSection.configurationGroupArray0);
            }
            this.setFileDirty();
            this.refresh();
        } else if (event.widget == this.searchStrategy) {
            this.valueChanged = false;
            this.cpd.setSearchStrategy(this.setValueChanged(this.searchStrategy.getText(), this.cpd.getSearchStrategy()));
            if (this.valueChanged) {
                this.setFileDirty();
            }
        } else if (event.widget == this.defaultGroup) {
            this.valueChanged = false;
            this.cpd.setDefaultGroupName(this.setValueChanged(this.defaultGroup.getText(), this.cpd.getDefaultGroupName()));
            if (this.valueChanged) {
                this.setFileDirty();
            }
        } else if (event.widget == this.addGroupButton) {
            CommonInputDialog dialog = new CommonInputDialog(this, "Add Group", "Specify one or more unique group names, separated by 1 space character, and press OK", 14);
            do {
                if (dialog.open() != 1) continue;
                return;
            } while (!this.addNewOrEditExistingGroup(dialog.getValue(), null));
            this.commonActionFinish();
        } else if (event.widget == this.addButton) {
            boolean valid;
            boolean bl = valid = this.tree.getSelectionCount() == 1;
            if (this.isPrimitive()) {
                valid = valid && (this.isGroupSelection() || this.isParmSelection());
            } else {
                boolean bl2 = valid = valid && (this.isParmSelection() || this.isOverrideSelection());
            }
            if (!valid) {
                if (this.isPrimitive()) {
                    Utility.popMessage("Wrong item selected", "Please first select the group under which to add a parameter", 1);
                } else {
                    Utility.popMessage("Wrong item selected", "Please first select the parameter under which to add an override", 1);
                }
                return;
            }
            if (this.isPrimitive()) {
                AddParameterDialog dialog;
                TreeItem parentGroup = this.tree.getSelection()[0];
                if (this.isParmSelection()) {
                    parentGroup = parentGroup.getParentItem();
                }
                if ((dialog = new AddParameterDialog((AbstractSection)this, this.getCorrespondingModelGroup(parentGroup))).open() == 1) {
                    return;
                }
                this.addNewConfigurationParameter(dialog, parentGroup);
                if (null != parentGroup) {
                    parentGroup.setExpanded(true);
                }
                this.commonActionFinish();
            } else {
                TreeItem parentParm = this.tree.getSelection()[0];
                if (this.isOverride(parentParm)) {
                    parentParm = parentParm.getParentItem();
                }
                this.addOrEditOverride(parentParm, -1);
            }
        } else if (event.widget == this.editButton || event.type == 8) {
            TreeItem editItem = this.tree.getSelection()[0];
            if (this.isParameter(editItem) && this.isPrimitive()) {
                AddParameterDialog dialog = new AddParameterDialog((AbstractSection)this, this.getCorrespondingModelParm(editItem));
                if (dialog.open() == 1) {
                    return;
                }
                this.alterExistingConfigurationParameter(dialog, editItem);
                this.commonActionFinishDirtyIfChange();
            } else if (this.isParameter(editItem) && this.isAggregate()) {
                ConfigurationParameter existingCP = this.getCorrespondingModelParm(editItem);
                AddParameterDialog dialog = new AddParameterDialog((AbstractSection)this, existingCP);
                if (dialog.open() == 1) {
                    return;
                }
                this.alterExistingConfigurationParameter(dialog, editItem);
                this.commonActionFinishDirtyIfChange();
            } else if (this.isOverride(editItem)) {
                TreeItem parent = editItem.getParentItem();
                int overrideIndex = this.getItemIndex(parent, editItem);
                this.addOrEditOverride(parent, overrideIndex);
            } else if (this.isGroup(editItem)) {
                String groupNames = this.getName(editItem.getText());
                if (groupNames.equals(COMMON_GROUP) || groupNames.equals(NOT_IN_ANY_GROUP)) {
                    return;
                }
                CommonInputDialog dialog = new CommonInputDialog(this, "Edit group", "Specify one or more unique group names, separated by 1 space character, and press OK", 14, groupNames);
                do {
                    if (dialog.open() != 1) continue;
                    return;
                } while (!this.addNewOrEditExistingGroup(dialog.getValue(), editItem));
                this.commonActionFinishDirtyIfChange();
            }
        } else if (event.widget == this.removeButton || event.widget == this.tree && event.type == 2 && event.character == '\u007f') {
            this.valueChanged = this.removeItems(this.tree.getSelection(), true);
            this.commonActionFinishDirtyIfChange();
        } else if (event.widget != this.tree || event.type == 13) {
            // empty if block
        }
        this.enable();
    }

    private void addOrEditOverride(TreeItem parmItem, int overrideIndex) {
        ConfigurationParameter cp = this.getCorrespondingModelParm(parmItem);
        TreeItem groupItem = parmItem.getParentItem();
        ConfigGroup cg = this.getCorrespondingModelGroup(groupItem);
        Map delegateMap1 = this.editor.getResolvedDelegates();
        HashMap<String, ResourceSpecifier> delegateMap = null;
        if (null != delegateMap1) {
            delegateMap = new HashMap<String, ResourceSpecifier>(delegateMap1.size());
            delegateMap.putAll(delegateMap1);
            FlowControllerDeclaration fcd = this.editor.getResolvedFlowControllerDeclaration();
            if (null != fcd) {
                delegateMap.put(fcd.getKey(), fcd.getSpecifier());
            }
        }
        PickOverrideKeysAndParmName dialog = new PickOverrideKeysAndParmName(this, delegateMap, "Override Keys and Parameter Name Selection", cp, cg, overrideIndex == -1);
        dialog.setTitle("Delegate Keys and Parameter Name Selection");
        dialog.setMessage("Select the override key path from the left panel, and the overridden parameter from the right panel.\nOnly valid parameters will be shown.");
        if (dialog.open() == 1) {
            return;
        }
        String delegateKeyName = dialog.delegateKeyName;
        String delegateParameterName = dialog.delegateParameterName;
        this.valueChanged = false;
        String overrideSpec = delegateKeyName + "/" + delegateParameterName;
        if (overrideIndex < 0) {
            this.addOverride(cp, overrideSpec);
            this.valueChanged = true;
        } else {
            String[] overrides = cp.getOverrides();
            overrides[overrideIndex] = this.setValueChanged(overrideSpec, overrides[overrideIndex]);
            cp.setOverrides(overrides);
            parmItem.getItems()[overrideIndex].setText(this.OVERRIDE_HEADER + overrideSpec);
        }
        this.commonActionFinishDirtyIfChange();
    }

    private boolean removeItems(TreeItem[] itemsToRemove, boolean giveWarningMsg) {
        int i;
        String[] namesToRemove = new String[itemsToRemove.length];
        boolean[] isGroup = new boolean[itemsToRemove.length];
        StringBuffer msgGroup = new StringBuffer();
        StringBuffer msg = new StringBuffer();
        StringBuffer oMsg = new StringBuffer();
        for (i = 0; i < itemsToRemove.length; ++i) {
            namesToRemove[i] = this.getName(itemsToRemove[i].getText());
            isGroup[i] = this.isGroup(itemsToRemove[i]);
            if (isGroup[i]) {
                if (NOT_IN_ANY_GROUP.equals(namesToRemove[i])) {
                    msgGroup.append("\nThis action removes all parameter descriptions in the <Not in any group> section.");
                    continue;
                }
                if (i > 0) {
                    msgGroup.append(", ");
                } else if (COMMON_GROUP.equals(namesToRemove[i])) {
                    msgGroup.append("\nThis action removes all parameter descriptions in the <Common> section.");
                } else {
                    msgGroup.append("\nGroups being removed, together with their parameter definitions defined here: \n");
                }
                if (COMMON_GROUP.equals(namesToRemove[i])) continue;
                msgGroup.append(namesToRemove[i]);
                continue;
            }
            if (this.isParameter(itemsToRemove[i])) {
                if (i > 0) {
                    msg.append(", ");
                } else {
                    msg.append("\nParameters being removed: \n");
                }
                msg.append(namesToRemove[i]);
                continue;
            }
            if (this.isOverride(itemsToRemove[i])) {
                if (i > 0) {
                    oMsg.append(", ");
                } else {
                    oMsg.append("\nOverride being removed: \n");
                }
                oMsg.append(namesToRemove[i]);
                continue;
            }
            throw new InternalErrorCDE("invalid state");
        }
        if (giveWarningMsg && 1 == Utility.popOkCancel("Confirm Remove", "Please confirm remove, or Cancel.\n" + msgGroup.toString() + msg.toString() + oMsg.toString(), 4)) {
            return false;
        }
        for (i = 0; i < itemsToRemove.length; ++i) {
            if (isGroup[i]) {
                this.removeGroup(itemsToRemove[i], namesToRemove[i]);
                continue;
            }
            if (this.isParameter(itemsToRemove[i])) {
                this.removeParameter(itemsToRemove[i], namesToRemove[i]);
                continue;
            }
            if (this.isOverride(itemsToRemove[i])) {
                TreeItem parentItem = itemsToRemove[i].getParentItem();
                ConfigurationParameter cp = this.getCorrespondingModelParm(parentItem);
                cp.setOverrides(this.removeOverride(cp, this.getItemIndex(parentItem, itemsToRemove[i])));
                itemsToRemove[i].dispose();
                if (cp.getOverrides().length != 0) continue;
                this.removeParameter(parentItem, this.getName(parentItem));
                continue;
            }
            throw new InternalErrorCDE("Invalid state");
        }
        return true;
    }

    private void removeParameter(TreeItem itemToRemove, String nameToRemove) {
        TreeItem parentItem = itemToRemove.getParentItem();
        ConfigurationGroup cg = null;
        String parentGroupName = this.getName(parentItem.getText());
        if (parentGroupName.equals(NOT_IN_ANY_GROUP)) {
            this.cpd.setConfigurationParameters(this.removeConfigurationParameter(this.cpd.getConfigurationParameters(), nameToRemove));
        } else if (parentGroupName.equals(COMMON_GROUP)) {
            this.commonParms = this.removeConfigurationParameter(this.cpd.getCommonParameters(), nameToRemove);
            this.cpd.setCommonParameters(this.commonParms);
        } else {
            cg = this.getConfigurationGroup(parentGroupName);
            cg.setConfigurationParameters(this.removeConfigurationParameter(cg.getConfigurationParameters(), nameToRemove));
        }
        this.removeParmSettingFromMultipleGroups(itemToRemove, true);
        itemToRemove.dispose();
        if (null != cg && cg.getConfigurationParameters().length == 0) {
            this.removeGroup(parentItem, this.getName(parentItem));
        }
    }

    private void removeGroup(TreeItem itemToRemove, String nameToRemove) {
        if (nameToRemove.equals(COMMON_GROUP)) {
            this.removeCommonParmSettingsFromMultipleGroups();
            this.cpd.setCommonParameters(configurationParameterArray0);
            this.commonParms = configurationParameterArray0;
            this.disposeAllChildItems(itemToRemove);
        } else if (nameToRemove.equals(NOT_IN_ANY_GROUP)) {
            this.removeIncludedParmSettingsFromSingleGroup(NOT_IN_ANY_GROUP, null);
            this.cpd.setConfigurationParameters(configurationParameterArray0);
            this.disposeAllChildItems(itemToRemove);
        } else {
            ConfigurationGroup cg = this.getConfigurationGroup(nameToRemove);
            this.removeIncludedParmSettingsFromMultipleGroups(cg.getNames(), cg.getConfigurationParameters());
            this.cpd.setConfigurationGroups(this.removeConfigurationGroup(this.cpd.getConfigurationGroups(), cg));
            itemToRemove.dispose();
        }
    }

    public void addParm(String name, ConfigurationParameter modelParm, ConfigGroup group, String override) {
        TreeItem parentGroup = this.getTreeItemGroup(group);
        AddParameterDialog dialog = new AddParameterDialog((AbstractSection)this, group);
        dialog.parmName = name;
        dialog.description = modelParm.getDescription();
        dialog.mandatory = modelParm.isMandatory();
        dialog.multiValue = modelParm.isMultiValued();
        dialog.parmType = modelParm.getType();
        ConfigurationParameter parmInGroup = this.addNewConfigurationParameter(dialog, parentGroup);
        this.addOverride(parmInGroup, override);
        parentGroup.setExpanded(true);
        this.commonActionFinish();
    }

    private ConfigurationGroup getConfigurationGroup(String groupName) {
        if (groupName.equals(COMMON_GROUP)) {
            throw new InternalErrorCDE("invalid call");
        }
        ConfigurationGroup[] groups = this.cpd.getConfigurationGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (!groupName.equals(ParameterSection.groupNameArrayToString(groups[i].getNames()))) continue;
            return groups[i];
        }
        throw new InternalErrorCDE("invalid state");
    }

    private ConfigurationGroup[] removeConfigurationGroup(ConfigurationGroup[] groups, ConfigurationGroup cg) {
        return (ConfigurationGroup[])Utility.removeElementFromArray(groups, cg, ConfigurationGroup.class);
    }

    private ConfigurationParameter[] removeConfigurationParameter(ConfigurationParameter[] parms, String nameToRemove) {
        ConfigurationParameter[] newParms = new ConfigurationParameter[parms.length - 1];
        int i = 0;
        int j = 0;
        while (i < newParms.length) {
            if (parms[j].getName().equals(nameToRemove)) {
                ++j;
            }
            newParms[i] = parms[j];
            ++i;
            ++j;
        }
        return newParms;
    }

    private String[] removeOverride(ConfigurationParameter cp, int i) {
        String[] oldOverrides = cp.getOverrides();
        String[] newOverrides = new String[oldOverrides.length - 1];
        if (i > 0) {
            System.arraycopy(oldOverrides, 0, newOverrides, 0, i);
        }
        if (oldOverrides.length - 1 - i > 0) {
            System.arraycopy(oldOverrides, i + 1, newOverrides, i, oldOverrides.length - 1 - i);
        }
        return newOverrides;
    }

    public ConfigGroup addGroup(ConfigGroup group) {
        String groupName = group.getName();
        String[] groupNameArray = group.getNameArray();
        if (group.getKind() == 2) {
            groupNameArray = this.getAllGroupNames(group.getCPD());
            groupName = ParameterSection.groupNameArrayToString(groupNameArray);
        }
        ConfigurationGroup_impl cg = new ConfigurationGroup_impl();
        cg.setConfigurationParameters(configurationParameterArray0);
        TreeItem item = this.addGroupToGUI(groupName, (ConfigurationGroup)cg);
        this.addGroupToModel((ConfigurationGroup)cg);
        cg.setNames(groupNameArray);
        this.tree.setSelection(item);
        return new ConfigGroup(this.cpd, (ConfigurationGroup)cg);
    }

    private boolean addNewOrEditExistingGroup(String names, TreeItem existing) {
        TreeItem item;
        String[] groupNamesToAdd;
        this.valueChanged = true;
        ConfigGroup mcg = null;
        String[] oldGroupNames = stringArray0;
        String[] newGroupNames = this.groupNamesToArray(names);
        String[] groupNamesToDrop = stringArray0;
        if (null != existing) {
            mcg = this.getCorrespondingModelGroup(existing);
            oldGroupNames = mcg.getNameArray();
            groupNamesToDrop = this.setDiff(oldGroupNames, newGroupNames);
            groupNamesToAdd = this.setDiff(newGroupNames, oldGroupNames);
        } else {
            groupNamesToAdd = newGroupNames;
        }
        if (this.groupNameAlreadyDefined(newGroupNames)) {
            Utility.popMessage("Group Already Defined", "This set of group names has already been defined.\n\nGroup: " + names, 1);
            return false;
        }
        if (existing == null) {
            ConfigurationGroup_impl cg = new ConfigurationGroup_impl();
            cg.setConfigurationParameters(configurationParameterArray0);
            cg.setNames(this.groupNamesToArray(names));
            item = this.addGroupToGUI(names, (ConfigurationGroup)cg);
            this.addGroupToModel((ConfigurationGroup)cg);
        } else {
            int i;
            this.valueChanged = groupNamesToDrop.length != 0 || groupNamesToAdd.length != 0;
            item = existing;
            this.setGroupText(item, names);
            for (i = 0; i < groupNamesToDrop.length; ++i) {
                this.removeIncludedParmSettingsFromSingleGroup(groupNamesToDrop[i], mcg.getConfigParms());
            }
            mcg.setNameArray(this.groupNamesToArray(names));
            if (null != this.settings) {
                for (i = 0; i < groupNamesToAdd.length; ++i) {
                    TreeItem settingsItem = this.getSettingsTreeGroup(groupNamesToAdd[i]);
                    if (null == settingsItem) {
                        settingsItem = new TreeItem(this.settingsTree, 0);
                        this.setGroupText(settingsItem, groupNamesToAdd[i]);
                        settingsItem.setData(null);
                        this.fill(mcg.getConfigParms(), settingsItem);
                        this.fill(this.commonParms, settingsItem);
                        continue;
                    }
                    this.fillInFrontOfCommon(mcg.getConfigParms(), settingsItem);
                }
            }
        }
        this.tree.setSelection(item);
        return true;
    }

    private void fillInFrontOfCommon(ConfigurationParameter[] parms, TreeItem settingsTreeGroup) {
        if (parms != null) {
            for (int i = parms.length - 1; i >= 0; --i) {
                this.fillParmItem(new TreeItem(settingsTreeGroup, 0, 0), parms[i]);
            }
        }
    }

    private String[] setDiff(String[] s1, String[] s2) {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        for (i = 0; i < s1.length; ++i) {
            result.add(s1[i]);
        }
        for (i = 0; i < s2.length; ++i) {
            result.remove(s2[i]);
        }
        return result.toArray(stringArray0);
    }

    private boolean setEqual(String[] s1, String[] s2) {
        if (null == s1 && null == s2) {
            return true;
        }
        if (null == s1 || null == s2) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        return this.setDiff(s1, s2).length == 0;
    }

    public void addOverride(ConfigurationParameter parmInGroup, String override) {
        this.addOverride(override, this.getTreeItemParm(parmInGroup), parmInGroup);
    }

    private void addOverrideToGUI(TreeItem parent, String override) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(this.OVERRIDE_HEADER + override);
    }

    @Override
    protected void fillOverrides(TreeItem parent, ConfigurationParameter modelCP) {
        String[] overrides;
        if (this.isAggregate() && (overrides = modelCP.getOverrides()) != null) {
            for (int i = 0; i < overrides.length; ++i) {
                this.addOverrideToGUI(parent, overrides[i]);
            }
            parent.setExpanded(true);
        }
    }

    private void addOverride(String override, TreeItem parent, ConfigurationParameter cp) {
        cp.setOverrides(this.addOverrideToArray(cp.getOverrides(), override));
        this.addOverrideToGUI(parent, override);
        parent.setExpanded(true);
        this.commonActionFinish();
    }

    private void alterExistingConfigurationParameter(AddParameterDialog dialog, TreeItem existingTreeItem) {
        ConfigurationParameter existingCP;
        ConfigurationParameter previousCP = existingCP = this.getCorrespondingModelParm(existingTreeItem);
        previousCP = (ConfigurationParameter)previousCP.clone();
        this.fillModelParm(dialog, existingCP);
        this.fillParmItem(existingTreeItem, existingCP);
        if (!previousCP.getType().equals(existingCP.getType()) || previousCP.isMultiValued() != existingCP.isMultiValued()) {
            this.removeParmSettingFromMultipleGroups(existingTreeItem, false);
        }
        this.commonParmUpdate(existingTreeItem, existingCP, previousCP.getName());
    }

    private void commonParmUpdate(TreeItem existingTreeItem, ConfigurationParameter existingCP, String prevName) {
        this.updateParmInSettingsGUI(existingCP, existingTreeItem, prevName);
        String newName = existingCP.getName();
        if (!newName.equals(prevName)) {
            ConfigurationParameterSettings cps = this.getModelSettings();
            String[] allGroupNames = new String[]{null};
            if (this.usingGroupsButton.getSelection()) {
                allGroupNames = (String[])Utility.addElementToArray(this.getAllGroupNames(), null, String.class);
            }
            for (int i = 0; i < allGroupNames.length; ++i) {
                Object value = cps.getParameterValue(allGroupNames[i], prevName);
                if (null == value) continue;
                cps.setParameterValue(allGroupNames[i], newName, value);
                cps.setParameterValue(allGroupNames[i], prevName, null);
            }
        }
    }

    private void fillModelParm(AddParameterDialog dialog, ConfigurationParameter existingCP) {
        this.valueChanged = false;
        existingCP.setName(this.setValueChanged(dialog.parmName, existingCP.getName()));
        existingCP.setDescription(this.setValueChanged(this.multiLineFix(dialog.description), existingCP.getDescription()));
        existingCP.setMandatory(this.setValueChangedBoolean(dialog.mandatory, existingCP.isMandatory()));
        existingCP.setMultiValued(this.setValueChangedBoolean(dialog.multiValue, existingCP.isMultiValued()));
        existingCP.setType(this.setValueChanged(dialog.parmType, existingCP.getType()));
        existingCP.setExternalOverrideName(this.setValueChanged(dialog.extParmName, existingCP.getExternalOverrideName()));
        if (this.valueChanged) {
            this.setFileDirty();
        }
    }

    private ConfigurationParameter addNewConfigurationParameter(AddParameterDialog dialog, TreeItem group) {
        ConfigurationParameter_impl newCP = new ConfigurationParameter_impl();
        this.fillModelParm(dialog, (ConfigurationParameter)newCP);
        if (null != group) {
            String groupName = this.getName(group.getText());
            if (groupName.equals(COMMON_GROUP)) {
                this.commonParms = this.addParmToArray(this.cpd.getCommonParameters(), (ConfigurationParameter)newCP);
                this.cpd.setCommonParameters(this.commonParms);
            } else if (groupName.equals(NOT_IN_ANY_GROUP)) {
                this.cpd.setConfigurationParameters(this.addParmToArray(this.cpd.getConfigurationParameters(), (ConfigurationParameter)newCP));
            } else {
                ConfigurationGroup cg = this.getConfigurationGroup(groupName);
                cg.setConfigurationParameters(this.addParmToArray(cg.getConfigurationParameters(), (ConfigurationParameter)newCP));
            }
        } else {
            throw new InternalErrorCDE("invalid state");
        }
        this.addNewConfigurationParameterToGUI((ConfigurationParameter)newCP, group);
        return newCP;
    }

    private void addGroupToModel(ConfigurationGroup newCg) {
        ConfigurationGroup[] newCgs;
        ConfigurationGroup[] oldCgs = this.cpd.getConfigurationGroups();
        if (null == oldCgs) {
            newCgs = new ConfigurationGroup[1];
        } else {
            newCgs = new ConfigurationGroup[oldCgs.length + 1];
            System.arraycopy(oldCgs, 0, newCgs, 0, oldCgs.length);
        }
        newCgs[newCgs.length - 1] = newCg;
        this.cpd.setConfigurationGroups(newCgs);
    }

    private String[] addOverrideToArray(String[] overrides, String newOverride) {
        if (null == overrides) {
            return new String[]{newOverride};
        }
        String[] newOverrides = new String[overrides.length + 1];
        System.arraycopy(overrides, 0, newOverrides, 0, overrides.length);
        newOverrides[overrides.length] = newOverride;
        return newOverrides;
    }

    private ConfigurationParameter[] addParmToArray(ConfigurationParameter[] cps, ConfigurationParameter newCP) {
        if (null == cps) {
            return new ConfigurationParameter[]{newCP};
        }
        ConfigurationParameter[] newCps = new ConfigurationParameter[cps.length + 1];
        System.arraycopy(cps, 0, newCps, 0, cps.length);
        newCps[cps.length] = newCP;
        return newCps;
    }

    private boolean groupNameAlreadyDefined(String[] names) {
        ConfigurationGroup[] cgs = this.cpd.getConfigurationGroups();
        if (null != cgs) {
            for (int i = 0; i < cgs.length; ++i) {
                if (!this.setEqual(names, cgs[i].getNames())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean parameterNameAlreadyDefinedNoMsg(String name, ConfigurationParameterDeclarations pCpd) {
        if (pCpd.getCommonParameters() != null && ParameterSection.parameterInArray(name, pCpd.getCommonParameters())) {
            return true;
        }
        if (pCpd.getConfigurationParameters() != null && ParameterSection.parameterInArray(name, pCpd.getConfigurationParameters())) {
            return true;
        }
        ConfigurationGroup[] groups = pCpd.getConfigurationGroups();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (!ParameterSection.parameterInArray(name, groups[i].getConfigurationParameters())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean parameterNameAlreadyDefinedNoMsg(String name, ConfigGroup cgset) {
        if (cgset.getKind() == 1) {
            return ParameterSection.parameterInArray(name, cgset.getConfigParms());
        }
        if (ParameterSection.parameterInArray(name, cgset.getCPD().getCommonParameters())) {
            return true;
        }
        for (ConfigurationGroup cg : cgset.getCPD().getConfigurationGroups()) {
            if (cgset.getKind() != 2 && !ParameterSection.haveSharedGroup(cgset.getNameArray(), cg.getNames()) || !ParameterSection.parameterInArray(name, cg.getConfigurationParameters())) continue;
            return true;
        }
        return false;
    }

    public static boolean haveSharedGroup(String[] set1, String[] set2) {
        for (String s1 : set1) {
            for (String s2 : set2) {
                if (!s1.equals(s2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean parameterNameAlreadyDefined(String name, ConfigGroup cgset) {
        boolean alreadyDefined = this.parameterNameAlreadyDefinedNoMsg(name, cgset);
        if (alreadyDefined) {
            Utility.popMessage("Parameter Already Defined", "The following parameter is already defined in the list. Parameter names must be unique.\n\nParameter: " + name + (String)(cgset.getKind() == 1 ? "" : "\nGroup: " + cgset.getName()), 1);
        }
        return alreadyDefined;
    }

    private static boolean parameterInArray(String name, ConfigurationParameter[] cps) {
        for (int i = 0; i < cps.length; ++i) {
            if (!name.equals(cps[i].getName())) continue;
            return true;
        }
        return false;
    }

    private void commonActionFinish() {
        this.valueChanged = true;
        this.commonActionFinishDirtyIfChange();
    }

    private void commonActionFinishDirtyIfChange() {
        if (this.valueChanged) {
            this.setFileDirty();
        }
        this.enable();
    }

    @Override
    public void enable() {
        this.usingGroupsButton.setEnabled(!this.isAggregate());
        boolean usingGroups = this.usingGroupsButton.getSelection();
        this.groupingControl.setVisible(usingGroups);
        this.addButton.setEnabled(this.isPrimitive() || this.tree.getSelectionCount() == 1 && (this.isParmSelection() || this.isOverrideSelection()));
        this.addGroupButton.setEnabled(this.isPrimitive() && usingGroups);
        this.removeButton.setEnabled(this.tree.getSelectionCount() == 1 && (this.isParmSelection() || this.isGroupSelection() || this.isOverrideSelection()));
        this.editButton.setEnabled(this.tree.getSelectionCount() == 1 && (this.isParmSelection() || this.isOverrideSelection() || this.isPrimitive() && this.isGroupSelection() && !this.isCommonGroupSelection()));
    }

    public Tree getTree() {
        return this.tree;
    }

    private TreeItem getTreeItemParm(ConfigurationParameter p) {
        TreeItem[] groups = this.tree.getItems();
        for (int i = 0; i < groups.length; ++i) {
            TreeItem[] parms = groups[i].getItems();
            for (int j = 0; j < parms.length; ++j) {
                if (this.getCorrespondingModelParm(parms[j]) != p) continue;
                return parms[j];
            }
        }
        throw new InternalErrorCDE("invalid state");
    }

    private TreeItem getTreeItemGroup(ConfigGroup g) {
        switch (g.getKind()) {
            case 1: {
                return this.tree.getItems()[0];
            }
            case 2: {
                return this.tree.getItems()[1];
            }
        }
        TreeItem[] items = this.tree.getItems();
        for (int i = 2; i < items.length; ++i) {
            if (!this.getName(items[i].getText()).equals(g.getName())) continue;
            return items[i];
        }
        throw new InternalErrorCDE("invalid state");
    }

    private TreeItem getSettingsTreeGroup(String groupName) {
        TreeItem[] items = this.settingsTree.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!groupName.equals(this.getName(items[i].getText()))) continue;
            return items[i];
        }
        return null;
    }
}

