/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class SwitchStatement
extends Statement {
    public static final TokenRole SWITCH_KEYWORD_ROLE = new TokenRole("switch", 1);
    public static final Role<SwitchSection> SWITCH_SECTION_ROLE = new Role<SwitchSection>("SwitchSection", SwitchSection.class);

    public SwitchStatement(Expression testExpression) {
        super(testExpression.getOffset());
        this.setExpression(testExpression);
    }

    public final JavaTokenNode getReturnToken() {
        return this.getChildByRole(SWITCH_KEYWORD_ROLE);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final JavaTokenNode getLeftBraceToken() {
        return this.getChildByRole(Roles.LEFT_BRACE);
    }

    public final AstNodeCollection<SwitchSection> getSwitchSections() {
        return this.getChildrenByRole(SWITCH_SECTION_ROLE);
    }

    public final JavaTokenNode getRightBraceToken() {
        return this.getChildByRole(Roles.RIGHT_BRACE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSwitchStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof SwitchStatement) {
            SwitchStatement otherStatement = (SwitchStatement)other;
            return !otherStatement.isNull() && this.getExpression().matches(otherStatement.getExpression(), match) && this.getSwitchSections().matches(otherStatement.getSwitchSections(), match);
        }
        return false;
    }
}

