/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.config.Task;

public final class ScheduledTask {
    private final Task task;
    @Nullable
    volatile ScheduledFuture<?> future;

    ScheduledTask(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    public void cancel() {
        this.cancel(true);
    }

    public void cancel(boolean mayInterruptIfRunning) {
        ScheduledFuture<?> future = this.future;
        if (future != null) {
            future.cancel(mayInterruptIfRunning);
        }
    }

    @Nullable
    public Instant nextExecution() {
        long delay;
        ScheduledFuture<?> future = this.future;
        if (future != null && !future.isCancelled() && (delay = future.getDelay(TimeUnit.MILLISECONDS)) > 0L) {
            return Instant.now().plusMillis(delay);
        }
        return null;
    }

    public String toString() {
        return this.task.toString();
    }
}

