/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public final class KeyedQueue<K, V> {
    private final Map<K, Queue<V>> _data = new HashMap<K, Queue<V>>();

    private Queue<V> getQueue(K key) {
        Queue<V> queue = this._data.get(key);
        if (queue == null) {
            queue = new ArrayDeque<V>();
            this._data.put(key, queue);
        }
        return queue;
    }

    public boolean add(K key, V value) {
        return this.getQueue(key).add(value);
    }

    public boolean offer(K key, V value) {
        return this.getQueue(key).offer(value);
    }

    public V poll(K key) {
        return this.getQueue(key).poll();
    }

    public V peek(K key) {
        return this.getQueue(key).peek();
    }

    public int size(K key) {
        Queue<V> queue = this._data.get(key);
        return queue != null ? queue.size() : 0;
    }

    public void clear() {
        this._data.clear();
    }
}

