/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.asb.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.asb.ASB;
import org.apache.uima.analysis_engine.asb.impl.FlowContainer;
import org.apache.uima.analysis_engine.asb.impl.FlowControllerContainer;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.analysis_engine.impl.EmptyCasIterator;
import org.apache.uima.analysis_engine.impl.PrimitiveAnalysisEngine_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.analysis_engine.metadata.impl.AnalysisEngineMetaData_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.ParallelStep;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.SimpleStepWithResultSpec;
import org.apache.uima.flow.Step;
import org.apache.uima.flow.impl.FlowControllerContext_impl;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.UimaTimer;

public class ASB_impl
extends Resource_ImplBase
implements ASB {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<ASB_impl> CLASS_NAME = ASB_impl.class;
    private Map<String, AnalysisEngine> mComponentAnalysisEngineMap = new LinkedHashMap<String, AnalysisEngine>();
    private Map<String, AnalysisEngineMetaData> mComponentAnalysisEngineMetaDataMap = new HashMap<String, AnalysisEngineMetaData>();
    private Map<String, ProcessingResourceMetaData> mAllComponentMetaDataMap = new LinkedHashMap<String, ProcessingResourceMetaData>();
    private Map<String, Object> mInitParams;
    private SofaMapping[] mSofaMappings;
    private FlowControllerContainer mFlowControllerContainer;
    private boolean mOutputNewCASes;
    private UimaContextAdmin mAggregateUimaContext;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", LOG_RESOURCE_BUNDLE, "UIMA_asb_init_begin__CONFIG");
        if (!(aSpecifier instanceof ResourceCreationSpecifier)) {
            return false;
        }
        aAdditionalParams = new HashMap<String, Object>(aAdditionalParams);
        super.initialize(aSpecifier, aAdditionalParams);
        this.mInitParams = aAdditionalParams;
        this.mSofaMappings = (SofaMapping[])this.mInitParams.remove("AGGREGATE_SOFA_MAPPINGS");
        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", LOG_RESOURCE_BUNDLE, "UIMA_asb_init_successful__CONFIG");
        return true;
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, AnalysisEngine> entry : this.mComponentAnalysisEngineMap.entrySet()) {
            Resource delegate = entry.getValue();
            delegate.destroy();
        }
        if (this.mFlowControllerContainer != null && this.mFlowControllerContainer.isInitialized()) {
            this.mFlowControllerContainer.destroy();
        }
    }

    @Override
    public void setup(Map<String, ResourceSpecifier> aSpecifiers, UimaContextAdmin aParentContext, FlowControllerDeclaration aFlowControllerDeclaration, AnalysisEngineMetaData aAggregateMetadata) throws ResourceInitializationException {
        this.mAggregateUimaContext = aParentContext;
        this.mComponentAnalysisEngineMap.clear();
        this.mComponentAnalysisEngineMetaDataMap.clear();
        this.mAllComponentMetaDataMap.clear();
        for (Map.Entry<String, ResourceSpecifier> entry : aSpecifiers.entrySet()) {
            String key = entry.getKey();
            ResourceSpecifier spec = entry.getValue();
            TreeMap<String, String> sofamap = new TreeMap<String, String>();
            if (this.mSofaMappings != null && this.mSofaMappings.length > 0) {
                for (int s = 0; s < this.mSofaMappings.length; ++s) {
                    if (!this.mSofaMappings[s].getComponentKey().equals(key)) continue;
                    if (this.mSofaMappings[s].getComponentSofaName() == null) {
                        this.mSofaMappings[s].setComponentSofaName("_InitialView");
                    }
                    sofamap.put(this.mSofaMappings[s].getComponentSofaName(), this.mSofaMappings[s].getAggregateSofaName());
                }
            }
            if (this.mInitParams == null) {
                this.mInitParams = new HashMap<String, Object>();
            }
            UimaContextAdmin childContext = aParentContext.createChild(key, sofamap);
            this.mInitParams.put("UIMA_CONTEXT", childContext);
            AnalysisEngine ae = this.mInitParams.containsKey("VERIFICATION_MODE") && !(spec instanceof ResourceCreationSpecifier) ? new DummyAnalysisEngine() : UIMAFramework.produceAnalysisEngine(spec, this.mInitParams);
            this.mComponentAnalysisEngineMap.put(key, ae);
            this.mComponentAnalysisEngineMetaDataMap.put(key, ae.getAnalysisEngineMetaData());
        }
        this.mComponentAnalysisEngineMap = Collections.unmodifiableMap(this.mComponentAnalysisEngineMap);
        this.mComponentAnalysisEngineMetaDataMap = Collections.unmodifiableMap(this.mComponentAnalysisEngineMetaDataMap);
        this.mOutputNewCASes = aAggregateMetadata.getOperationalProperties().getOutputsNewCASes();
        this.initFlowController(aFlowControllerDeclaration, aParentContext, aAggregateMetadata);
        this.mAllComponentMetaDataMap = new LinkedHashMap<String, AnalysisEngineMetaData>(this.mComponentAnalysisEngineMetaDataMap);
        this.mAllComponentMetaDataMap.put(aFlowControllerDeclaration.getKey(), this.mFlowControllerContainer.getProcessingResourceMetaData());
        this.mAllComponentMetaDataMap = Collections.unmodifiableMap(this.mAllComponentMetaDataMap);
    }

    protected void initFlowController(FlowControllerDeclaration aFlowControllerDeclaration, UimaContextAdmin aParentContext, AnalysisEngineMetaData aAggregateMetadata) throws ResourceInitializationException {
        String key = aFlowControllerDeclaration.getKey();
        if (key == null || key.length() == 0) {
            key = "_FlowController";
        }
        HashMap<String, Object> flowControllerParams = new HashMap<String, Object>(this.mInitParams);
        TreeMap<String, String> sofamap = new TreeMap<String, String>();
        if (this.mSofaMappings != null && this.mSofaMappings.length > 0) {
            for (int s = 0; s < this.mSofaMappings.length; ++s) {
                if (!this.mSofaMappings[s].getComponentKey().equals(key)) continue;
                if (this.mSofaMappings[s].getComponentSofaName() == null) {
                    this.mSofaMappings[s].setComponentSofaName("_InitialView");
                }
                sofamap.put(this.mSofaMappings[s].getComponentSofaName(), this.mSofaMappings[s].getAggregateSofaName());
            }
        }
        FlowControllerContext_impl ctxt = new FlowControllerContext_impl(aParentContext, key, sofamap, this.getComponentAnalysisEngineMetaData(), aAggregateMetadata);
        flowControllerParams.put("UIMA_CONTEXT", ctxt);
        flowControllerParams.put("RESOURCE_MANAGER", this.getResourceManager());
        this.mFlowControllerContainer = new FlowControllerContainer();
        this.mFlowControllerContainer.initialize(aFlowControllerDeclaration.getSpecifier(), flowControllerParams);
    }

    @Override
    public Map<String, AnalysisEngineMetaData> getComponentAnalysisEngineMetaData() {
        return this.mComponentAnalysisEngineMetaDataMap;
    }

    @Override
    public Map<String, AnalysisEngine> getComponentAnalysisEngines() {
        return this.mComponentAnalysisEngineMap;
    }

    @Override
    public Map<String, ProcessingResourceMetaData> getAllComponentMetaData() {
        return this.mAllComponentMetaDataMap;
    }

    @Override
    public CasIterator process(CAS aCAS) throws AnalysisEngineProcessException {
        return new AggregateCasIterator(aCAS);
    }

    @Override
    public FlowControllerContainer getFlowControllerContainer() {
        return this.mFlowControllerContainer;
    }

    protected AnalysisEngineManagementImpl getMBean() {
        return (AnalysisEngineManagementImpl)this.mAggregateUimaContext.getManagementInterface();
    }

    private static class DummyAnalysisEngine
    extends PrimitiveAnalysisEngine_impl {
        public DummyAnalysisEngine() {
            this.setMetaData(new AnalysisEngineMetaData_impl());
        }
    }

    class AggregateCasIterator
    implements CasIterator {
        CAS mInputCas;
        Stack<StackFrame> casIteratorStack = new Stack();
        Set<CAS> activeCASes = new HashSet<CAS>();
        CAS nextCas = null;
        UimaTimer timer = UIMAFramework.newTimer();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AggregateCasIterator(CAS inputCas) throws AnalysisEngineProcessException {
            this.timer.startIt();
            try {
                this.mInputCas = inputCas;
                FlowContainer flow = ASB_impl.this.mFlowControllerContainer.computeFlow(inputCas);
                this.casIteratorStack.push(new StackFrame(new EmptyCasIterator(), inputCas, flow, null));
                this.nextCas = this.processUntilNextOutputCas();
                ASB_impl.this.getMBean().incrementCASesProcessed();
            }
            finally {
                this.timer.stopIt();
                ASB_impl.this.getMBean().reportAnalysisTime(this.timer.getDuration());
            }
        }

        @Override
        public boolean hasNext() throws AnalysisEngineProcessException {
            this.timer.startIt();
            try {
                if (this.nextCas == null) {
                    this.nextCas = this.processUntilNextOutputCas();
                }
                boolean bl = this.nextCas != null;
                return bl;
            }
            finally {
                this.timer.stopIt();
                ASB_impl.this.getMBean().reportAnalysisTime(this.timer.getDuration());
            }
        }

        @Override
        public CAS next() throws AnalysisEngineProcessException {
            this.timer.startIt();
            try {
                CAS toReturn = this.nextCas;
                if (toReturn == null) {
                    toReturn = this.processUntilNextOutputCas();
                }
                if (toReturn == null) {
                    throw new UIMA_IllegalStateException("no_next_cas", new Object[0]);
                }
                this.nextCas = null;
                ASB_impl.this.getMBean().incrementCASesProcessed();
                CAS cAS = toReturn;
                return cAS;
            }
            finally {
                this.timer.stopIt();
                ASB_impl.this.getMBean().reportAnalysisTime(this.timer.getDuration());
            }
        }

        @Override
        public void release() {
            while (!this.casIteratorStack.isEmpty()) {
                StackFrame frame = this.casIteratorStack.pop();
                frame.originalCasFlow.aborted();
                frame.casIterator.release();
            }
            for (CAS cas : this.activeCASes) {
                if (cas == this.mInputCas) continue;
                cas.release();
            }
            this.activeCASes.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CAS processUntilNextOutputCas() throws AnalysisEngineProcessException {
            FlowContainer flow = null;
            try {
                while (true) {
                    CAS cas = null;
                    Step nextStep = null;
                    flow = null;
                    while (cas == null) {
                        if (this.casIteratorStack.isEmpty()) {
                            return null;
                        }
                        StackFrame frame = this.casIteratorStack.peek();
                        try {
                            if (frame.casIterator.hasNext()) {
                                cas = frame.casIterator.next();
                                flow = frame.originalCasFlow.newCasProduced(cas, frame.casMultiplierAeKey);
                            }
                        }
                        catch (Exception e) {
                            if (!frame.originalCasFlow.continueOnFailure(frame.casMultiplierAeKey, e)) {
                                throw e;
                            }
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "processUntilNextOutputCas", ASB_impl.LOG_RESOURCE_BUNDLE, "UIMA_continuing_after_exception__FINE", e);
                        }
                        if (cas != null) continue;
                        cas = frame.originalCas;
                        flow = frame.originalCasFlow;
                        nextStep = frame.incompleteParallelStep;
                        cas.setCurrentComponentInfo(null);
                        this.casIteratorStack.pop();
                    }
                    this.activeCASes.add(cas);
                    if (nextStep == null) {
                        nextStep = flow.next();
                    }
                    while (!(nextStep instanceof FinalStep)) {
                        if (nextStep instanceof SimpleStep) {
                            ResultSpecification rs;
                            String nextAeKey = ((SimpleStep)nextStep).getAnalysisEngineKey();
                            AnalysisEngine nextAe = ASB_impl.this.mComponentAnalysisEngineMap.get(nextAeKey);
                            if (nextAe == null) throw new AnalysisEngineProcessException("unknown_id_in_sequence", new Object[]{nextAeKey});
                            if (nextStep instanceof SimpleStepWithResultSpec && (rs = ((SimpleStepWithResultSpec)nextStep).getResultSpecification()) != null) {
                                nextAe.setResultSpecification(rs);
                            }
                            CasIterator casIter = null;
                            CAS outputCas = null;
                            try {
                                casIter = nextAe.processAndOutputNewCASes(cas);
                                if (casIter.hasNext()) {
                                    outputCas = casIter.next();
                                }
                            }
                            catch (Exception e) {
                                if (!flow.continueOnFailure(nextAeKey, e)) {
                                    throw e;
                                }
                                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "processUntilNextOutputCas", ASB_impl.LOG_RESOURCE_BUNDLE, "UIMA_continuing_after_exception__FINE", e);
                            }
                            if (outputCas != null) {
                                this.casIteratorStack.push(new StackFrame(casIter, cas, flow, nextAeKey));
                                flow = flow.newCasProduced(outputCas, nextAeKey);
                                cas = outputCas;
                                this.activeCASes.add(cas);
                            } else {
                                cas.setCurrentComponentInfo(null);
                            }
                        } else {
                            if (!(nextStep instanceof ParallelStep)) throw new AnalysisEngineProcessException("unsupported_step_type", new Object[]{nextStep.getClass()});
                            LinkedList<String> destinations = new LinkedList<String>(((ParallelStep)nextStep).getAnalysisEngineKeys());
                            while (!destinations.isEmpty()) {
                                String nextAeKey = (String)destinations.get(0);
                                destinations.remove(0);
                                AnalysisEngine nextAe = ASB_impl.this.mComponentAnalysisEngineMap.get(nextAeKey);
                                if (nextAe == null) throw new AnalysisEngineProcessException("unknown_id_in_sequence", new Object[]{nextAeKey});
                                CasIterator casIter = null;
                                CAS outputCas = null;
                                try {
                                    casIter = nextAe.processAndOutputNewCASes(cas);
                                    if (casIter.hasNext()) {
                                        outputCas = casIter.next();
                                    }
                                }
                                catch (Exception e) {
                                    if (!flow.continueOnFailure(nextAeKey, e)) {
                                        throw e;
                                    }
                                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "processUntilNextOutputCas", ASB_impl.LOG_RESOURCE_BUNDLE, "UIMA_continuing_after_exception__FINE", e);
                                }
                                if (outputCas != null) {
                                    if (!destinations.isEmpty()) {
                                        this.casIteratorStack.push(new StackFrame(casIter, cas, flow, nextAeKey, new ParallelStep(destinations)));
                                    } else {
                                        this.casIteratorStack.push(new StackFrame(casIter, cas, flow, nextAeKey));
                                    }
                                    flow = flow.newCasProduced(outputCas, nextAeKey);
                                    cas = outputCas;
                                    this.activeCASes.add(cas);
                                    break;
                                }
                                cas.setCurrentComponentInfo(null);
                            }
                        }
                        nextStep = flow.next();
                    }
                    assert (nextStep instanceof FinalStep);
                    FinalStep finalStep = (FinalStep)nextStep;
                    this.activeCASes.remove(cas);
                    if (cas == this.mInputCas) {
                        if (!finalStep.getForceCasToBeDropped()) return null;
                        throw new AnalysisEngineProcessException("illegal_drop_cas", new Object[0]);
                    }
                    if (ASB_impl.this.mOutputNewCASes && !finalStep.getForceCasToBeDropped()) {
                        return cas;
                    }
                    cas.release();
                }
            }
            catch (Exception e) {
                if (flow != null) {
                    flow.aborted();
                }
                this.release();
                if (!(e instanceof AnalysisEngineProcessException)) throw new AnalysisEngineProcessException(e);
                throw (AnalysisEngineProcessException)e;
            }
        }
    }

    static class StackFrame {
        CasIterator casIterator;
        CAS originalCas;
        FlowContainer originalCasFlow;
        String casMultiplierAeKey;
        ParallelStep incompleteParallelStep;

        StackFrame(CasIterator casIterator, CAS originalCas, FlowContainer originalCasFlow, String lastAeKey) {
            this(casIterator, originalCas, originalCasFlow, lastAeKey, null);
        }

        StackFrame(CasIterator casIterator, CAS originalCas, FlowContainer originalCasFlow, String lastAeKey, ParallelStep incompleteParallelStep) {
            this.casIterator = casIterator;
            this.originalCas = originalCas;
            this.originalCasFlow = originalCasFlow;
            this.casMultiplierAeKey = lastAeKey;
            this.incompleteParallelStep = incompleteParallelStep;
        }
    }
}

