/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class PearProjectCustomizationException
extends Exception {
    public static final String PLUGIN_ID = "org.apache.uima.pear";
    private static final long serialVersionUID = 1L;

    public PearProjectCustomizationException() {
    }

    public PearProjectCustomizationException(String message) {
        super(message);
    }

    public PearProjectCustomizationException(Throwable cause) {
        super(cause);
    }

    public PearProjectCustomizationException(String message, Throwable cause) {
        super(message, cause);
    }

    public IStatus[] getCustomStackTrace() {
        Object[] o = this.getCustomStackTrace(this.getCause()).toArray();
        if (o != null) {
            IStatus[] sa = new IStatus[o.length];
            for (int i = 0; i < o.length; ++i) {
                sa[i] = (IStatus)o[i];
            }
            return sa;
        }
        return new IStatus[0];
    }

    synchronized ArrayList getCustomStackTrace(Throwable e) {
        ArrayList<Status> a = new ArrayList<Status>();
        if (e != null) {
            String msg = e.getMessage();
            msg = msg == null ? "" : msg;
            a.add(new Status(4, PLUGIN_ID, 4, msg, e));
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                a.add(new Status(4, PLUGIN_ID, 4, "   at " + trace[i], e));
            }
            Throwable aCause = e.getCause();
            if (aCause != null) {
                a.addAll(this.getCustomStackTrace(aCause));
            }
        }
        return a;
    }

    public void openErrorDialog(Shell shell) {
        try {
            this.getCause().printStackTrace();
            String msg = this.getCause().getMessage();
            msg = msg == null ? "" : msg;
            MultiStatus status = new MultiStatus(PLUGIN_ID, 4, this.getCustomStackTrace(), msg, this.getCause());
            ErrorDialog.openError((Shell)shell, (String)"Project Customization Error", (String)(this.getMessage() + " \nPlease see the details (below)."), (IStatus)status, (int)65535);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void openErrorDialog(Throwable e, Shell shell) {
        PearProjectCustomizationException subEx = new PearProjectCustomizationException("A error occured during the project customization process.", e);
        subEx.openErrorDialog(shell);
    }
}

