/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.IMetadataTypeMember;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;

public abstract class ParameterReference
implements IMetadataTypeMember {
    private String _name;
    private int _position = -1;
    private TypeReference _parameterType;

    protected ParameterReference(String name, TypeReference parameterType) {
        this._name = name != null ? name : "";
        this._parameterType = (TypeReference)VerifyArgument.notNull((Object)parameterType, (String)"parameterType");
    }

    @Override
    public abstract TypeReference getDeclaringType();

    @Override
    public String getName() {
        if (StringUtilities.isNullOrEmpty((String)this._name)) {
            if (this._position < 0) {
                return this._name;
            }
            return "p" + this._position;
        }
        return this._name;
    }

    public final boolean hasName() {
        return !StringUtilities.isNullOrEmpty((String)this._name);
    }

    protected void setName(String name) {
        this._name = name;
    }

    public int getPosition() {
        return this._position;
    }

    protected void setPosition(int position) {
        this._position = position;
    }

    public TypeReference getParameterType() {
        return this._parameterType;
    }

    protected void setParameterType(TypeReference parameterType) {
        this._parameterType = parameterType;
    }

    public String toString() {
        return this.getName();
    }

    public abstract ParameterDefinition resolve();
}

