/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.impl.TypeOrFeature_impl;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.SofaMapSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddCapabilityFeatureDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddCapabilityTypeDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddSofaDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.CommonInputDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class CapabilitySection
extends AbstractSection {
    private static final String CAPABILITY_SET = "Set";
    private static final String INPUT = "Input";
    private static final String OUTPUT = "Output";
    public static final String ALL_FEATURES = "<all features>";
    private static final String TYPE_TITLE = "Type:";
    private static final String FEAT_TITLE = "F:";
    private static final String NAME_TITLE = "Name                ";
    private static final String NAMESPACE_TITLE = "Name Space";
    private static final String LANGS_TITLE = "Languages";
    private static final String LANG_TITLE = "L:";
    private static final String SOFAS_TITLE = "Sofas";
    private static final String SOFA_TITLE = "S:";
    private static final int CS = 1;
    private static final int TYPE = 2;
    private static final int FEAT = 4;
    private static final int LANG = 8;
    private static final int LANG_ITEM = 16;
    private static final int SOFA = 32;
    private static final int SOFA_ITEM = 64;
    public static final int TITLE_COL = 0;
    public static final int NAME_COL = 1;
    public static final int INPUT_COL = 2;
    public static final int OUTPUT_COL = 3;
    public static final int NAMESPACE_COL = 4;
    Tree tt;
    private Button addCapabilityButton;
    private Button addLangButton;
    private Button addTypeButton;
    private Button addSofaButton;
    private Button addEditFeatureButton;
    private Button editButton;
    private Button removeButton;
    private Map typeInfo;
    private SofaMapSection sofaMapSection;

    public CapabilitySection(MultiPageEditor aEditor, Composite parent) {
        super(aEditor, parent, "Component Capabilities", "This section describes the languages handled, and the inputs needed and outputs provided in terms of the Types and Features.");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.toolkit.paintBordersFor(sectionClient);
        this.tt = this.newTree(sectionClient, 66052);
        new TreeColumn(this.tt, 0).setText("                 ");
        this.newTreeColumn(this.tt, 0).setText(NAME_TITLE);
        this.newTreeColumn(this.tt, 0).setText(INPUT);
        this.newTreeColumn(this.tt, 0).setText(OUTPUT);
        this.newTreeColumn(this.tt, 0).setText(NAMESPACE_TITLE);
        this.tt.setHeaderVisible(true);
        this.tt.setLinesVisible(true);
        this.tt.addListener(32, (Listener)this);
        Composite buttonContainer = this.newButtonContainer(sectionClient);
        this.addCapabilityButton = this.newPushButton(buttonContainer, "Add Capability Set", "Analysis Engines can have one or more sets of capabilities; each one describes a set of outputs that are produced, given a particular set of inputs. Click here to add a capability set.");
        this.addLangButton = this.newPushButton(buttonContainer, "Add Language", "Click here to add a Language Capability to the selected set.");
        this.addTypeButton = this.newPushButton(buttonContainer, "Add Type", "Click here to add a Type to the selected capability set.");
        this.addSofaButton = this.newPushButton(buttonContainer, "Add Sofa", "Click here to add a Subject of Analysis (Sofa) to the selected capability set.");
        this.addEditFeatureButton = this.newPushButton(buttonContainer, "Add/Edit Features", "Click here to specify the features of a selected type as input or output");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Remove the selected item.  You can also press the Delete key to remove an item.");
    }

    public void refresh() {
        super.refresh();
        this.sofaMapSection = this.editor.getCapabilityPage().getSofaMapSection();
        this.tt.getParent().setRedraw(false);
        this.tt.removeAll();
        Capability[] cs = this.getCapabilities();
        if (null != cs) {
            for (int i = 0; i < cs.length; ++i) {
                TreeItem item = new TreeItem(this.tt, 0);
                item.setText(0, CAPABILITY_SET);
                item.setData((Object)cs[i]);
                this.tt.setSelection(item);
                this.fillCapability(item, cs[i]);
                item.setExpanded(true);
                TreeItem[] types = item.getItems();
                if (types == null) continue;
                for (int j = 0; j < types.length; ++j) {
                    types[j].setExpanded(true);
                }
            }
        }
        this.packTree(this.tt);
        this.enable();
        this.tt.getParent().setRedraw(true);
    }

    private TreeItem createLanguageHeaderGui(TreeItem parent) {
        TreeItem langHdr = new TreeItem(parent, 0);
        langHdr.setText(0, LANGS_TITLE);
        langHdr.setData((Object)LANGS_TITLE);
        return langHdr;
    }

    private TreeItem createSofaHeaderGui(TreeItem parent) {
        TreeItem sofaHdr = new TreeItem(parent, 0);
        sofaHdr.setText(0, SOFAS_TITLE);
        sofaHdr.setData((Object)SOFAS_TITLE);
        return sofaHdr;
    }

    private void fillCapability(TreeItem parent, Capability c) {
        FeatureCapability fc;
        String name;
        int i;
        TreeItem item;
        int i2;
        TreeItem langHdr = this.createLanguageHeaderGui(parent);
        String[] languages = c.getLanguagesSupported();
        if (null != languages) {
            for (int i3 = 0; i3 < languages.length; ++i3) {
                TreeItem lItem = new TreeItem(langHdr, 0);
                lItem.setData((Object)LANG_TITLE);
                lItem.setText(1, languages[i3]);
            }
        }
        TreeItem sofaHdr = this.createSofaHeaderGui(parent);
        Object[] inputSofaNames = c.getInputSofas();
        Object[] outputSofaNames = c.getOutputSofas();
        Arrays.sort(inputSofaNames);
        Arrays.sort(outputSofaNames);
        for (i2 = 0; i2 < inputSofaNames.length; ++i2) {
            item = new TreeItem(sofaHdr, 0);
            this.setGuiSofaName(item, (String)inputSofaNames[i2], true);
        }
        for (i2 = 0; i2 < outputSofaNames.length; ++i2) {
            item = new TreeItem(sofaHdr, 0);
            this.setGuiSofaName(item, (String)outputSofaNames[i2], false);
        }
        TypeCapability tc = null;
        TypeOrFeature[] inputs = c.getInputs();
        TypeOrFeature[] outputs = c.getOutputs();
        this.typeInfo = new TreeMap();
        if (null != inputs) {
            for (i = 0; i < inputs.length; ++i) {
                name = inputs[i].getName();
                if (inputs[i].isType()) {
                    tc = this.getTypeCapability(name);
                    tc.isInputType = true;
                    if (!inputs[i].isAllAnnotatorFeatures()) continue;
                    fc = this.getFeatureCapability(tc, ALL_FEATURES);
                    fc.isInputFeature = true;
                    continue;
                }
                tc = this.getTypeCapability(this.getTypeNameFromFullFeatureName(name));
                fc = this.getFeatureCapability(tc, CapabilitySection.getShortFeatureName(name));
                fc.isInputFeature = true;
            }
        }
        if (null != outputs) {
            for (i = 0; i < outputs.length; ++i) {
                name = outputs[i].getName();
                if (outputs[i].isType()) {
                    tc = this.getTypeCapability(name);
                    tc.isOutputType = true;
                    if (!outputs[i].isAllAnnotatorFeatures()) continue;
                    fc = this.getFeatureCapability(tc, ALL_FEATURES);
                    fc.isOutputType = true;
                    continue;
                }
                tc = this.getTypeCapability(this.getTypeNameFromFullFeatureName(name));
                fc = this.getFeatureCapability(tc, CapabilitySection.getShortFeatureName(name));
                fc.isOutputUpdate = true;
            }
        }
        for (Map.Entry entry : this.typeInfo.entrySet()) {
            String typeName = (String)entry.getKey();
            tc = (TypeCapability)entry.getValue();
            TreeItem item2 = new TreeItem(parent, 0);
            this.setGuiTypeName(item2, typeName);
            if (tc.isInputType) {
                item2.setText(2, INPUT);
            }
            if (tc.isOutputType) {
                item2.setText(3, OUTPUT);
            }
            for (Map.Entry fEntry : tc.features.entrySet()) {
                String featName = (String)fEntry.getKey();
                fc = (FeatureCapability)fEntry.getValue();
                TreeItem fItem = new TreeItem(item2, 0);
                fItem.setData((Object)FEAT_TITLE);
                fItem.setText(1, featName);
                if (fc.isInputFeature) {
                    fItem.setText(2, INPUT);
                }
                if (!fc.isOutputUpdate && !fc.isOutputType) continue;
                fItem.setText(3, OUTPUT);
            }
        }
    }

    private void setGuiTypeName(TreeItem item, String typeName) {
        item.setText(0, TYPE_TITLE);
        item.setText(1, CapabilitySection.getShortName(typeName));
        item.setText(4, CapabilitySection.getNameSpace(typeName));
    }

    private void setGuiSofaName(TreeItem item, String sofaName, boolean isInput) {
        item.setData((Object)SOFA_TITLE);
        item.setText(1, sofaName);
        if (isInput) {
            item.setText(2, INPUT);
            item.setText(3, "");
        } else {
            item.setText(3, OUTPUT);
            item.setText(2, "");
        }
    }

    private TypeCapability getTypeCapability(String typeName) {
        TypeCapability typeCapability = (TypeCapability)this.typeInfo.get(typeName);
        if (null == typeCapability) {
            typeCapability = new TypeCapability();
            this.typeInfo.put(typeName, typeCapability);
        }
        return typeCapability;
    }

    private FeatureCapability getFeatureCapability(TypeCapability tc, String featureShortName) {
        FeatureCapability fc = (FeatureCapability)tc.features.get(featureShortName);
        if (null == fc) {
            fc = new FeatureCapability();
            tc.features.put(featureShortName, fc);
        }
        return fc;
    }

    public String getTypeNameFromFullFeatureName(String name) {
        return name.substring(0, name.indexOf(":"));
    }

    public void handleEvent(Event event) {
        if (event.type == 17 || event.type == 18) {
            this.pack04();
            return;
        }
        if (event.widget == this.addCapabilityButton) {
            this.handleAddCapability();
            this.enable();
            return;
        }
        TreeItem selItem = this.tt.getSelection()[0];
        int itemKind = this.getItemKind(selItem);
        if (event.widget == this.addLangButton) {
            this.handleAddLang(selItem, itemKind);
        } else if (event.widget == this.addTypeButton) {
            this.handleAddType(selItem, itemKind);
        } else if (event.widget == this.addSofaButton) {
            this.handleAddSofa(selItem, itemKind);
        } else if (event.widget == this.addEditFeatureButton) {
            this.handleAddEditFeature(selItem, itemKind);
        } else if (event.widget == this.editButton || event.type == 8) {
            this.handleEdit(selItem, itemKind);
        } else if (event.widget == this.removeButton || event.widget == this.tt && event.type == 2 && event.character == '\u007f') {
            this.handleRemove(selItem, itemKind);
        }
        this.enable();
    }

    private void handleAddCapability() {
        Capability newCset = this.addCapabilitySet();
        TreeItem item = new TreeItem(this.tt, 0);
        item.setText(CAPABILITY_SET);
        item.setData((Object)newCset);
        this.createLanguageHeaderGui(item);
        this.createSofaHeaderGui(item);
        item.setExpanded(true);
        this.tt.setSelection(item);
        if (this.tt.getItemCount() == 1) {
            this.tt.getColumn(0).pack();
        }
        this.finishAction();
    }

    private void getOrCreateAllFeatItem(TreeItem editItem, int column, String inOrOut) {
        TreeItem allFeatItem = this.getAllFeatItem(editItem);
        if (null == allFeatItem) {
            allFeatItem = new TreeItem(editItem, 0, 0);
            allFeatItem.setData((Object)FEAT_TITLE);
            allFeatItem.setText(1, ALL_FEATURES);
        }
        allFeatItem.setText(column, inOrOut);
    }

    private TreeItem getAllFeatItem(TreeItem editItem) {
        TreeItem[] subItems = editItem.getItems();
        if (null == subItems || subItems.length == 0) {
            return null;
        }
        TreeItem item = subItems[0];
        if (ALL_FEATURES.equals(item.getText(1))) {
            return item;
        }
        return null;
    }

    private void removeAllFeatItemGui(TreeItem editItem, int column) {
        TreeItem allFeatItem = this.getAllFeatItem(editItem);
        if (null == allFeatItem) {
            return;
        }
        allFeatItem.setText(column, "");
        String otherCol = allFeatItem.getText(column == 2 ? 3 : 2);
        if (null == otherCol || "".equals(otherCol)) {
            allFeatItem.dispose();
        }
    }

    private void handleEdit(TreeItem editItem, int itemKind) {
        Capability c = this.getCapability(editItem);
        switch (itemKind) {
            case 64: {
                boolean existingIsInput = INPUT.equals(editItem.getText(2));
                String existingSofaName = editItem.getText(1);
                AddSofaDialog dialog = new AddSofaDialog(this, c, existingSofaName, existingIsInput);
                if (dialog.open() == 1) {
                    return;
                }
                if (dialog.isInput == existingIsInput && dialog.sofaName.equals(existingSofaName)) {
                    return;
                }
                if (1 == Utility.popOkCancel("Confirm Change to all Capability Sets", "This edit operation will change the Sofa in all Capability Sets in which it is defined.  Please confirm.", 4)) {
                    return;
                }
                Capability[] cSets = this.getCapabilities();
                for (int i = 0; i < cSets.length; ++i) {
                    boolean wasRemoved;
                    Object[] prevSofas;
                    if (existingIsInput) {
                        prevSofas = cSets[i].getInputSofas();
                        cSets[i].setInputSofas((String[])Utility.removeElementsFromArray(prevSofas, existingSofaName, String.class));
                        wasRemoved = prevSofas != cSets[i].getInputSofas();
                    } else {
                        prevSofas = cSets[i].getOutputSofas();
                        cSets[i].setOutputSofas((String[])Utility.removeElementsFromArray(prevSofas, existingSofaName, String.class));
                        boolean bl = wasRemoved = prevSofas != cSets[i].getOutputSofas();
                    }
                    if (!wasRemoved) continue;
                    if (dialog.isInput) {
                        cSets[i].setInputSofas(this.stringArrayAdd(cSets[i].getInputSofas(), dialog.sofaName));
                        continue;
                    }
                    cSets[i].setOutputSofas(this.stringArrayAdd(cSets[i].getOutputSofas(), dialog.sofaName));
                }
                if (!dialog.sofaName.equals(existingSofaName)) {
                    SofaMapping[] mappings = this.getSofaMappings();
                    for (int i = 0; i < mappings.length; ++i) {
                        if (!existingSofaName.equals(mappings[i].getAggregateSofaName())) continue;
                        mappings[i].setAggregateSofaName(dialog.sofaName);
                    }
                }
                this.refresh();
                this.sofaMapSection.markStale();
                this.finishAction();
                this.pack04();
                break;
            }
            case 2: {
                AddCapabilityTypeDialog dialog = new AddCapabilityTypeDialog((AbstractSection)this, c, editItem);
                if (dialog.open() == 1) {
                    return;
                }
                TypeOrFeature typeInput = CapabilitySection.getTypeOrFeature(c.getInputs(), this.getFullyQualifiedName(editItem));
                if (dialog.inputs[0]) {
                    if (null == typeInput) {
                        c.addInputType(dialog.types[0], true);
                        this.getOrCreateAllFeatItem(editItem, 2, INPUT);
                    }
                } else if (null != typeInput) {
                    c.setInputs(this.typeOrFeatureArrayRemove(c.getInputs(), typeInput));
                    this.removeAllFeatItemGui(editItem, 2);
                }
                TypeOrFeature typeOutput = CapabilitySection.getTypeOrFeature(c.getOutputs(), this.getFullyQualifiedName(editItem));
                if (dialog.outputs[0]) {
                    if (null == typeOutput) {
                        c.addOutputType(dialog.types[0], true);
                        this.getOrCreateAllFeatItem(editItem, 3, OUTPUT);
                    }
                } else if (null != typeOutput) {
                    c.setOutputs(this.typeOrFeatureArrayRemove(c.getOutputs(), typeOutput));
                    this.removeAllFeatItemGui(editItem, 3);
                }
                if (dialog.inputs[0] || dialog.outputs[0]) {
                    editItem.setText(2, dialog.inputs[0] ? INPUT : "");
                    editItem.setText(3, dialog.outputs[0] ? OUTPUT : "");
                } else {
                    editItem.dispose();
                    this.pack04();
                }
                this.finishAction();
                break;
            }
            case 16: {
                CommonInputDialog dialog = new CommonInputDialog(this, "Edit Language", "Enter a two letter ISO-639 language code, followed optionally by a two-letter ISO-3166 country code (Examples: fr or fr-CA)", 8, editItem.getText(1));
                if (this.dialogForLanguage(c, dialog) == 1) {
                    return;
                }
                c.getLanguagesSupported()[CapabilitySection.getIndex((TreeItem)editItem)] = dialog.getValue();
                editItem.setText(1, dialog.getValue());
                this.finishAction();
                break;
            }
            case 4: {
                TreeItem typeItem = editItem.getParentItem();
                String typeName = this.getFullyQualifiedName(typeItem);
                Type type = this.editor.getCurrentView().getTypeSystem().getType(typeName);
                AddCapabilityFeatureDialog dialog = new AddCapabilityFeatureDialog((AbstractSection)this, type, c);
                if (dialog.open() == 1) {
                    return;
                }
                this.addOrEditFeature(dialog, typeName, typeItem, c);
                break;
            }
        }
    }

    private boolean anyCapabilitySetDeclaresSofa(String name, boolean isInput) {
        Capability[] cSets = this.getAnalysisEngineMetaData().getCapabilities();
        for (int i = 0; i < cSets.length; ++i) {
            String[] sofaNames = isInput ? cSets[i].getInputSofas() : cSets[i].getOutputSofas();
            for (int j = 0; j < sofaNames.length; ++j) {
                if (!name.equals(sofaNames[j])) continue;
                return true;
            }
        }
        return false;
    }

    private void handleRemove(TreeItem removeItem, int itemKind) {
        int selectionIndex = this.tt.indexOf(this.tt.getSelection()[0]);
        Capability c = this.getCapability(removeItem);
        switch (itemKind) {
            case 1: {
                if (1 == Utility.popOkCancel("Confirm Remove", "This action will remove an entire capability set.  Please confirm.", 4)) {
                    CapabilitySection.maybeSetSelection(this.tt, selectionIndex + 1);
                    return;
                }
                this.removeCapabilitySet(c);
                removeItem.dispose();
                break;
            }
            case 16: {
                c.setLanguagesSupported(this.stringArrayRemove(c.getLanguagesSupported(), removeItem.getText(1)));
                removeItem.dispose();
                break;
            }
            case 64: {
                if (1 == Utility.popOkCancel("Confirm Removal of Sofa", "This action will remove this Sofa as a capability, and delete its mappings if no other capability set declares this Sofa.  Please confirm.", 4)) {
                    CapabilitySection.maybeSetSelection(this.tt, selectionIndex + 1);
                    return;
                }
                String sofaName = removeItem.getText(1);
                boolean isInput = INPUT.equals(removeItem.getText(2));
                if (isInput) {
                    c.setInputSofas((String[])Utility.removeElementFromArray(c.getInputSofas(), sofaName, String.class));
                } else {
                    c.setOutputSofas((String[])Utility.removeElementFromArray(c.getOutputSofas(), sofaName, String.class));
                }
                removeItem.dispose();
                if (this.anyCapabilitySetDeclaresSofa(sofaName, isInput)) break;
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String name = (String)o1;
                        SofaMapping sofaMapping = (SofaMapping)o2;
                        if (name.equals(sofaMapping.getAggregateSofaName())) {
                            return 0;
                        }
                        return 1;
                    }
                };
                this.editor.getAeDescription().setSofaMappings((SofaMapping[])Utility.removeElementsFromArray(this.getSofaMappings(), sofaName, SofaMapping.class, comparator));
                this.sofaMapSection.markStale();
                break;
            }
            case 2: {
                if (1 == Utility.popOkCancel("Confirm Removal of Type", "This action will remove this type as a capability.  Please confirm.", 4)) {
                    CapabilitySection.maybeSetSelection(this.tt, selectionIndex + 1);
                    return;
                }
                TreeItem[] features = removeItem.getItems();
                if (null != features) {
                    for (int i = 0; i < features.length; ++i) {
                        this.removeFeature(c, features[i]);
                    }
                }
                String typeNameToRemove = this.getFullyQualifiedName(removeItem);
                if (this.isInput(removeItem)) {
                    c.setInputs(this.typeOrFeatureArrayRemove(c.getInputs(), typeNameToRemove));
                }
                if (this.isOutput(removeItem)) {
                    c.setOutputs(this.typeOrFeatureArrayRemove(c.getOutputs(), typeNameToRemove));
                }
                removeItem.dispose();
                break;
            }
            case 4: {
                this.removeFeature(c, removeItem);
                break;
            }
            default: {
                throw new InternalErrorCDE("invalid state");
            }
        }
        CapabilitySection.maybeSetSelection(this.tt, selectionIndex - 1);
        this.finishAction();
    }

    private void removeCapabilitySet(Capability c) {
        Capability[] cs = this.getAnalysisEngineMetaData().getCapabilities();
        Capability[] newCs = new Capability[cs.length - 1];
        int j = 0;
        for (int i = 0; i < newCs.length; ++i) {
            if (cs[i] == c) continue;
            newCs[j++] = cs[i];
        }
        this.getAnalysisEngineMetaData().setCapabilities(newCs);
    }

    private boolean isInput(TreeItem item) {
        return INPUT.equals(item.getText(2));
    }

    private boolean isOutput(TreeItem item) {
        return OUTPUT.equals(item.getText(3));
    }

    public static boolean isInput(String fullFeatureName, Capability c) {
        return null != CapabilitySection.getTypeOrFeature(c.getInputs(), fullFeatureName);
    }

    public static boolean isOutput(String fullFeatureName, Capability c) {
        return null != CapabilitySection.getTypeOrFeature(c.getOutputs(), fullFeatureName);
    }

    private void removeFeature(Capability c, TreeItem removeItem) {
        String shortFeatureName = removeItem.getText(1);
        if (shortFeatureName.equals(ALL_FEATURES)) {
            TypeOrFeature tfItem;
            if (this.isInput(removeItem)) {
                tfItem = CapabilitySection.getTypeOrFeature(c.getInputs(), this.getFullyQualifiedName(removeItem.getParentItem()));
                tfItem.setAllAnnotatorFeatures(false);
            }
            if (this.isOutput(removeItem)) {
                tfItem = CapabilitySection.getTypeOrFeature(c.getOutputs(), this.getFullyQualifiedName(removeItem.getParentItem()));
                tfItem.setAllAnnotatorFeatures(false);
            }
        } else {
            String featureNameToRemove = this.getFullyQualifiedName(removeItem.getParentItem()) + ":" + removeItem.getText(1);
            if (this.isInput(removeItem)) {
                c.setInputs(this.typeOrFeatureArrayRemove(c.getInputs(), featureNameToRemove));
            }
            if (this.isOutput(removeItem)) {
                c.setOutputs(this.typeOrFeatureArrayRemove(c.getOutputs(), featureNameToRemove));
            }
        }
        removeItem.dispose();
    }

    public Capability getCapabilityFromTreeItem(TreeItem item) {
        return (Capability)item.getData();
    }

    private void handleAddLang(TreeItem selItem, int itemKind) {
        if (itemKind == 1) {
            selItem = selItem.getItems()[0];
        } else if (itemKind == 16) {
            selItem = selItem.getParentItem();
        } else if (itemKind == 2 || itemKind == 32) {
            selItem = selItem.getParentItem().getItems()[0];
        } else if (itemKind == 4 || itemKind == 64) {
            selItem = selItem.getParentItem().getParentItem().getItems()[0];
        }
        Capability c = this.getCapabilityFromTreeItem(selItem.getParentItem());
        CommonInputDialog dialog = new CommonInputDialog(this, "Add Language", "Enter a two letter ISO-639 language code, followed optionally by a two-letter ISO-3166 country code (Examples: fr or fr-CA)", 8);
        if (this.dialogForLanguage(c, dialog) == 1) {
            return;
        }
        c.setLanguagesSupported(this.stringArrayAdd(c.getLanguagesSupported(), dialog.getValue()));
        TreeItem lItem = new TreeItem(selItem, 0);
        lItem.setData((Object)LANG_TITLE);
        lItem.setText(1, dialog.getValue());
        selItem.setExpanded(true);
        this.pack04();
        this.finishAction();
    }

    private void handleAddType(TreeItem selItem, int itemKind) {
        if (itemKind == 8 || itemKind == 2 || itemKind == 32) {
            selItem = selItem.getParentItem();
        } else if (itemKind == 16 || itemKind == 4 || itemKind == 64) {
            selItem = selItem.getParentItem().getParentItem();
        }
        Capability c = this.getCapabilityFromTreeItem(selItem);
        AddCapabilityTypeDialog dialog = new AddCapabilityTypeDialog(this, c);
        if (dialog.open() == 1) {
            return;
        }
        for (int i = 0; i < dialog.types.length; ++i) {
            if (dialog.inputs[i]) {
                c.addInputType(dialog.types[i], dialog.inputs[i]);
            }
            if (dialog.outputs[i]) {
                c.addOutputType(dialog.types[i], dialog.outputs[i]);
            }
            TreeItem item = new TreeItem(selItem, 0);
            this.setGuiTypeName(item, dialog.types[i]);
            item.setText(2, dialog.inputs[i] ? INPUT : "");
            item.setText(3, dialog.outputs[i] ? OUTPUT : "");
            TreeItem fItem = new TreeItem(item, 0);
            fItem.setData((Object)FEAT_TITLE);
            fItem.setText(1, ALL_FEATURES);
            fItem.setText(2, dialog.inputs[i] ? INPUT : "");
            fItem.setText(3, dialog.outputs[i] ? OUTPUT : "");
            item.setExpanded(true);
        }
        this.pack04();
        selItem.setExpanded(true);
        this.finishAction();
    }

    private void handleAddSofa(TreeItem selItem, int itemKind) {
        if (itemKind == 1) {
            selItem = selItem.getItems()[1];
        } else if (itemKind == 8 || itemKind == 2) {
            selItem = selItem.getParentItem().getItems()[1];
        } else if (itemKind == 16 || itemKind == 4 || itemKind == 64) {
            selItem = selItem.getParentItem().getParentItem().getItems()[1];
        }
        Capability c = this.getCapabilityFromTreeItem(selItem.getParentItem());
        AddSofaDialog dialog = new AddSofaDialog(this, c);
        if (dialog.open() == 1) {
            return;
        }
        if (dialog.isInput) {
            c.setInputSofas(this.stringArrayAdd(c.getInputSofas(), dialog.sofaName));
        } else {
            c.setOutputSofas(this.stringArrayAdd(c.getOutputSofas(), dialog.sofaName));
        }
        TreeItem item = new TreeItem(selItem, 0);
        this.setGuiSofaName(item, dialog.sofaName, dialog.isInput);
        selItem.setExpanded(true);
        this.pack04();
        this.sofaMapSection.markStale();
        this.finishAction();
    }

    private void handleAddEditFeature(TreeItem selItem, int itemKind) {
        if (itemKind == 4) {
            selItem = selItem.getParentItem();
        }
        Capability c = this.getCapabilityFromTreeItem(selItem.getParentItem());
        String typeName = this.getFullyQualifiedName(selItem);
        Type type = this.editor.getCurrentView().getTypeSystem().getType(typeName);
        AddCapabilityFeatureDialog dialog = new AddCapabilityFeatureDialog((AbstractSection)this, type, c);
        if (dialog.open() == 1) {
            return;
        }
        this.addOrEditFeature(dialog, typeName, selItem, c);
    }

    private void addOrEditFeature(AddCapabilityFeatureDialog dialog, String typeName, TreeItem parentItem, Capability c) {
        c.setInputs(this.setAllFeatures(c.getInputs(), typeName, dialog.allFeaturesInput));
        if (dialog.allFeaturesOutput && null == CapabilitySection.getTypeOrFeature(c.getOutputs(), typeName)) {
            Utility.popMessage("Unable to set AllFeatures", "Skipping setting of <All Features> for output, because you must have the type specified itself as an output in order to set the <All Features>.  You can individually set all the features, instead.", 4);
            dialog.allFeaturesOutput = false;
        } else {
            c.setOutputs(this.setAllFeatures(c.getOutputs(), typeName, dialog.allFeaturesOutput));
        }
        TreeItem[] prevFeatGUI = parentItem.getItems();
        for (int i = 0; i < prevFeatGUI.length; ++i) {
            prevFeatGUI[i].dispose();
        }
        if (dialog.allFeaturesInput || dialog.allFeaturesOutput) {
            TreeItem item = new TreeItem(parentItem, 0);
            item.setData((Object)FEAT_TITLE);
            item.setText(1, ALL_FEATURES);
            item.setText(2, dialog.allFeaturesInput ? INPUT : "");
            item.setText(3, dialog.allFeaturesOutput ? OUTPUT : "");
        }
        ArrayList<TypeOrFeature> inputsL = new ArrayList<TypeOrFeature>();
        ArrayList<TypeOrFeature> outputsL = new ArrayList<TypeOrFeature>();
        for (int i = 0; i < dialog.features.length; ++i) {
            String fullName = typeName + ":" + dialog.features[i];
            if (dialog.inputs[i]) {
                inputsL.add(this.newFeature(fullName));
            }
            if (dialog.outputs[i]) {
                outputsL.add(this.newFeature(fullName));
            }
            TreeItem item = new TreeItem(parentItem, 0);
            item.setData((Object)FEAT_TITLE);
            item.setText(1, dialog.features[i]);
            item.setText(2, dialog.inputs[i] ? INPUT : "");
            item.setText(3, dialog.outputs[i] ? OUTPUT : "");
        }
        parentItem.setExpanded(true);
        this.tt.getColumn(1).pack();
        this.tt.setSelection(parentItem);
        c.setInputs(this.replaceFeaturesKeepingTypes(c.getInputs(), typeName, inputsL));
        c.setOutputs(this.replaceFeaturesKeepingTypes(c.getOutputs(), typeName, outputsL));
        this.finishAction();
    }

    private TypeOrFeature newFeature(String name) {
        TypeOrFeature_impl result = new TypeOrFeature_impl();
        result.setType(false);
        result.setName(name);
        return result;
    }

    public String getFullyQualifiedName(TreeItem item) {
        String namespace = item.getText(4);
        String name = item.getText(1);
        return "".equals(namespace) ? name : namespace + "." + name;
    }

    public String getFullyQualifiedName(String namespace, String name) {
        return null == namespace || "".equals(namespace) ? name : namespace + "." + name;
    }

    private TypeOrFeature[] replaceFeaturesKeepingTypes(TypeOrFeature[] items, String typeName, List features) {
        ArrayList<Object> newItems = new ArrayList<Object>();
        typeName = typeName + ':';
        if (null != items) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].isType() && items[i].getName().startsWith(typeName)) continue;
                newItems.add(items[i]);
            }
        }
        Iterator it = features.iterator();
        while (it.hasNext()) {
            newItems.add(it.next());
        }
        return newItems.toArray(new TypeOrFeature[newItems.size()]);
    }

    private TypeOrFeature[] setAllFeatures(TypeOrFeature[] items, String typeName, boolean isAllFeatures) {
        TypeOrFeature type = CapabilitySection.getTypeOrFeature(items, typeName);
        if (null != type) {
            type.setAllAnnotatorFeatures(isAllFeatures);
            return items;
        }
        if (isAllFeatures) {
            throw new InternalErrorCDE("invalid state");
        }
        return items;
    }

    private void finishAction() {
        this.setFileDirty();
    }

    private void pack04() {
        this.tt.getColumn(0).pack();
        this.tt.getColumn(1).pack();
        this.tt.getColumn(4).pack();
    }

    private int getItemKind(TreeItem item) {
        String itemID = item.getText(0);
        if (CAPABILITY_SET.equals(itemID)) {
            return 1;
        }
        if (TYPE_TITLE.equals(itemID)) {
            return 2;
        }
        itemID = (String)item.getData();
        if (LANGS_TITLE.equals(itemID)) {
            return 8;
        }
        if (FEAT_TITLE.equals(itemID)) {
            return 4;
        }
        if (LANG_TITLE.equals(itemID)) {
            return 16;
        }
        if (SOFAS_TITLE.equals(itemID)) {
            return 32;
        }
        if (SOFA_TITLE.equals(itemID)) {
            return 64;
        }
        throw new InternalErrorCDE("invalid state");
    }

    @Override
    public void enable() {
        this.addCapabilityButton.setEnabled(true);
        boolean selectOK = this.tt.getSelectionCount() == 1;
        TreeItem item = selectOK ? this.tt.getSelection()[0] : null;
        int kind = selectOK ? this.getItemKind(item) : 0;
        this.addLangButton.setEnabled(selectOK);
        this.addTypeButton.setEnabled(selectOK);
        this.addSofaButton.setEnabled(selectOK);
        this.addEditFeatureButton.setEnabled((kind & 6) > 0);
        this.editButton.setEnabled((kind & 0x56) > 0);
        this.removeButton.setEnabled((kind & 0x57) > 0);
    }

    private int dialogForLanguage(Capability c, CommonInputDialog dialog) {
        boolean alreadySpecified;
        block0: do {
            if (dialog.open() == 1) {
                return 1;
            }
            String[] languages = c.getLanguagesSupported();
            alreadySpecified = false;
            for (int i = 0; i < languages.length; ++i) {
                if (!languages[i].equals(dialog.getValue())) continue;
                Utility.popMessage("Language spec already defined", "The language specification you entered is already specified.\nPlease enter a different specification, or Cancel this operation.\n\nLanguage: " + dialog.getValue(), 1);
                alreadySpecified = true;
                continue block0;
            }
        } while (alreadySpecified);
        return 0;
    }

    private Capability getCapability(TreeItem item) {
        while (null != item.getParentItem()) {
            item = item.getParentItem();
        }
        return this.getCapabilityFromTreeItem(item);
    }

    private static class FeatureCapability {
        boolean isInputFeature = false;
        boolean isOutputType = false;
        boolean isOutputUpdate = false;

        private FeatureCapability() {
        }
    }

    private static class TypeCapability {
        boolean isInputType;
        boolean isOutputType;
        Map features = new TreeMap();

        private TypeCapability() {
        }
    }
}

