/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.apache.logging.slf4j.Log4jMarker;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.impl.Logger_common_impl;
import org.slf4j.Marker;

public class Log4jLogger_impl
extends Logger_common_impl {
    private static final Object[] zeroLengthArray = new Object[0];
    private static final org.apache.logging.log4j.Marker LOG4J_CONFIG = Log4jLogger_impl.m(UIMA_MARKER_CONFIG);
    private static final org.apache.logging.log4j.Marker LOG4J_FINEST = Log4jLogger_impl.m(UIMA_MARKER_FINEST);
    private static final AbstractFilter FILTER_CONFIG = Log4jLogger_impl.makeFilter(org.apache.logging.log4j.Level.INFO, LOG4J_CONFIG);
    private static final AbstractFilter FILTER_FINEST = Log4jLogger_impl.makeFilter(org.apache.logging.log4j.Level.TRACE, LOG4J_FINEST);
    private final ExtendedLoggerWrapper logger;
    private final org.apache.logging.log4j.core.Logger coreLogger;
    private final MessageFactory mf;

    private static AbstractFilter makeFilter(final org.apache.logging.log4j.Level tLevel, final org.apache.logging.log4j.Marker tMarker) {
        return new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                if (event.getLevel() == tLevel) {
                    return event.getMarker() != tMarker ? Filter.Result.DENY : Filter.Result.ACCEPT;
                }
                return Filter.Result.NEUTRAL;
            }

            public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, org.apache.logging.log4j.Level level, org.apache.logging.log4j.Marker marker, Message msg, Throwable t) {
                if (level == tLevel) {
                    return marker != tMarker ? Filter.Result.DENY : Filter.Result.ACCEPT;
                }
                return Filter.Result.NEUTRAL;
            }

            public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, org.apache.logging.log4j.Level level, org.apache.logging.log4j.Marker marker, Object msg, Throwable t) {
                if (level == tLevel) {
                    return marker != tMarker ? Filter.Result.DENY : Filter.Result.ACCEPT;
                }
                return Filter.Result.NEUTRAL;
            }

            public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, org.apache.logging.log4j.Level level, org.apache.logging.log4j.Marker marker, String msg, Object ... params) {
                if (level == tLevel) {
                    return marker != tMarker ? Filter.Result.DENY : Filter.Result.ACCEPT;
                }
                return Filter.Result.NEUTRAL;
            }
        };
    }

    private Log4jLogger_impl(Class<?> component) {
        super(component);
        this.coreLogger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)(null == component ? "org.apache.uima" : component.getName()));
        this.mf = this.coreLogger.getMessageFactory();
        this.logger = new ExtendedLoggerWrapper((ExtendedLogger)this.coreLogger, this.coreLogger.getName(), this.mf);
    }

    private Log4jLogger_impl(Log4jLogger_impl l, int limit) {
        super(l, limit);
        this.logger = l.logger;
        this.coreLogger = l.coreLogger;
        this.mf = l.mf;
    }

    public static synchronized Logger getInstance(Class<?> component) {
        return new Log4jLogger_impl(component);
    }

    public static synchronized Logger getInstance() {
        return new Log4jLogger_impl(null);
    }

    @Override
    public Log4jLogger_impl getLimitedLogger(int aLimit) {
        if (aLimit == Integer.MAX_VALUE || aLimit == this.limit_common) {
            return this;
        }
        return new Log4jLogger_impl(this, aLimit);
    }

    static org.apache.logging.log4j.Level getLog4jLevel(Level level) {
        switch (level.toInteger()) {
            case 0x7FFFFFFF: {
                return org.apache.logging.log4j.Level.OFF;
            }
            case 70000: {
                return org.apache.logging.log4j.Level.ERROR;
            }
            case 60000: {
                return org.apache.logging.log4j.Level.WARN;
            }
            case 50000: {
                return org.apache.logging.log4j.Level.INFO;
            }
            case 40000: {
                return org.apache.logging.log4j.Level.INFO;
            }
            case 30000: {
                return org.apache.logging.log4j.Level.DEBUG;
            }
            case 20000: {
                return org.apache.logging.log4j.Level.TRACE;
            }
            case 10000: {
                return org.apache.logging.log4j.Level.TRACE;
            }
        }
        return org.apache.logging.log4j.Level.ALL;
    }

    private static org.apache.logging.log4j.Marker m(Marker m) {
        return m == null ? null : ((Log4jMarker)m).getLog4jMarker();
    }

    @Override
    public boolean isLoggable(Level level) {
        if (level == Level.CONFIG) {
            Filter.Result r = this.filterTest(org.apache.logging.log4j.Level.INFO, LOG4J_CONFIG);
            return r == Filter.Result.ACCEPT || r == Filter.Result.NEUTRAL && this.coreLogger.isEnabled(org.apache.logging.log4j.Level.TRACE);
        }
        if (level == Level.FINEST) {
            Filter.Result r = this.filterTest(org.apache.logging.log4j.Level.TRACE, LOG4J_FINEST);
            return r == Filter.Result.ACCEPT || r == Filter.Result.NEUTRAL && this.coreLogger.isEnabled(org.apache.logging.log4j.Level.TRACE);
        }
        return this.coreLogger.isEnabled(Log4jLogger_impl.getLog4jLevel(level));
    }

    @Override
    public boolean isLoggable(Level level, Marker marker) {
        return this.coreLogger.isEnabled(Log4jLogger_impl.getLog4jLevel(level), Log4jLogger_impl.m(marker));
    }

    private Filter.Result filterTest(org.apache.logging.log4j.Level level, org.apache.logging.log4j.Marker marker) {
        Filter filter = this.coreLogger.get().getFilter();
        if (null != filter) {
            return filter.filter(this.coreLogger, level, marker, (String)null, (Object[])null);
        }
        return Filter.Result.NEUTRAL;
    }

    @Override
    public void setLevel(Level level) {
        if (level == Level.CONFIG) {
            this.coreLogger.get().addFilter((Filter)FILTER_CONFIG);
        } else {
            this.coreLogger.get().removeFilter((Filter)FILTER_CONFIG);
        }
        if (level == Level.FINEST) {
            this.coreLogger.get().addFilter((Filter)FILTER_FINEST);
        } else {
            this.coreLogger.get().removeFilter((Filter)FILTER_FINEST);
        }
        this.coreLogger.get().setLevel(Log4jLogger_impl.getLog4jLevel(level));
        this.coreLogger.getContext().updateLoggers();
    }

    @Override
    public void log(Marker m, String aFqcn, Level level, String message, Object[] args, Throwable thrown) {
        this.log(m, aFqcn, level, MessageFormat.format(message, args), thrown);
    }

    @Override
    public void log(Marker m, String aFqcn, Level level, String message, Throwable thrown) {
        this.logger.logIfEnabled(aFqcn, Log4jLogger_impl.getLog4jLevel(level), Log4jLogger_impl.m(m), message, thrown);
    }

    @Override
    public void log2(Marker m, String aFqcn, Level level, String message, Object[] args, Throwable thrown) {
        if (thrown != null) {
            assert (args == null);
            this.logger.logIfEnabled(aFqcn, Log4jLogger_impl.getLog4jLevel(level), Log4jLogger_impl.m(m), message, thrown);
        } else {
            this.logger.logIfEnabled(aFqcn, Log4jLogger_impl.getLog4jLevel(level), Log4jLogger_impl.m(m), message, args);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker arg0) {
        return this.logger.isDebugEnabled(Log4jLogger_impl.m(arg0));
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker arg0) {
        return this.logger.isErrorEnabled(Log4jLogger_impl.m(arg0));
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker arg0) {
        return this.logger.isInfoEnabled(Log4jLogger_impl.m(arg0));
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker arg0) {
        return this.logger.isTraceEnabled(Log4jLogger_impl.m(arg0));
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker arg0) {
        return this.logger.isWarnEnabled(Log4jLogger_impl.m(arg0));
    }
}

