/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.rb_trees.IntArrayRBTcommon;

@Deprecated
public class IntArrayRBT
extends IntArrayRBTcommon {
    public IntArrayRBT() {
        this(8);
    }

    public IntArrayRBT(int initialSize) {
    }

    protected int treeInsert(int k) {
        return this.treeInsert(k, false);
    }

    protected int treeInsertWithDups(int k) {
        return this.treeInsert(k, true);
    }

    protected int treeInsert(int k, boolean withDups) {
        ThreadLocalRandom rand;
        if (this.greatestNode != 0) {
            int lt;
            int n = lt = withDups ? 1 : 0;
            if (this.compare(this.getKeyForNode(this.greatestNode), k) < lt) {
                int z;
                int y = this.greatestNode;
                this.greatestNode = z = this.newNode(k);
                this.setRight(y, z);
                this.setParent(z, y);
                return z;
            }
        }
        int x = this.root;
        int y = 0;
        int cr = 0;
        boolean wentLeft = false;
        ThreadLocalRandom threadLocalRandom = rand = withDups ? ThreadLocalRandom.current() : null;
        while (x != 0) {
            y = x;
            cr = this.compare(k, this.getKeyForNode(x));
            if (cr == 0) {
                if (withDups) {
                    if (rand.nextBoolean()) {
                        x = this.getLeft(x);
                        wentLeft = true;
                        continue;
                    }
                    x = this.getRight(x);
                    wentLeft = false;
                    continue;
                }
                return -x;
            }
            x = cr < 0 ? this.getLeft(x) : this.getRight(x);
        }
        int z = this.newNode(k);
        if (y == 0) {
            this.setAsRoot(z);
            this.greatestNode = z;
        } else {
            this.setParent(z, y);
            if (cr < 0) {
                this.setLeft(y, z);
            } else if (cr > 0) {
                this.setRight(y, z);
            } else if (wentLeft) {
                this.setLeft(y, z);
            } else {
                this.setRight(y, z);
            }
        }
        return z;
    }

    public int insertKey(int k) {
        return this.insertKey(k, false);
    }

    public int add(int k) {
        return this.insertKey(k, false);
    }

    public boolean addAdded(int k) {
        if (this.root == 0) {
            int x = this.newNode(k);
            this.setAsRoot(x);
            this.color[this.root] = false;
            this.greatestNode = x;
            return true;
        }
        int x = this.treeInsert(k);
        if (x < 0) {
            return false;
        }
        this.commonInsertKey(x);
        return true;
    }

    private int insertKey(int k, boolean withDups) {
        if (this.root == 0) {
            int x = this.newNode(k);
            this.setAsRoot(x);
            this.color[this.root] = false;
            this.greatestNode = x;
            return x;
        }
        int x = this.treeInsert(k, withDups);
        if (x < 0) {
            return -x;
        }
        return this.commonInsertKey(x);
    }

    public int insertKeyShowNegative(int k) {
        if (this.root == 0) {
            int x = this.newNode(k);
            this.setAsRoot(x);
            this.color[this.root] = false;
            this.greatestNode = x;
            return x;
        }
        int x = this.treeInsert(k, false);
        if (x < 0) {
            return x;
        }
        return this.commonInsertKey(x);
    }

    private int commonInsertKey(int x) {
        this.color[x] = true;
        int node = x;
        while (x != this.root && this.color[this.getParent(x)]) {
            int parent2_parent2_x;
            int parent2_x;
            int y;
            int parent_parent_x;
            int parent_x = this.getParent(x);
            if (parent_x == this.getLeft(parent_parent_x = this.getParent(parent_x))) {
                y = this.getRight(parent_parent_x);
                if (this.color[y]) {
                    this.color[parent_x] = false;
                    this.color[y] = false;
                    this.color[parent_parent_x] = true;
                    x = parent_parent_x;
                    continue;
                }
                if (x == this.getRight(parent_x)) {
                    x = parent_x;
                    this.leftRotate(x);
                }
                parent2_x = this.getParent(x);
                this.color[parent2_x] = false;
                parent2_parent2_x = this.getParent(parent2_x);
                this.color[parent2_parent2_x] = true;
                this.rightRotate(parent2_parent2_x);
                continue;
            }
            y = this.getLeft(parent_parent_x);
            if (this.color[y]) {
                this.color[parent_x] = false;
                this.color[y] = false;
                this.color[parent_parent_x] = true;
                x = parent_parent_x;
                continue;
            }
            if (x == this.getLeft(parent_x)) {
                x = parent_x;
                this.rightRotate(x);
            }
            parent2_x = this.getParent(x);
            this.color[parent2_x] = false;
            parent2_parent2_x = this.getParent(parent2_x);
            this.color[parent2_parent2_x] = true;
            this.leftRotate(parent2_parent2_x);
        }
        this.color[this.root] = false;
        return node;
    }

    public boolean deleteKey(int aKey) {
        int node = this.findKey(aKey);
        if (node == 0 || this.getKeyForNode(node) != aKey) {
            return false;
        }
        this.deleteNode(node);
        --this.size;
        if (this.size == 0 && this.next > 0x1000000) {
            this.flush();
        }
        return true;
    }

    public void clear() {
        this.flush();
    }

    public IntListIterator iterator() {
        return new IntArrayRBTKeyIterator();
    }

    public boolean debugScanFor(int key) {
        for (int i = 1; i < this.next; ++i) {
            if (this.getKeyForNode(i) != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getKeyForNode(int node) {
        return super.getKeyForNode(node);
    }

    private class IntArrayRBTKeyIterator
    implements IntListIterator {
        protected int currentNode;

        protected IntArrayRBTKeyIterator() {
            this.moveToStart();
        }

        @Override
        public final boolean hasNext() {
            return this.currentNode != 0;
        }

        @Override
        public final int nextNvc() {
            int r = IntArrayRBT.this.getKeyForNode(this.currentNode);
            this.currentNode = IntArrayRBT.this.nextNode(this.currentNode);
            return r;
        }

        @Override
        public boolean hasPrevious() {
            return IntArrayRBT.this.previousNode(this.currentNode) != 0;
        }

        @Override
        public int previous() {
            this.currentNode = IntArrayRBT.this.previousNode(this.currentNode);
            if (this.currentNode != 0) {
                return this.getKey(this.currentNode);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int previousNvc() {
            this.currentNode = IntArrayRBT.this.previousNode(this.currentNode);
            return this.getKey(this.currentNode);
        }

        @Override
        public void moveToEnd() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        @Override
        public void moveToStart() {
            this.currentNode = IntArrayRBT.this.getFirstNode();
        }

        protected final int getKey(int node) {
            return IntArrayRBT.this.getKeyForNode(node);
        }
    }
}

