/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TaeDescription;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.search.IndexBuildSpecification;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.SaxDeserializer;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.apache.uima.util.impl.SaxDeserializer_impl;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser_impl
implements XMLParser {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<XMLParser_impl> CLASS_NAME = XMLParser_impl.class;
    private static final URL SCHEMA_URL;
    protected Map<String, Class<? extends XMLizable>> mElementToClassMap = Collections.synchronizedMap(new HashMap());
    protected boolean mSchemaValidationEnabled = false;
    protected static final XMLParser.ParsingOptions DEFAULT_PARSING_OPTIONS;

    @Override
    public void enableSchemaValidation(boolean aEnable) {
        this.mSchemaValidationEnabled = aEnable;
    }

    @Override
    public XMLizable parse(XMLInputSource aInput, String aNamespaceForSchema, URL aSchemaUrl, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        URL urlToParse = aInput.getURL();
        try {
            SAXParserFactory factory = XMLUtils.createSAXParserFactory();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (this.mSchemaValidationEnabled && aNamespaceForSchema != null && aSchemaUrl != null) {
                try {
                    reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", aNamespaceForSchema + " " + aSchemaUrl);
                    reader.setFeature("http://xml.org/sax/features/validation", true);
                }
                catch (SAXNotRecognizedException e) {
                    UIMAFramework.getLogger().log(Level.INFO, "The installed XML Parser does not support schema validation.  No validation will occur.");
                }
            }
            InputSource input = new InputSource();
            input.setByteStream(aInput.getInputStream());
            String systemId = urlToParse != null ? urlToParse.toString() : new File(System.getProperty("user.dir")).toURL().toString();
            input.setSystemId(systemId);
            ParseErrorHandler errorHandler = new ParseErrorHandler();
            reader.setErrorHandler(errorHandler);
            SaxDeserializer_impl deser = new SaxDeserializer_impl(this, aOptions);
            reader.setContentHandler(deser);
            if (aOptions.preserveComments) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", deser);
            }
            reader.parse(input);
            if (errorHandler.getException() != null) {
                throw errorHandler.getException();
            }
            XMLizable result = deser.getObject();
            if (result instanceof MetaDataObject_impl) {
                ((MetaDataObject_impl)result).setSourceUrl(urlToParse);
            }
            return result;
        }
        catch (Exception e) {
            String sourceFile = urlToParse != null ? urlToParse.toString() : "<unknown source>";
            throw new InvalidXMLException("invalid_descriptor_file", new Object[]{sourceFile}, e);
        }
    }

    @Override
    public XMLizable parse(XMLInputSource aInput, String aNamespaceForSchema, URL aSchemaUrl) throws InvalidXMLException {
        return this.parse(aInput, aNamespaceForSchema, aSchemaUrl, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public XMLizable parse(XMLInputSource aInput) throws InvalidXMLException {
        return this.parse(aInput, null, null, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public XMLizable parse(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        return this.parse(aInput, null, null, aOptions);
    }

    @Override
    public XMLizable buildObject(Element aElement) throws InvalidXMLException {
        return this.buildObject(aElement, new XMLParser.ParsingOptions(true));
    }

    @Override
    public XMLizable buildObject(Element aElement, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object;
        Class<? extends XMLizable> cls = this.mElementToClassMap.get(aElement.getTagName());
        if (cls == null) {
            throw new InvalidXMLException("unknown_element", new Object[]{aElement.getTagName()});
        }
        try {
            object = cls.newInstance();
        }
        catch (Exception e) {
            throw new UIMA_IllegalStateException("could_not_instantiate_xmlizable", new Object[]{cls.getName()}, e);
        }
        this.callBuildFromXMLElement(aElement, object, aOptions);
        return object;
    }

    private void callBuildFromXMLElement(Element aElement, XMLizable object, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        if (aOptions.preserveComments && object instanceof MetaDataObject_impl) {
            ((MetaDataObject_impl)object).setInfoset(aElement);
        }
        object.buildFromXMLElement(aElement, this, aOptions);
    }

    @Override
    public Object buildObjectOrPrimitive(Element aElement, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object;
        Class<? extends XMLizable> cls = this.mElementToClassMap.get(aElement.getTagName());
        if (cls == null) {
            Object primObj = XMLUtils.readPrimitiveValue(aElement);
            if (primObj != null) {
                return primObj;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{aElement.getTagName()});
        }
        try {
            object = cls.newInstance();
        }
        catch (Exception e) {
            throw new UIMA_IllegalStateException("could_not_instantiate_xmlizable", new Object[]{cls.getName()}, e);
        }
        this.callBuildFromXMLElement(aElement, object, aOptions);
        return object;
    }

    @Override
    public ResourceSpecifier parseResourceSpecifier(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseResourceSpecifier(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public ResourceSpecifier parseResourceSpecifier(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof ResourceSpecifier) {
            return (ResourceSpecifier)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{ResourceSpecifier.class.getName(), object.getClass().getName()});
    }

    @Override
    public ResourceMetaData parseResourceMetaData(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseResourceMetaData(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public ResourceMetaData parseResourceMetaData(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof ResourceMetaData) {
            return (ResourceMetaData)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{ResourceMetaData.class.getName(), object.getClass().getName()});
    }

    @Override
    public URISpecifier parseURISpecifier(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseURISpecifier(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public URISpecifier parseURISpecifier(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof URISpecifier) {
            return (URISpecifier)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{URISpecifier.class.getName(), object.getClass().getName()});
    }

    @Override
    public AnalysisEngineDescription parseAnalysisEngineDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseAnalysisEngineDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public AnalysisEngineDescription parseAnalysisEngineDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof AnalysisEngineDescription) {
            return (AnalysisEngineDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{AnalysisEngineDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    @Deprecated
    public TaeDescription parseTaeDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseTaeDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    @Deprecated
    public TaeDescription parseTaeDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof TaeDescription) {
            return (TaeDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{TaeDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    public ResultSpecification parseResultSpecification(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseResultSpecification(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public ResultSpecification parseResultSpecification(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", null, aOptions);
        if (object instanceof ResultSpecification) {
            return (ResultSpecification)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{ResultSpecification.class.getName(), object.getClass().getName()});
    }

    @Override
    public CasConsumerDescription parseCasConsumerDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseCasConsumerDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public CasConsumerDescription parseCasConsumerDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof CasConsumerDescription) {
            return (CasConsumerDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{CasConsumerDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    @Deprecated
    public CasInitializerDescription parseCasInitializerDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseCasInitializerDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    @Deprecated
    public CasInitializerDescription parseCasInitializerDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof CasInitializerDescription) {
            return (CasInitializerDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{CasInitializerDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    public CollectionReaderDescription parseCollectionReaderDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseCollectionReaderDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public CollectionReaderDescription parseCollectionReaderDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof CollectionReaderDescription) {
            return (CollectionReaderDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{CollectionReaderDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    public CpeDescription parseCpeDescription(XMLInputSource aInput) throws InvalidXMLException {
        XMLizable object = this.parse(aInput);
        if (object instanceof CpeDescription) {
            return (CpeDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{CpeDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    public TypePriorities parseTypePriorities(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseTypePriorities(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public TypePriorities parseTypePriorities(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof TypePriorities) {
            return (TypePriorities)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{TypePriorities.class.getName(), object.getClass().getName()});
    }

    @Override
    public TypeSystemDescription parseTypeSystemDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseTypeSystemDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public TypeSystemDescription parseTypeSystemDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof TypeSystemDescription) {
            return (TypeSystemDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{TypeSystemDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    public FsIndexCollection parseFsIndexCollection(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseFsIndexCollection(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public FsIndexCollection parseFsIndexCollection(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof FsIndexCollection) {
            return (FsIndexCollection)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{FsIndexCollection.class.getName(), object.getClass().getName()});
    }

    @Override
    public ResourceManagerConfiguration parseResourceManagerConfiguration(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseResourceManagerConfiguration(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public ResourceManagerConfiguration parseResourceManagerConfiguration(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof ResourceManagerConfiguration) {
            return (ResourceManagerConfiguration)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{ResourceManagerConfiguration.class.getName(), object.getClass().getName()});
    }

    @Override
    public FlowControllerDescription parseFlowControllerDescription(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseFlowControllerDescription(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public FlowControllerDescription parseFlowControllerDescription(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof FlowControllerDescription) {
            return (FlowControllerDescription)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{FlowControllerDescription.class.getName(), object.getClass().getName()});
    }

    @Override
    public CustomResourceSpecifier parseCustomResourceSpecifier(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseCustomResourceSpecifier(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public CustomResourceSpecifier parseCustomResourceSpecifier(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof CustomResourceSpecifier) {
            return (CustomResourceSpecifier)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{CustomResourceSpecifier.class.getName(), object.getClass().getName()});
    }

    @Override
    public PearSpecifier parsePearSpecifier(XMLInputSource aInput) throws InvalidXMLException {
        return this.parsePearSpecifier(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public PearSpecifier parsePearSpecifier(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, "http://uima.apache.org/resourceSpecifier", SCHEMA_URL, aOptions);
        if (object instanceof PearSpecifier) {
            return (PearSpecifier)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{PearSpecifier.class.getName(), object.getClass().getName()});
    }

    @Override
    public IndexBuildSpecification parseIndexBuildSpecification(XMLInputSource aInput) throws InvalidXMLException {
        return this.parseIndexBuildSpecification(aInput, DEFAULT_PARSING_OPTIONS);
    }

    @Override
    public IndexBuildSpecification parseIndexBuildSpecification(XMLInputSource aInput, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        XMLizable object = this.parse(aInput, aOptions);
        if (object instanceof IndexBuildSpecification) {
            return (IndexBuildSpecification)object;
        }
        throw new InvalidXMLException("invalid_class", new Object[]{IndexBuildSpecification.class.getName(), object.getClass().getName()});
    }

    @Override
    public void addMapping(String aElementName, String aClassName) throws ClassNotFoundException {
        if (aElementName == null) {
            return;
        }
        Class<?> cls = Class.forName(aClassName);
        if (!XMLizable.class.isAssignableFrom(cls)) {
            throw new UIMA_IllegalArgumentException("must_implement_xmlizable", new Object[]{aClassName});
        }
        this.mElementToClassMap.put(aElementName, cls);
    }

    @Override
    public SaxDeserializer newSaxDeserializer() {
        return new SaxDeserializer_impl(this, new XMLParser.ParsingOptions(true));
    }

    @Override
    public SaxDeserializer newSaxDeserializer(XMLParser.ParsingOptions aOptions) {
        return new SaxDeserializer_impl(this, aOptions);
    }

    static {
        URL schemaURL = XMLParser_impl.class.getResource("/resourceSpecifierSchema.xsd");
        if (schemaURL == null) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "getSchemaURL", LOG_RESOURCE_BUNDLE, "UIMA_resource_specifier_schema_not_found__WARNING");
        } else {
            String urlString = schemaURL.toString().replaceAll(" ", "%20");
            try {
                schemaURL = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        SCHEMA_URL = schemaURL;
        DEFAULT_PARSING_OPTIONS = new XMLParser.ParsingOptions(true);
    }

    static class ParseErrorHandler
    extends DefaultHandler {
        private SAXParseException mException = null;

        ParseErrorHandler() {
        }

        @Override
        public void error(SAXParseException aError) {
            if (this.mException == null) {
                this.mException = aError;
            }
        }

        @Override
        public void fatalError(SAXParseException aError) {
            if (this.mException == null) {
                this.mException = aError;
            }
        }

        @Override
        public void warning(SAXParseException aWarning) {
            System.err.println("XML Warning: " + aWarning.getMessage());
        }

        public SAXParseException getException() {
            return this.mException;
        }

        public void clear() {
            this.mException = null;
        }
    }
}

