/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSComparators;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.admin.LinearTypeOrderBuilder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FsIndex_annotation;
import org.apache.uima.cas.impl.FsIndex_bag;
import org.apache.uima.cas.impl.FsIndex_iicp;
import org.apache.uima.cas.impl.FsIndex_set_sorted;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.FsIterator_aggregation_common;
import org.apache.uima.cas.impl.LinearTypeOrderBuilderImpl;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.ObjHashSet;
import org.apache.uima.jcas.cas.AnnotationBase;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class FSIndexRepositoryImpl
implements FSIndexRepositoryMgr,
LowLevelIndexRepository {
    public static final boolean ITEM_ADDED_TO_INDEX = true;
    public static final boolean ITEM_REMOVED_FROM_INDEX = false;
    public static final boolean V2_ANNOTATION_COMPARE_TYPE_ORDER = false;
    public static final int DEFAULT_INDEX_SIZE = 16;
    public static final boolean SKIP_BAG_INDEXES = true;
    public static final boolean INCLUDE_BAG_INDEXES = false;
    public static final String ALLOW_DUP_ADD_TO_INDEXES = "uima.allow_duplicate_add_to_indexes";
    public static final String DISABLE_ENHANCED_WRONG_INDEX = "uima.disable_enhanced_check_wrong_add_to_index";
    private static final boolean IS_DISABLE_ENHANCED_WRONG_INDEX_CHECK;
    private final CASImpl cas;
    private boolean locked = false;
    final IndexesForType[] indexArray;
    final HashMap<String, FsIndex_iicp<TOP>> name2indexMap;
    private final Map<TypeImpl, FsIndex_annotation<Annotation>> annotationIndexes = new IdentityHashMap<TypeImpl, FsIndex_annotation<Annotation>>();
    private final List<TOP> indexUpdates;
    private final BitSet indexUpdateOperation;
    private boolean logProcessed;
    private final IntVector usedIndexes;
    private final BitSet isUsed;
    private final SharedIndexInfo sii;
    private ProcessedIndexInfo mPii;

    IndexesForType getIndexesForType(int typeCode) {
        return this.indexArray[typeCode];
    }

    IndexesForType getIndexesForUsedType(int i) {
        return this.indexArray[this.usedIndexes.get(i)];
    }

    private FSIndexRepositoryImpl() {
        this.cas = null;
        this.sii = null;
        this.name2indexMap = null;
        this.indexArray = null;
        this.indexUpdates = null;
        this.indexUpdateOperation = null;
        this.usedIndexes = null;
        this.isUsed = null;
    }

    FSIndexRepositoryImpl(CASImpl cas) {
        this.cas = cas;
        this.sii = new SharedIndexInfo(cas.getTypeSystemImpl());
        TypeSystemImpl ts = this.sii.tsi;
        int numTypes = ts.getNumberOfTypes() + 1;
        this.name2indexMap = new HashMap();
        this.indexUpdates = new ArrayList<TOP>();
        this.indexUpdateOperation = new BitSet();
        this.logProcessed = false;
        this.indexArray = new IndexesForType[this.sii.tsi.getNumberOfTypes() + 1];
        this.usedIndexes = new IntVector();
        this.isUsed = new BitSet(numTypes);
        this.init();
    }

    FSIndexRepositoryImpl(CASImpl cas, FSIndexRepositoryImpl baseIndexRepo) {
        this.cas = cas;
        this.sii = baseIndexRepo.sii;
        this.sii.isSetUpFromBaseCAS = true;
        TypeSystemImpl ts = this.sii.tsi;
        int numTypes = ts.getNumberOfTypes() + 1;
        this.name2indexMap = new HashMap();
        this.indexUpdates = new ArrayList<TOP>();
        this.indexUpdateOperation = new BitSet();
        this.logProcessed = false;
        this.indexArray = new IndexesForType[numTypes];
        this.usedIndexes = new IntVector();
        this.isUsed = new BitSet(numTypes);
        this.init();
    }

    private void init() {
        TypeSystemImpl ts = this.sii.tsi;
        int numTypes = ts.getNumberOfTypes() + 1;
        for (int i = 1; i < numTypes; ++i) {
            this.indexArray[i] = new IndexesForType(ts.types.get(i));
        }
        this.mPii = new ProcessedIndexInfo();
    }

    <T extends FeatureStructure> void createIndex(FSIndexRepositoryImpl baseIndexRepo, String key) {
        FsIndex_singletype fsIndex = baseIndexRepo.name2indexMap.get((Object)key).fsIndex_singletype;
        this.createIndexNoQuestionsAsked(fsIndex.getComparatorImplForIndexSpecs(), key, fsIndex.getIndexingStrategy());
    }

    @Override
    public boolean createIndex(FSIndexComparator comp, String label, int indexType) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException("REPOSITORY_LOCKED", new Object[0]);
        }
        return this.createIndexNoQuestionsAsked(comp, label, indexType);
    }

    public <T extends FeatureStructure> boolean createIndexNoQuestionsAsked(FSIndexComparator comp, String label, int indexType) {
        FsIndex_iicp<TOP> cp = this.name2indexMap.get(label);
        if (cp == null) {
            cp = this.addNewIndexRecursive(comp, indexType);
            if (!this.sii.isSetUpFromBaseCAS) {
                int nKeys = comp.getNumberOfKeys();
                for (int i = 0; i < nKeys; ++i) {
                    if (comp.getKeyType(i) != 0) continue;
                    FeatureImpl fi = (FeatureImpl)comp.getKeyFeature(i);
                    this.cas.featureCodes_inIndexKeysAdd(fi.getCode());
                }
            }
            this.name2indexMap.put(label, cp);
            return true;
        }
        return false;
    }

    public void removeIndex(String label) {
        FsIndex_iicp<TOP> cp = this.name2indexMap.get(label);
        if (cp == null) {
            return;
        }
        int indexingStrategy = cp.getIndexingStrategy();
        FSIndexComparatorImpl comp = cp.getComparatorImplForIndexSpecs();
        this.removeIndexBySpec(cp.getTypeCode(), indexingStrategy, comp);
        if (indexingStrategy != 3) {
            TypeImpl type = (TypeImpl)cp.getType();
            type.getAllSubtypes().forEachOrdered(subType -> {
                FSIndexComparatorImpl compSub = comp.copy();
                compSub.setType(type);
                this.removeIndexBySpec(subType.getCode(), indexingStrategy, compSub);
            });
        }
    }

    public void flush() {
        if (!this.locked) {
            return;
        }
        if (this.usedIndexes.size() == 0) {
            return;
        }
        this.annotationIndexes.clear();
        this.isUsed.clear();
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            int used = this.usedIndexes.get(i);
            for (FsIndex_iicp<TOP> iicp : this.indexArray[used].indexesForType) {
                iicp.fsIndex_singletype.flush();
            }
        }
        this.indexUpdates.clear();
        this.indexUpdateOperation.clear();
        this.mPii = new ProcessedIndexInfo();
        this.logProcessed = false;
        this.usedIndexes.removeAllElements();
    }

    private FsIndex_iicp<TOP> addNewIndex(FSIndexComparatorImpl comparator, int indexType) {
        return this.addNewIndex(comparator, 16, indexType);
    }

    private <T extends TOP> FsIndex_iicp<T> addNewIndex(FSIndexComparatorImpl comparator, int initialSize, int indexType) {
        FsIndex_singletype<T> index;
        FsIndex_annotation<TOP> iicp = null;
        if (this.isAnnotationIndex(comparator, indexType)) {
            index = this.addNewIndexCore(comparator, initialSize, indexType);
            iicp = new FsIndex_annotation<T>(index);
        } else {
            index = this.addNewIndexCore(comparator, initialSize, indexType);
            iicp = new FsIndex_iicp<T>(index);
        }
        Type type = comparator.getType();
        int typeCode = ((TypeImpl)type).getCode();
        this.getIndexesForType(typeCode).add(iicp);
        return iicp;
    }

    boolean isAnnotationIndex(FSIndexComparator c, int indexKind) {
        TypeSystemImpl tsi = this.getTypeSystemImpl();
        return indexKind == 0 && this.getTypeSystemImpl().annotType.subsumes((TypeImpl)c.getType()) && c.getNumberOfKeys() == 3 && c.getKeyType(0) == 0 && c.getKeyComparator(0) == 0 && c.getKeyFeature(0) == tsi.startFeat && c.getKeyType(1) == 0 && c.getKeyComparator(1) == 1 && c.getKeyFeature(1) == tsi.endFeat && c.getKeyType(2) == 1;
    }

    <T extends TOP> FsIndex_singletype<T> addNewIndexCore(FSIndexComparatorImpl comparatorForIndexSpecs, int initialSize, int indexingStrategy) {
        FsIndex_singletype ind;
        TypeImpl type = (TypeImpl)comparatorForIndexSpecs.getType();
        switch (indexingStrategy) {
            case 1: {
                ind = new FsIndex_set_sorted(this.cas, type, indexingStrategy, comparatorForIndexSpecs);
                break;
            }
            case 2: 
            case 3: {
                ind = new FsIndex_bag(this.cas, type, initialSize, indexingStrategy, comparatorForIndexSpecs);
                break;
            }
            default: {
                ind = new FsIndex_set_sorted(this.cas, type, 0, comparatorForIndexSpecs);
            }
        }
        return ind;
    }

    private FsIndex_iicp<TOP> addNewIndexRecursive(FSIndexComparator compForIndexSpecs, int indexType) {
        FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)compForIndexSpecs).copy();
        return this.addNewIndexRec(compCopy, indexType);
    }

    private FsIndex_iicp<TOP> addNewIndexRec(FSIndexComparatorImpl comp4indexSpecs, int indexType) {
        FsIndex_iicp<TOP> existing = this.getIndexBySpec(comp4indexSpecs.getTypeCode(), indexType, comp4indexSpecs);
        if (null != existing) {
            return existing;
        }
        FsIndex_iicp<TOP> iicp = this.addNewIndex(comp4indexSpecs, indexType);
        if (indexType == 3) {
            return iicp;
        }
        TypeImpl superType = (TypeImpl)comp4indexSpecs.getType();
        for (Type type : superType.getDirectSubtypes()) {
            FSIndexComparatorImpl compCopy = comp4indexSpecs.copy();
            compCopy.setType(type);
            this.addNewIndexRec(compCopy, indexType);
        }
        return iicp;
    }

    @Override
    public void commit() {
        this.getDefaultTypeOrder();
        this.locked = true;
    }

    @Override
    public LinearTypeOrder getDefaultTypeOrder() {
        if (this.sii.defaultTypeOrder == null) {
            if (this.sii.defaultOrderBuilder == null) {
                this.sii.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.sii.tsi);
            }
            try {
                this.sii.defaultTypeOrder = this.sii.defaultOrderBuilder.getOrder();
            }
            catch (CASException e) {
                throw new UIMARuntimeException("INTERNAL_ERROR", new Object[0], e);
            }
        }
        return this.sii.defaultTypeOrder;
    }

    @Override
    public LinearTypeOrderBuilder getDefaultOrderBuilder() {
        if (this.sii.defaultOrderBuilder == null) {
            this.sii.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.sii.tsi);
        }
        return this.sii.defaultOrderBuilder;
    }

    void setDefaultTypeOrder(LinearTypeOrder order) {
        this.sii.defaultTypeOrder = order;
    }

    public Iterator<FSIndex<TOP>> getIndexes() {
        ArrayList<FSIndex> indexList = new ArrayList<FSIndex>();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            indexList.add(this.getIndex(label));
        }
        return indexList.iterator();
    }

    public Iterator<LowLevelIndex> ll_getIndexes() {
        ArrayList indexList = new ArrayList();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            indexList.add(this.ll_getIndex(label));
        }
        return indexList.iterator();
    }

    @Override
    public Iterator<String> getLabels() {
        return this.name2indexMap.keySet().iterator();
    }

    public <T extends FeatureStructure> Iterator<String> getLabels(FSIndexComparator comp) {
        ArrayList<String> labels = new ArrayList<String>();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            if (!this.name2indexMap.get((Object)label).fsIndex_singletype.getComparatorImplForIndexSpecs().equals(comp)) continue;
            labels.add(label);
        }
        return labels.iterator();
    }

    @Override
    public <T extends FeatureStructure> FSIndex<T> getIndex(String label, Type type) {
        TypeImpl ti;
        Type componentType;
        FsIndex_iicp<TOP> iicp = this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        if (type.isArray() && (componentType = type.getComponentType()) != null && !componentType.isPrimitive() && !componentType.getName().equals("uima.cas.TOP")) {
            return null;
        }
        TypeImpl indexType = iicp.fsIndex_singletype.getTypeImpl();
        if (!indexType.subsumes(ti = (TypeImpl)type)) {
            throw new CASRuntimeException("TYPE_NOT_IN_INDEX", label, type.getName(), indexType.getName());
        }
        return this.getIndexBySpec(ti.getCode(), iicp.getIndexingStrategy(), iicp.getComparatorImplForIndexSpecs());
    }

    public <T extends FeatureStructure> LowLevelIndex<T> getIndex(String label) {
        return this.name2indexMap.get(label);
    }

    @Override
    public void removeAllExcludingSubtypes(Type type) {
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList<FsIndex_iicp<TOP>> allIndexesForType = this.getIndexesForType((int)typeCode).indexesForType;
        for (FsIndex_iicp<TOP> iicp : allIndexesForType) {
            iicp.fsIndex_singletype.removeAll();
        }
    }

    @Override
    public void removeAllIncludingSubtypes(Type type) {
        this.removeAllExcludingSubtypes(type);
        List<Type> subtypes = this.sii.tsi.getDirectSubtypes(type);
        for (Type subtype : subtypes) {
            this.removeAllIncludingSubtypes(subtype);
        }
    }

    @Override
    public FSIndexComparator createComparator() {
        return new FSIndexComparatorImpl();
    }

    @Override
    public boolean isCommitted() {
        return this.locked;
    }

    @Override
    public boolean createIndex(FSIndexComparator comp, String label) throws CASAdminException {
        return this.createIndex(comp, label, 0);
    }

    public void walkIndexedFSs(Consumer<TOP> action) {
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            for (TOP fs : this.getNonSetSingleIndexForUsedType(i)) {
                action.accept(fs);
            }
        }
    }

    public void walkSortedIndexedFSs(Consumer<TOP> action) {
        ArrayList<TOP> fss = new ArrayList<TOP>();
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            for (TOP fs : this.getNonSetSingleIndexForUsedType(i)) {
                fss.add(fs);
            }
        }
        fss.sort((fs1, fs2) -> Integer.compare(fs1._id, fs2._id));
        for (TOP fs : fss) {
            action.accept(fs);
        }
    }

    public FsIndex_singletype<TOP> getNonSetSingleIndexForType(int typecode) {
        return this.getIndexesForType((int)typecode).getNonSetIndex().fsIndex_singletype;
    }

    public FsIndex_singletype<TOP> getNonSetSingleIndexForUsedType(int i) {
        return this.getIndexesForUsedType((int)i).getNonSetIndex().fsIndex_singletype;
    }

    public void addFS(int fsRef) {
        this.ll_addFS(fsRef);
    }

    @Override
    public void ll_addFS(int fsRef) {
        this.addFS_common(this.cas.getFsFromId_checked(fsRef), false);
    }

    @Override
    public void ll_removeFS(int fsRef) {
        this.removeFS((FeatureStructure)this.cas.getFsFromId_checked(fsRef));
    }

    @Override
    public <T extends FeatureStructure> void addFS(T fs) {
        this.addFS_common((TOP)fs, false);
    }

    public void removeFS(FeatureStructure fs) {
        this.removeFS_ret((TOP)fs, false);
        if (fs instanceof AnnotationBase) {
            ((FeatureStructureImplC)fs)._resetInSetSortedIndex();
        }
    }

    public void removeFS(int fsRef) {
        this.removeFS((FeatureStructure)this.cas.getFsFromId_checked(fsRef));
    }

    @Override
    public LinearTypeOrderBuilder createTypeSortOrder() {
        LinearTypeOrderBuilderImpl orderBuilder = new LinearTypeOrderBuilderImpl(this.sii.tsi);
        if (this.sii.defaultOrderBuilder == null) {
            this.sii.defaultOrderBuilder = orderBuilder;
        }
        return orderBuilder;
    }

    @Override
    public <T extends FeatureStructure> LowLevelIndex<T> ll_getIndex(String indexName) {
        return this.getIndex(indexName);
    }

    @Override
    public <T extends FeatureStructure> LowLevelIndex<T> ll_getIndex(String indexName, int typeCode) {
        TypeSystemImpl tsi = this.sii.tsi;
        if (!tsi.isType(typeCode) || !this.cas.ll_isRefType(typeCode)) {
            throw new LowLevelException("INVALID_INDEX_TYPE", Integer.toString(typeCode));
        }
        return (LowLevelIndex)this.getIndex(indexName, tsi.ll_getTypeForCode(typeCode));
    }

    @Override
    public final void ll_addFS(int fsRef, boolean doChecks) {
        this.ll_addFS(fsRef);
    }

    public <T extends TOP> void addback(T fs) {
        this.addFS_common(fs, true);
    }

    private <T extends TOP> void addFS_common(T fs, boolean isAddback) {
        TypeImpl ti;
        int typeCode;
        if (fs._isPearTrampoline()) {
            fs = fs._casView.getBaseFsFromTrampoline(fs);
        }
        if ((typeCode = (ti = fs._getTypeImpl()).getCode()) != 33 && this.cas.isBaseCas()) {
            throw new CASRuntimeException("ILLEGAL_ADD_TO_INDEX_IN_BASE_CAS", fs, this.cas);
        }
        if (!isAddback && !IS_DISABLE_ENHANCED_WRONG_INDEX_CHECK && ti.isAnnotationBaseType()) {
            Sofa sofa = (Sofa)((AnnotationBase)fs).getSofa();
            if (sofa == null) {
                throw new CASRuntimeException("SOFAREF_NOT_SET", fs.toString(3));
            }
            CASImpl indexView = fs._getView();
            if (indexView.getIndexRepository() != this) {
                throw new CASRuntimeException("ANNOTATION_IN_WRONG_INDEX", fs.toString(), indexView.getViewName(), this.cas.getViewName());
            }
        }
        ArrayList<FsIndex_iicp<TOP>> indexes = this.getIndexesForType((int)typeCode).indexesForType;
        boolean noIndexOrOnlySetindexes = true;
        boolean setOrSorted = false;
        for (FsIndex_iicp<TOP> iicp : indexes) {
            int indexingStrategy = iicp.fsIndex_singletype.getIndexingStrategy();
            if (isAddback && indexingStrategy == 2) continue;
            iicp.fsIndex_singletype.insert(fs);
            if (noIndexOrOnlySetindexes) {
                boolean bl = noIndexOrOnlySetindexes = indexingStrategy == 1;
            }
            if (setOrSorted || indexingStrategy == 2) continue;
            setOrSorted = true;
        }
        if (this.cas.getCurrentMark() != null) {
            this.logIndexOperation(fs, true);
        }
        if (setOrSorted) {
            fs._setInSetSortedIndexed();
        }
        if (isAddback) {
            return;
        }
        if (noIndexOrOnlySetindexes) {
            Type type = this.sii.tsi.ll_getTypeForCode(typeCode);
            String defIndexName = FSIndexRepositoryImpl.getAutoIndexNameForType(type);
            FSIndexComparator comparator = this.createComparator();
            comparator.setType(type);
            this.createIndexNoQuestionsAsked(comparator, defIndexName, 3);
            indexes.get((int)(indexes.size() - 1)).fsIndex_singletype.insert(fs);
        }
        if (!this.isUsed.get(typeCode)) {
            this.isUsed.set(typeCode);
            this.usedIndexes.add(typeCode);
        }
    }

    private static final String getAutoIndexNameForType(Type type) {
        return "_" + type.getName() + "_DefaultBagGeneratedIndex";
    }

    boolean removeFS_ret(TOP fs, boolean skipBagIndexes) {
        if (skipBagIndexes && !fs._inSetSortedIndex()) {
            return false;
        }
        int typeCode = fs._getTypeImpl().getCode();
        IndexesForType i4t = this.getIndexesForType(typeCode);
        ArrayList<FsIndex_iicp<TOP>> indexes4type = i4t.indexesForType;
        boolean wasRemoved = false;
        if (i4t.aSortedIndex < 0) {
            int bi = i4t.aBagIndex;
            if (bi < 0 && !i4t.hasSetIndex) {
                return false;
            }
            if (bi >= 0 && !i4t.indexesForType.get((int)bi).fsIndex_singletype.contains(fs)) {
                return false;
            }
        }
        for (FsIndex_iicp<TOP> iicp : indexes4type) {
            FsIndex_singletype<TOP> st = iicp.fsIndex_singletype;
            if (skipBagIndexes && !st.isSetOrSorted() || !st.deleteFS(fs)) continue;
            wasRemoved = true;
        }
        if (wasRemoved && this.cas.getCurrentMark() != null) {
            this.logIndexOperation(fs, false);
        }
        return wasRemoved;
    }

    public <T extends FeatureStructure> LowLevelIterator<T> ll_getAllIndexedFS(Type type) {
        return this.getAllIndexedFS(type);
    }

    public <T extends FeatureStructure> LowLevelIterator<T> getAllIndexedFS(Type type) {
        ArrayList<LowLevelIterator<LowLevelIterator>> iteratorList = new ArrayList<LowLevelIterator<LowLevelIterator>>();
        this.getAllIndexedFS(type, iteratorList);
        int iteratorListSize = iteratorList.size();
        if (iteratorListSize == 0) {
            return LowLevelIterator.FS_ITERATOR_LOW_LEVEL_EMPTY;
        }
        if (iteratorListSize == 1) {
            return iteratorList.get(0);
        }
        LowLevelIterator[] ia = new LowLevelIterator[iteratorListSize];
        return new FsIterator_aggregation_common(iteratorList.toArray(ia), null, null);
    }

    private final <T extends FeatureStructure> void getAllIndexedFS(Type type, List<LowLevelIterator<T>> iteratorList) {
        FsIndex_iicp iicp;
        TypeImpl ti = (TypeImpl)type;
        if (this.isUsed.get(ti.getCode()) && null != (iicp = this.getIndexesForType(ti.getCode()).getNonSetIndex()) && !iicp.isEmpty()) {
            LowLevelIterator it = iicp.getIndexingStrategy() == 0 ? iicp.iterator(true, true) : iicp.iterator();
            iteratorList.add(it);
            if (iicp.isDefaultBagIndex()) {
                this.addDirectSubtypes(ti, iteratorList);
            }
            return;
        }
        this.addDirectSubtypes(ti, iteratorList);
    }

    private <T extends FeatureStructure> void addDirectSubtypes(TypeImpl type, List<LowLevelIterator<T>> iteratorList) {
        for (TypeImpl subType : type.getDirectSubtypes()) {
            this.getAllIndexedFS(subType, iteratorList);
        }
    }

    public Collection<TOP> getIndexedFSs() {
        ArrayList indexes = new ArrayList();
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            FsIndex_singletype<TOP> idx = this.getNonSetSingleIndexForUsedType(i);
            if (idx.size() <= 0) continue;
            indexes.add(idx.getNonNullCow());
        }
        return this.getCollectionFromCows(indexes);
    }

    @Override
    public <T extends TOP> Collection<T> getIndexedFSs(Class<T> clazz) {
        return this.getIndexedFSs(this.cas.getCasType(clazz));
    }

    @Override
    public <T extends TOP> Collection<T> getIndexedFSs(Type type) {
        ArrayList<CopyOnWriteIndexPart<T>> indexes = new ArrayList<CopyOnWriteIndexPart<T>>();
        TypeImpl ti = (TypeImpl)type;
        this.collectCowIndexParts(ti, indexes);
        return this.getCollectionFromCows(indexes);
    }

    private <T extends TOP> Collection<T> getCollectionFromCows(final ArrayList<CopyOnWriteIndexPart<T>> indexes) {
        if (indexes.size() == 0) {
            return Collections.emptySet();
        }
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    final int indexesSize;
                    int indexesIndex;
                    Iterator<T> it;
                    {
                        this.indexesSize = indexes.size();
                        this.indexesIndex = 0;
                        this.it = ((CopyOnWriteIndexPart)indexes.get(0)).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.indexesIndex < this.indexesSize;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        TOP v = (TOP)this.it.next();
                        if (!this.it.hasNext()) {
                            ++this.indexesIndex;
                            if (this.indexesIndex == this.indexesSize) {
                                return v;
                            }
                            this.it = ((CopyOnWriteIndexPart)indexes.get(this.indexesIndex)).iterator();
                        }
                        return v;
                    }
                };
            }

            @Override
            public int size() {
                int r = 0;
                for (CopyOnWriteIndexPart cow : indexes) {
                    r += cow.size();
                }
                return r;
            }

            public TOP[] toArray() {
                FeatureStructure[] r = new TOP[this.size()];
                int i = 0;
                for (CopyOnWriteIndexPart idx : indexes) {
                    i = idx.copyToArray(r, i);
                }
                return r;
            }

            @Override
            public <U> U[] toArray(U[] r) {
                int i = 0;
                for (CopyOnWriteIndexPart idx : indexes) {
                    i = idx.copyToArray((TOP[])r, i);
                }
                return r;
            }

            @Override
            public boolean isEmpty() {
                return indexes.isEmpty();
            }
        };
    }

    private <T extends TOP> void collectCowIndexParts(TypeImpl ti, ArrayList<CopyOnWriteIndexPart<T>> indexes) {
        FsIndex_iicp<T> iicp;
        if (!this.isUsed.get(ti.getCode()) || (iicp = this.getIndexesForType(ti.getCode()).getNonSetIndex()) == null || iicp.isEmpty()) {
            ti.getDirectSubtypes().forEach(type -> this.collectCowIndexParts((TypeImpl)type, indexes));
            return;
        }
        if (iicp.isDefaultBagIndex()) {
            if (iicp.getFsIndex_singleType().size() > 0) {
                indexes.add(iicp.getFsIndex_singleType().getNonNullCow());
            }
            ti.getDirectSubtypes().forEach(type -> this.collectCowIndexParts((TypeImpl)type, indexes));
        } else {
            iicp.collectCowIndexParts(indexes);
        }
    }

    public Stream<FsIndex_singletype<TOP>> streamNonEmptyIndexes(Type type) {
        TypeImpl ti = (TypeImpl)type;
        if (!this.isUsed.get(ti.getCode())) {
            return this.streamNonEmptyDirectSubtypes(ti);
        }
        FsIndex_iicp iicp = this.getIndexesForType(ti.getCode()).getNonSetIndex();
        if (null == iicp || iicp.isEmpty()) {
            return Stream.empty();
        }
        Stream<FsIndex_singletype<TOP>> iicpIndexesStream = iicp.streamNonEmptyIndexes();
        return iicp.isDefaultBagIndex() ? Stream.concat(iicpIndexesStream, this.streamNonEmptyDirectSubtypes(ti)) : iicpIndexesStream;
    }

    public Stream<FsIndex_singletype<TOP>> streamNonEmptyIndexes(Class<? extends TOP> clazz) {
        return this.streamNonEmptyIndexes(this.getCasImpl().getCasType(clazz));
    }

    private Stream<FsIndex_singletype<TOP>> streamNonEmptyDirectSubtypes(TypeImpl ti) {
        Stream<FsIndex_singletype<TOP>> r = null;
        for (TypeImpl subType : ti.getDirectSubtypes()) {
            r = r == null ? this.streamNonEmptyIndexes(subType) : Stream.concat(r, this.streamNonEmptyIndexes(subType));
        }
        return r == null ? Stream.empty() : r;
    }

    <T extends AnnotationFS> FsIndex_annotation<T> getAnnotationIndex(TypeImpl ti) {
        FsIndex_annotation r1;
        FsIndex_annotation r = this.annotationIndexes.get(ti);
        if (r != null) {
            return r;
        }
        r = r1 = (FsIndex_annotation)this.getIndex("AnnotationIndex", ti);
        this.annotationIndexes.put(ti, r);
        return r;
    }

    private <T extends TOP> void logIndexOperation(T fs, boolean added) {
        this.indexUpdates.add(fs);
        if (added) {
            this.indexUpdateOperation.set(this.indexUpdates.size() - 1, added);
        }
        this.logProcessed = false;
    }

    private void processIndexUpdates() {
        ProcessedIndexInfo pii = this.mPii;
        int len = this.indexUpdates.size();
        for (int i = 0; i < len; ++i) {
            boolean wasRemoved;
            TOP fs = this.indexUpdates.get(i);
            boolean added = this.indexUpdateOperation.get(i);
            if (added) {
                wasRemoved = pii.fsDeletedFromIndex.remove(fs);
                if (wasRemoved) {
                    pii.fsReindexed.add(fs);
                    continue;
                }
                if (pii.fsReindexed.contains(fs)) continue;
                pii.fsAddedToIndex.add(fs);
                continue;
            }
            wasRemoved = pii.fsAddedToIndex.remove(fs);
            if (wasRemoved) continue;
            pii.fsReindexed.remove(fs);
            pii.fsDeletedFromIndex.add(fs);
        }
        this.logProcessed = true;
        this.indexUpdates.clear();
        this.indexUpdateOperation.clear();
    }

    public Set<TOP> getUpdatedFSs(Set<TOP> items) {
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        return items;
    }

    public Set<TOP> getAddedFSs() {
        return this.getUpdatedFSs(this.mPii.fsAddedToIndex);
    }

    public Set<TOP> getDeletedFSs() {
        return this.getUpdatedFSs(this.mPii.fsDeletedFromIndex);
    }

    public Set<TOP> getReindexedFSs() {
        return this.getUpdatedFSs(this.mPii.fsReindexed);
    }

    public boolean isModified() {
        ProcessedIndexInfo pii;
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        return (pii = this.mPii).fsAddedToIndex.size() > 0 || pii.fsDeletedFromIndex.size() > 0 || pii.fsReindexed.size() > 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.cas + "]";
    }

    public Comparator<TOP> getAnnotationFsComparator(FSComparators withId, FSComparators withTypeOrder) {
        Comparator<TOP> r = this.getCachedComparator(withId, withTypeOrder);
        if (r == null) {
            r = this.createAnnotationFsComparator(withId, withTypeOrder);
            this.setCachedComparator(withId, withTypeOrder, r);
        }
        return r;
    }

    private Comparator<TOP> createAnnotationFsComparator(FSComparators withId, FSComparators withTypeOrder) {
        LinearTypeOrder lto;
        LinearTypeOrder linearTypeOrder = lto = withTypeOrder == FSComparators.WITH_TYPE_ORDER ? this.getDefaultTypeOrder() : null;
        if (withId == FSComparators.WITH_ID) {
            if (withTypeOrder == FSComparators.WITH_TYPE_ORDER) {
                return (fs1, fs2) -> fs1 == fs2 ? 0 : ((Annotation)fs1).compareAnnotationWithId((Annotation)fs2, lto);
            }
            return (fs1, fs2) -> fs1 == fs2 ? 0 : ((Annotation)fs1).compareAnnotationWithId((Annotation)fs2);
        }
        if (withTypeOrder == FSComparators.WITH_TYPE_ORDER) {
            return (fs1, fs2) -> fs1 == fs2 ? 0 : ((Annotation)fs1).compareAnnotation((Annotation)fs2, lto);
        }
        return (fs1, fs2) -> fs1 == fs2 ? 0 : ((Annotation)fs1).compareAnnotation((Annotation)fs2);
    }

    public Comparator<TOP> getAnnotationFsComparatorWithoutId() {
        Comparator r = this.sii.annotationFsComparatorWithoutId;
        if (null != r) {
            return r;
        }
        return this.createAnnotationFsComparator();
    }

    Comparator<TOP> getAnnotationFsComparatorWithId() {
        Comparator r = this.sii.annotationFsComparatorWithId;
        if (null != r) {
            return r;
        }
        return this.createAnnotationFsComparatorWithId();
    }

    private Comparator<TOP> createAnnotationFsComparator() {
        LinearTypeOrder lto = this.getDefaultTypeOrder();
        if (lto.isEmptyTypeOrder()) {
            return this.sii.annotationFsComparatorWithoutId = (fsx1, fsx2) -> {
                if (fsx1 == fsx2) {
                    return 0;
                }
                Annotation fs1 = (Annotation)fsx1;
                Annotation fs2 = (Annotation)fsx2;
                return fs1.compareAnnotation(fs2);
            };
        }
        return this.sii.annotationFsComparatorWithoutId = (fsx1, fsx2) -> {
            if (fsx1 == fsx2) {
                return 0;
            }
            Annotation fs1 = (Annotation)fsx1;
            Annotation fs2 = (Annotation)fsx2;
            return fs1.compareAnnotation(fs2, lto);
        };
    }

    private Comparator<TOP> createAnnotationFsComparatorWithId() {
        LinearTypeOrder lto = this.getDefaultTypeOrder();
        if (lto.isEmptyTypeOrder()) {
            this.sii.annotationFsComparatorWithId = (fsx1, fsx2) -> {
                if (fsx1 == fsx2) {
                    return 0;
                }
                Annotation fs1 = (Annotation)fsx1;
                Annotation fs2 = (Annotation)fsx2;
                return fs1.compareAnnotationWithId(fs2);
            };
        } else {
            this.sii.annotationFsComparatorWithId = (fsx1, fsx2) -> {
                if (fsx1 == fsx2) {
                    return 0;
                }
                Annotation fs1 = (Annotation)fsx1;
                Annotation fs2 = (Annotation)fsx2;
                return fs1.compareAnnotationWithId(fs2, lto);
            };
        }
        return this.sii.annotationFsComparatorWithId;
    }

    public <T extends FeatureStructure> FsIndex_iicp<T> getIndexBySpec(int typeCode, int indexingStrategy, FSIndexComparatorImpl comp) {
        return this.getIndexesForType(typeCode).getIndexExcludingType(indexingStrategy, comp);
    }

    private void removeIndexBySpec(int typeCode, int indexingStrategy, FSIndexComparatorImpl comp) {
        this.getIndexesForType(typeCode).removeIndexExcludingType(indexingStrategy, comp);
    }

    public TypeSystemImpl getTypeSystemImpl() {
        return this.sii.tsi;
    }

    public CASImpl getCasImpl() {
        return this.cas;
    }

    private Comparator<TOP> getCachedComparator(FSComparators withId, FSComparators withTypeOrder) {
        if (withId == FSComparators.WITH_ID) {
            if (withTypeOrder == FSComparators.WITH_TYPE_ORDER) {
                return this.sii.annotationFsComparatorWithId;
            }
            return this.sii.annotationFsComparatorNoTypeWithId;
        }
        if (withTypeOrder == FSComparators.WITH_TYPE_ORDER) {
            return this.sii.annotationFsComparatorWithoutId;
        }
        return this.sii.annotationFsComparatorNoTypeWithoutId;
    }

    private void setCachedComparator(FSComparators withId, FSComparators withTypeOrder, Comparator<TOP> c) {
        if (withId == FSComparators.WITH_ID) {
            if (withTypeOrder == FSComparators.WITH_TYPE_ORDER) {
                this.sii.annotationFsComparatorWithId = c;
            } else {
                this.sii.annotationFsComparatorNoTypeWithId = c;
            }
        } else if (withTypeOrder == FSComparators.WITH_TYPE_ORDER) {
            this.sii.annotationFsComparatorWithoutId = c;
        } else {
            this.sii.annotationFsComparatorNoTypeWithoutId = c;
        }
    }

    static {
        if (Misc.getNoValueSystemProperty(ALLOW_DUP_ADD_TO_INDEXES)) {
            throw new CASAdminException("INDEX_DUPLICATES_NOT_SUPPORTED", new Object[0]);
        }
        IS_DISABLE_ENHANCED_WRONG_INDEX_CHECK = Misc.getNoValueSystemProperty(DISABLE_ENHANCED_WRONG_INDEX);
    }

    static class IndexesForType {
        boolean hasSetIndex;
        final String typename;
        int aSortedIndex = -1;
        int aBagIndex = -1;
        final ArrayList<FsIndex_iicp<TOP>> indexesForType = new ArrayList(0);

        IndexesForType(TypeImpl ti) {
            this.typename = ti.getName();
        }

        <T extends TOP> FsIndex_iicp<T> getNonSetIndex() {
            if (this.aSortedIndex < 0 && this.aBagIndex < 0) {
                return null;
            }
            return this.indexesForType.get(this.aBagIndex >= 0 ? this.aBagIndex : this.aSortedIndex);
        }

        void add(FsIndex_iicp<TOP> iicp) {
            assert (this.typename.equals(iicp.fsIndex_singletype.getType().getName()));
            int kind = iicp.fsIndex_singletype.getIndexingStrategy();
            int i = this.indexesForType.size();
            switch (kind) {
                case 2: {
                    this.aBagIndex = i;
                    break;
                }
                case 3: {
                    if (this.aBagIndex != -1) break;
                    this.aBagIndex = i;
                    break;
                }
                case 0: {
                    this.aSortedIndex = i;
                    break;
                }
                case 1: {
                    this.hasSetIndex = true;
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
            this.indexesForType.add(iicp);
        }

        <T extends FeatureStructure> FsIndex_iicp<T> getIndexExcludingType(int indexingStrategy, FSIndexComparatorImpl comparatorForIndexSpecs) {
            for (FsIndex_iicp<TOP> index : this.indexesForType) {
                FSIndexComparatorImpl indexComp;
                FsIndex_singletype singleTypeIndex = index.fsIndex_singletype;
                if (singleTypeIndex.getIndexingStrategy() != indexingStrategy || !(indexComp = singleTypeIndex.getComparatorImplForIndexSpecs()).equalsWithoutType(comparatorForIndexSpecs)) continue;
                return index;
            }
            return null;
        }

        private void removeIndexExcludingType(int indexingStrategy, FSIndexComparatorImpl comparatorForIndexSpecs) {
            Iterator<FsIndex_iicp<TOP>> it = this.indexesForType.iterator();
            while (it.hasNext()) {
                FSIndexComparatorImpl indexComp;
                FsIndex_singletype singleTypeIndex = it.next().fsIndex_singletype;
                if (singleTypeIndex.getIndexingStrategy() != indexingStrategy || !(indexComp = singleTypeIndex.getComparatorImplForIndexSpecs()).equalsWithoutType(comparatorForIndexSpecs)) continue;
                it.remove();
                break;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IndexesForType ").append(this.typename).append(" [hasSetIndex=").append(this.hasSetIndex).append(", aSortedIndex=").append(this.aSortedIndex).append(", aBagIndex=").append(this.aBagIndex).append(", indexesForType=").append(this.indexesForType).append("]");
            return builder.toString();
        }
    }

    private static class ProcessedIndexInfo {
        private final Set<TOP> fsAddedToIndex = new ObjHashSet<TOP>(TOP.class, TOP._singleton);
        private final Set<TOP> fsDeletedFromIndex = new ObjHashSet<TOP>(TOP.class, TOP._singleton);
        private final Set<TOP> fsReindexed = new ObjHashSet<TOP>(TOP.class, TOP._singleton);

        private ProcessedIndexInfo() {
        }
    }

    private static class SharedIndexInfo {
        private LinearTypeOrderBuilder defaultOrderBuilder = null;
        private LinearTypeOrder defaultTypeOrder = null;
        private final TypeSystemImpl tsi;
        private Comparator<TOP> annotationFsComparatorWithoutId = null;
        private Comparator<TOP> annotationFsComparatorWithId = null;
        private Comparator<TOP> annotationFsComparatorNoTypeWithoutId = null;
        private Comparator<TOP> annotationFsComparatorNoTypeWithId = null;
        private boolean isSetUpFromBaseCAS = false;

        SharedIndexInfo(TypeSystemImpl typeSystem) {
            this.tsi = typeSystem;
        }
    }
}

