/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.uima.tools.cvd.AnnotationExtent;
import org.apache.uima.tools.cvd.MarkupExtent;

public class MultiAnnotViewerFrame
extends JFrame {
    private static final long serialVersionUID = -920372876117526451L;
    private JScrollPane scrollPane;
    private JTextPane textPane;

    public MultiAnnotViewerFrame() {
    }

    public MultiAnnotViewerFrame(GraphicsConfiguration gc) {
        super(gc);
    }

    public MultiAnnotViewerFrame(String title) {
        super(title);
    }

    public MultiAnnotViewerFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
    }

    public void init(String text, MarkupExtent[] extents) {
        this.textPane = new JTextPane();
        this.scrollPane = new JScrollPane(this.textPane);
        this.setContentPane(this.scrollPane);
        Document doc = this.textPane.getDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style level0 = this.textPane.addStyle("level0", def);
        Style level1 = this.textPane.addStyle("level1", level0);
        StyleConstants.setBackground(level1, Color.green);
        Style level2 = this.textPane.addStyle("level2", level0);
        StyleConstants.setBackground(level2, Color.yellow);
        Style level3 = this.textPane.addStyle("level3", level0);
        StyleConstants.setBackground(level3, Color.orange);
        Style[] styleArray = new Style[]{level0, level1, level2, level3};
        System.out.println("  Creating the text.");
        try {
            for (int i = 0; i < extents.length; ++i) {
                MarkupExtent e = extents[i];
                int level = e.getMarkupDepth();
                if (level > 3) {
                    level = 3;
                }
                String s = text.substring(e.getStart(), e.getEnd());
                doc.insertString(doc.getLength(), s, styleArray[level]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.textPane.getCaret().setDot(0);
        System.out.println("  Packing frame.");
        this.pack();
        System.out.println("  Showing frame.");
        this.setVisible(true);
    }

    public void init(String text, AnnotationExtent[] extents, Dimension size) {
        this.textPane = new JTextPane();
        this.scrollPane = new JScrollPane(this.textPane);
        if (size == null) {
            System.out.println("Size is null.");
        } else {
            System.out.println("Setting size");
        }
        this.scrollPane.setPreferredSize(size);
        this.setContentPane(this.scrollPane);
        Document doc = this.textPane.getDocument();
        try {
            for (int i = 0; i < extents.length; ++i) {
                AnnotationExtent e = extents[i];
                String s = text.substring(e.getStart(), e.getEnd());
                doc.insertString(doc.getLength(), s, e.getStyle());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("  Packing frame.");
        this.pack();
        System.out.println("  Showing frame.");
        this.setVisible(true);
    }

    public void initHtml(String text, MarkupExtent[] extents) {
        this.textPane = new JTextPane();
        this.textPane.setContentType("text/html");
        this.scrollPane = new JScrollPane(this.textPane);
        this.setContentPane(this.scrollPane);
        StringBuffer buf = new StringBuffer();
        buf.append("<html><head></head><body>\n");
        block6: for (int i = 0; i < extents.length; ++i) {
            MarkupExtent e = extents[i];
            int level = e.getMarkupDepth();
            String s = text.substring(e.getStart(), e.getEnd());
            if (level > 3) {
                level = 3;
            }
            switch (level) {
                case 0: {
                    buf.append(s);
                    continue block6;
                }
                case 1: {
                    buf.append("<font color=green>");
                    buf.append(s);
                    buf.append("</font>");
                    continue block6;
                }
                case 2: {
                    buf.append("<font color=yellow>");
                    buf.append(s);
                    buf.append("</font>");
                    continue block6;
                }
                case 3: {
                    buf.append("<font color=red>");
                    buf.append(s);
                    buf.append("</font>");
                }
            }
        }
        buf.append("\n</body></html>");
        this.textPane.setText(buf.toString());
        this.pack();
        this.setVisible(true);
    }
}

