/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.util;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;

public class ContainingConstraint
implements FSMatchConstraint {
    private static final long serialVersionUID = 1L;
    private Collection<AnnotationFS> mContainingAnnotations = new LinkedList<AnnotationFS>();

    public void add(AnnotationFS containingAnnotation) {
        this.mContainingAnnotations.add(containingAnnotation);
    }

    public boolean match(FeatureStructure featureStructure) {
        boolean result = false;
        if (featureStructure instanceof AnnotationFS) {
            AnnotationFS annotation = (AnnotationFS)featureStructure;
            for (AnnotationFS containingAnnotation : this.mContainingAnnotations) {
                if (!this.isContaining(annotation, containingAnnotation)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isContaining(AnnotationFS annotation, AnnotationFS containing) {
        return containing.getBegin() <= annotation.getBegin() && containing.getEnd() >= annotation.getEnd();
    }
}

