/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.BaseServer;
import org.apache.vinci.transport.ErrorFrame;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.Transportable;

public class BaseServerRunnable
implements Runnable {
    private Socket socket;
    private BaseServer parent;
    private static final ThreadLocal THREAD_LOCAL_SOCKET = new ThreadLocal();

    public static Socket getSocket() {
        return (Socket)THREAD_LOCAL_SOCKET.get();
    }

    public BaseServerRunnable(Socket c, BaseServer p) {
        this.socket = c;
        this.parent = p;
    }

    protected BaseServer getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        THREAD_LOCAL_SOCKET.set(this.socket);
        try {
            BufferedInputStream is = new BufferedInputStream(this.socket.getInputStream());
            BufferedOutputStream os = new BufferedOutputStream(this.socket.getOutputStream());
            while (true) {
                Transportable in = this.parent.makeTransportable();
                KeyValuePair header = null;
                try {
                    header = in.fromStream(is);
                }
                catch (EOFException e) {
                    break;
                }
                Transportable out = this.handleHeader(header);
                if (out == null) {
                    try {
                        out = this.parent.eval(in, header);
                    }
                    catch (Throwable e) {
                        Debug.reportException(e);
                        out = new ErrorFrame("Server failed: " + e);
                    }
                }
                if (out == null) continue;
                out.toStream(os);
                ((OutputStream)os).flush();
            }
        }
        catch (IOException e) {
            Debug.p("IOException in BaseServerRunnable: " + e);
        }
        catch (Throwable e) {
            Debug.reportException(e);
        }
        finally {
            THREAD_LOCAL_SOCKET.set(null);
            try {
                this.socket.close();
            }
            catch (IOException f) {
                Debug.reportException(f);
            }
        }
    }

    public Transportable handleHeader(KeyValuePair header) {
        return null;
    }
}

