/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;

public class ZippedElementsShouldSatisfy
extends BasicErrorMessageFactory {
    private static final String DELIMITER = String.format("%n%n- ", new Object[0]);

    public static ErrorMessageFactory zippedElementsShouldSatisfy(AssertionInfo info, Iterable<?> actual, Iterable<?> other, List<ZipSatisfyError> zipSatisfyErrors) {
        return new ZippedElementsShouldSatisfy(info, actual, other, zipSatisfyErrors);
    }

    private ZippedElementsShouldSatisfy(AssertionInfo info, Iterable<?> actual, Iterable<?> other, List<ZipSatisfyError> zipSatisfyErrors) {
        super("%nExpecting zipped elements of:%n  <%s>%nand:%n  <%s>%nto satisfy given requirements but these zipped elements did not:" + ZippedElementsShouldSatisfy.describe(info, zipSatisfyErrors), actual, other);
    }

    private static String describe(AssertionInfo info, List<ZipSatisfyError> zipSatisfyErrors) {
        List errorsToStrings = zipSatisfyErrors.stream().map(error -> ZipSatisfyError.describe(info, error)).collect(Collectors.toList());
        return Strings.escapePercent(DELIMITER + String.join((CharSequence)DELIMITER, errorsToStrings));
    }

    public static class ZipSatisfyError {
        public final Object actualElement;
        public final Object otherElement;
        public final String error;

        public ZipSatisfyError(Object actualElement, Object otherElement, String error) {
            this.actualElement = actualElement;
            this.otherElement = otherElement;
            this.error = error;
        }

        public static String describe(AssertionInfo info, ZipSatisfyError satisfyError) {
            return String.format("(%s, %s) error: %s", info.representation().toStringOf(satisfyError.actualElement), info.representation().toStringOf(satisfyError.otherElement), satisfyError.error);
        }

        public String toString() {
            return String.format("(%s, %s) error: %s", this.actualElement, this.otherElement, this.error);
        }
    }
}

