/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.BinaryCasSerDes;
import org.apache.uima.cas.impl.BinaryCasSerDes4;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.CommonSerDesSequential;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.Heap;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.Obj2IntIdentityHashMap;
import org.apache.uima.internal.util.function.Consumer_T_withIOException;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.CasIOUtils;

public class CASSerializer
implements Serializable {
    static final long serialVersionUID = -7972011651957420295L;
    public int[] heapArray = null;
    public int[] heapMetaData = null;
    public String[] stringTable;
    public int[] fsIndex;
    public byte[] byteHeapArray;
    public short[] shortHeapArray;
    public long[] longHeapArray;

    public void addNoMetaData(CASImpl casImpl) {
        this.addCAS(casImpl, false);
    }

    public void addCAS(CASImpl cas) {
        this.addCAS(cas, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCAS(CASImpl cas, boolean addMetaData) {
        CASImpl.SharedViewData sharedViewData = cas.svd;
        synchronized (sharedViewData) {
            BinaryCasSerDes bcsd = cas.getBinaryCasSerDes();
            CommonSerDesSequential csds = BinaryCasSerDes4.getCsds(cas.getBaseCAS(), false);
            bcsd.scanAllFSsForBinarySerialization(null, csds);
            this.fsIndex = bcsd.getIndexedFSs(csds.fs2addr);
            if (addMetaData) {
                int heapsz = bcsd.heap.getCellsUsed();
                this.heapMetaData = new int[]{Heap.getRoundedSize(heapsz), heapsz, heapsz, 0, 0, 1024, 0};
            }
            this.copyHeapsToArrays(bcsd);
        }
    }

    private void outputStringHeap(DataOutputStream dos, CASImpl cas, StringHeapDeserializationHelper shdh, BinaryCasSerDes bcsd) throws IOException {
        int stringHeapLength = shdh.charHeapPos;
        int stringListLength = 0;
        for (int i = 0; i < shdh.refHeap.length; i += 3) {
            int ref = shdh.refHeap[i + 2];
            if (ref == 0) continue;
            stringListLength += 1 + bcsd.stringHeap.getStringForCode(ref).length();
        }
        int stringTotalLength = stringHeapLength + stringListLength;
        if (stringHeapLength == 0 && stringListLength > 0) {
            ++stringTotalLength;
        }
        dos.writeInt(stringTotalLength);
        if (stringTotalLength > 0) {
            if (shdh.charHeapPos > 0) {
                dos.writeChars(String.valueOf(shdh.charHeap, 0, shdh.charHeapPos));
            } else if (stringListLength > 0) {
                dos.writeChar(0);
            }
            if (stringTotalLength % 2 != 0) {
                dos.writeChar(0);
            }
        }
        int refheapsz = (shdh.refHeap.length - 3) / 3 * 2;
        dos.writeInt(++refheapsz);
        dos.writeInt(0);
        for (int i = 3; i < shdh.refHeap.length; i += 3) {
            dos.writeInt(shdh.refHeap[i + 0]);
            dos.writeInt(shdh.refHeap[i + 1]);
        }
    }

    void addTsiCAS(CASImpl cas, OutputStream ostream) {
    }

    public void addCAS(CASImpl cas, OutputStream ostream) {
        this.addCAS(cas, ostream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCAS(CASImpl cas, OutputStream ostream, boolean includeTsi) {
        CASImpl.SharedViewData sharedViewData = cas.svd;
        synchronized (sharedViewData) {
            BinaryCasSerDes bcsd = cas.getBinaryCasSerDes();
            CommonSerDesSequential csds = BinaryCasSerDes4.getCsds(cas.getBaseCAS(), false);
            bcsd.scanAllFSsForBinarySerialization(null, csds);
            try {
                DataOutputStream dos = new DataOutputStream(ostream);
                this.fsIndex = bcsd.getIndexedFSs(csds.fs2addr);
                CommonSerDes.createHeader().seqVer(2).typeSystemIndexDefIncluded(includeTsi).v3().write(dos);
                if (includeTsi) {
                    CasIOUtils.writeTypeSystem(cas, ostream, true);
                }
                int heapSize = bcsd.heap.getCellsUsed();
                dos.writeInt(heapSize);
                int[] vs = bcsd.heap.heap;
                for (int i = 0; i < heapSize; ++i) {
                    dos.writeInt(vs[i]);
                }
                StringHeapDeserializationHelper shdh = bcsd.stringHeap.serialize();
                this.outputStringHeap(dos, cas, shdh, bcsd);
                dos.writeInt(this.fsIndex.length);
                for (int i = 0; i < this.fsIndex.length; ++i) {
                    dos.writeInt(this.fsIndex[i]);
                }
                int byteheapsz = bcsd.byteHeap.getSize();
                dos.writeInt(byteheapsz);
                dos.write(bcsd.byteHeap.heap, 0, byteheapsz);
                int align = (4 - byteheapsz % 4) % 4;
                for (int i = 0; i < align; ++i) {
                    dos.writeByte(0);
                }
                int shortheapsz = bcsd.shortHeap.getSize();
                dos.writeInt(shortheapsz);
                short[] sh = bcsd.shortHeap.heap;
                for (int i = 0; i < shortheapsz; ++i) {
                    dos.writeShort(sh[i]);
                }
                if (shortheapsz % 2 != 0) {
                    dos.writeShort(0);
                }
                int longheapsz = bcsd.longHeap.getSize();
                dos.writeInt(longheapsz);
                long[] lh = bcsd.longHeap.heap;
                for (int i = 0; i < longheapsz; ++i) {
                    dos.writeLong(lh[i]);
                }
            }
            catch (IOException e) {
                throw new CASRuntimeException("BLOB_SERIALIZATION", e.getMessage());
            }
            bcsd.setHeapExtents();
            csds.setHeapEnd(bcsd.nextHeapAddrAfterMark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCAS(CASImpl cas, OutputStream ostream, Marker trackingMark) {
        if (!trackingMark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", "Invalid Marker.");
        }
        MarkerImpl mark = (MarkerImpl)trackingMark;
        CASImpl.SharedViewData sharedViewData = cas.svd;
        synchronized (sharedViewData) {
            BinaryCasSerDes bcsd = cas.getBinaryCasSerDes();
            CommonSerDesSequential csds = BinaryCasSerDes4.getCsds(cas.getBaseCAS(), true);
            List<TOP> all = bcsd.scanAllFSsForBinarySerialization(mark, csds);
            Obj2IntIdentityHashMap<TOP> fs2auxOffset = new Obj2IntIdentityHashMap<TOP>(TOP.class, TOP._singleton);
            int byteOffset = 1;
            int shortOffset = 1;
            int longOffset = 1;
            for (TOP fs : all) {
                if (trackingMark.isNew(fs)) break;
                if (fs instanceof CommonArrayFS) {
                    CommonArrayFS ca = (CommonArrayFS)((Object)fs);
                    SlotKinds.SlotKind kind = fs._getTypeImpl().getComponentSlotKind();
                    switch (kind) {
                        case Slot_BooleanRef: 
                        case Slot_ByteRef: {
                            fs2auxOffset.put(fs, byteOffset);
                            byteOffset += ca.size();
                            break;
                        }
                        case Slot_ShortRef: {
                            fs2auxOffset.put(fs, shortOffset);
                            shortOffset += ca.size();
                            break;
                        }
                        case Slot_LongRef: 
                        case Slot_DoubleRef: {
                            fs2auxOffset.put(fs, longOffset);
                            longOffset += ca.size();
                            break;
                        }
                    }
                    continue;
                }
                TypeImpl ti = fs._getTypeImpl();
                longOffset += ti.getNbrOfLongOrDoubleFeatures();
            }
            try {
                int i;
                DataOutputStream dos = new DataOutputStream(ostream);
                this.fsIndex = bcsd.getDeltaIndexedFSs(mark, csds.fs2addr);
                CommonSerDes.createHeader().delta().seqVer(2).v3().write(dos);
                int heapSize = bcsd.heap.getCellsUsed() - 1;
                dos.writeInt(heapSize);
                int[] vs = bcsd.heap.heap;
                for (int i2 = 1; i2 <= heapSize; ++i2) {
                    dos.writeInt(vs[i2]);
                }
                ArrayList<AddrPlusValue> chgMainAvs = new ArrayList<AddrPlusValue>();
                ArrayList<AddrPlusValue> chgByteAvs = new ArrayList<AddrPlusValue>();
                ArrayList<AddrPlusValue> chgShortAvs = new ArrayList<AddrPlusValue>();
                ArrayList<AddrPlusValue> chgLongAvs = new ArrayList<AddrPlusValue>();
                CASSerializer.scanModifications(bcsd, csds, cas.getModifiedFSList(), fs2auxOffset, chgMainAvs, chgByteAvs, chgShortAvs, chgLongAvs);
                StringHeapDeserializationHelper shdh = bcsd.stringHeap.serialize(1);
                this.outputStringHeap(dos, cas, shdh, bcsd);
                int modHeapSize = chgMainAvs.size();
                dos.writeInt(modHeapSize);
                for (AddrPlusValue av2 : chgMainAvs) {
                    dos.writeInt(av2.addr);
                    dos.writeInt((int)av2.value);
                }
                dos.writeInt(this.fsIndex.length);
                for (int i3 = 0; i3 < this.fsIndex.length; ++i3) {
                    dos.writeInt(this.fsIndex[i3]);
                }
                int byteheapsz = bcsd.byteHeap.getSize() - 1;
                dos.writeInt(byteheapsz);
                dos.write(bcsd.byteHeap.heap, 1, byteheapsz);
                int align = (4 - byteheapsz % 4) % 4;
                for (int i4 = 0; i4 < align; ++i4) {
                    dos.writeByte(0);
                }
                int shortheapsz = bcsd.shortHeap.getSize() - 1;
                dos.writeInt(shortheapsz);
                for (int i5 = 1; i5 <= shortheapsz; ++i5) {
                    dos.writeShort(bcsd.shortHeap.heap[i5]);
                }
                if (shortheapsz % 2 != 0) {
                    dos.writeShort(0);
                }
                int longheapsz = bcsd.longHeap.getSize() - 1;
                dos.writeInt(longheapsz);
                for (i = 1; i <= longheapsz; ++i) {
                    dos.writeLong(bcsd.longHeap.heap[i]);
                }
                this.writeMods(chgByteAvs, dos, av -> dos.writeByte((byte)av.value));
                align = (4 - chgByteAvs.size() % 4) % 4;
                for (i = 0; i < align; ++i) {
                    dos.writeByte(0);
                }
                this.writeMods(chgShortAvs, dos, av -> dos.writeShort((short)av.value));
                if (chgShortAvs.size() % 2 != 0) {
                    dos.writeShort(0);
                }
                this.writeMods(chgLongAvs, dos, av -> dos.writeLong(av.value));
            }
            catch (IOException e) {
                throw new CASRuntimeException("BLOB_SERIALIZATION", e.getMessage());
            }
        }
    }

    private void writeMods(List<AddrPlusValue> avs, DataOutputStream dos, Consumer_T_withIOException<AddrPlusValue> writeValue) throws IOException {
        int size = avs.size();
        dos.writeInt(size);
        for (AddrPlusValue av : avs) {
            dos.writeInt(av.addr);
        }
        for (AddrPlusValue av : avs) {
            writeValue.accept(av);
        }
    }

    private static int convertArrayIndexToAuxHeapAddr(BinaryCasSerDes bcsd, int index, TOP fs, Obj2IntIdentityHashMap<TOP> fs2auxOffset) {
        int offset = fs2auxOffset.get(fs);
        assert (offset > 0);
        return offset;
    }

    private static int convertArrayIndexToMainHeapAddr(int index, TOP fs, Obj2IntIdentityHashMap<TOP> fs2addr) {
        return fs2addr.get(fs) + 2 + index;
    }

    static void scanModifications(BinaryCasSerDes bcsd, CommonSerDesSequential csds, CASImpl.FsChange[] fssModified, Obj2IntIdentityHashMap<TOP> fs2auxOffset, List<AddrPlusValue> chgMainAvs, List<AddrPlusValue> chgByteAvs, List<AddrPlusValue> chgShortAvs, List<AddrPlusValue> chgLongAvs) {
        Obj2IntIdentityHashMap<TOP> fs2addr = csds.fs2addr;
        for (CASImpl.FsChange fsChange : fssModified) {
            TOP fs = fsChange.fs;
            TypeImpl type = fs._getTypeImpl();
            if (fsChange.arrayUpdates != null) {
                switch (type.getComponentSlotKind()) {
                    case Slot_BooleanRef: {
                        fsChange.arrayUpdates.forAllInts(index -> chgByteAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToAuxHeapAddr(bcsd, index, fs, fs2auxOffset), ((BooleanArray)fs).get(index) ? 1L : 0L)));
                        break;
                    }
                    case Slot_ByteRef: {
                        fsChange.arrayUpdates.forAllInts(index -> chgByteAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToAuxHeapAddr(bcsd, index, fs, fs2auxOffset), ((ByteArray)fs).get(index))));
                        break;
                    }
                    case Slot_ShortRef: {
                        fsChange.arrayUpdates.forAllInts(index -> chgShortAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToAuxHeapAddr(bcsd, index, fs, fs2auxOffset), ((ShortArray)fs).get(index))));
                        break;
                    }
                    case Slot_LongRef: {
                        fsChange.arrayUpdates.forAllInts(index -> chgLongAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToAuxHeapAddr(bcsd, index, fs, fs2auxOffset), ((LongArray)fs).get(index))));
                        break;
                    }
                    case Slot_DoubleRef: {
                        fsChange.arrayUpdates.forAllInts(index -> chgLongAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToAuxHeapAddr(bcsd, index, fs, fs2auxOffset), CASImpl.double2long(((DoubleArray)fs).get(index)))));
                        break;
                    }
                    case Slot_Int: {
                        fsChange.arrayUpdates.forAllInts(index -> chgMainAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToMainHeapAddr(index, fs, fs2addr), ((IntegerArray)fs).get(index))));
                        break;
                    }
                    case Slot_Float: {
                        fsChange.arrayUpdates.forAllInts(index -> chgMainAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToMainHeapAddr(index, fs, fs2addr), CASImpl.float2int(((FloatArray)fs).get(index)))));
                        break;
                    }
                    case Slot_StrRef: {
                        fsChange.arrayUpdates.forAllInts(index -> {
                            int v = bcsd.nextStringHeapAddrAfterMark + bcsd.stringHeap.addString(((StringArray)fs).get(index));
                            chgMainAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToMainHeapAddr(index, fs, fs2addr), v));
                        });
                        break;
                    }
                    case Slot_HeapRef: {
                        fsChange.arrayUpdates.forAllInts(index -> {
                            TOP tgtFs = (TOP)((FSArray)fs).get(index);
                            chgMainAvs.add(new AddrPlusValue(CASSerializer.convertArrayIndexToMainHeapAddr(index, fs, fs2addr), fs2addr.get(tgtFs)));
                        });
                        break;
                    }
                    default: {
                        Misc.internalError();
                        break;
                    }
                }
                continue;
            }
            if (fs instanceof UimaSerializable) {
                ((UimaSerializable)((Object)fs))._save_to_cas_data();
            }
            BitSet fm = fsChange.featuresModified;
            int offset = fm.nextSetBit(0);
            while (offset >= 0) {
                int addr = csds.fs2addr.get(fs) + offset + 1;
                int value = 0;
                FeatureImpl feat = type.getFeatureImpls()[offset];
                switch (feat.getSlotKind()) {
                    case Slot_Boolean: {
                        value = fs._getBooleanValueNc(feat) ? 1 : 0;
                        break;
                    }
                    case Slot_Byte: {
                        value = fs._getByteValueNc(feat);
                        break;
                    }
                    case Slot_Short: {
                        value = fs._getShortValueNc(feat);
                        break;
                    }
                    case Slot_Int: {
                        value = fs._getIntValueNc(feat);
                        break;
                    }
                    case Slot_Float: {
                        value = CASImpl.float2int(fs._getFloatValueNc(feat));
                        break;
                    }
                    case Slot_LongRef: {
                        value = bcsd.nextLongHeapAddrAfterMark + bcsd.longHeap.addLong(fs._getLongValueNc(feat));
                        break;
                    }
                    case Slot_DoubleRef: {
                        value = bcsd.nextLongHeapAddrAfterMark + bcsd.longHeap.addLong(CASImpl.double2long(fs._getDoubleValueNc(feat)));
                        break;
                    }
                    case Slot_StrRef: {
                        value = bcsd.nextStringHeapAddrAfterMark + bcsd.stringHeap.addString(fs._getStringValueNc(feat));
                        break;
                    }
                    case Slot_HeapRef: {
                        value = fs2addr.get(fs._getFeatureValueNc(feat));
                        break;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
                chgMainAvs.add(new AddrPlusValue(addr, value));
                offset = fm.nextSetBit(offset + 1);
            }
        }
    }

    int[] getHeapMetadata() {
        return this.heapMetaData;
    }

    int[] getHeapArray() {
        return this.heapArray;
    }

    String[] getStringTable() {
        return this.stringTable;
    }

    int[] getFSIndex() {
        return this.fsIndex;
    }

    byte[] getByteArray() {
        return this.byteHeapArray;
    }

    short[] getShortArray() {
        return this.shortHeapArray;
    }

    long[] getLongArray() {
        return this.longHeapArray;
    }

    private void copyHeapsToArrays(BinaryCasSerDes bcsd) {
        this.heapArray = bcsd.heap.toArray();
        this.byteHeapArray = bcsd.byteHeap.toArray();
        this.shortHeapArray = bcsd.shortHeap.toArray();
        this.longHeapArray = bcsd.longHeap.toArray();
        this.stringTable = bcsd.stringHeap.toArray();
    }

    static class AddrPlusValue {
        final int addr;
        final long value;

        AddrPlusValue(int addr, long value) {
            this.addr = addr;
            this.value = value;
        }
    }
}

