/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.cpe;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeInclude;
import org.apache.uima.collection.metadata.CpeIntegratedCasProcessor;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CpeBuilder {
    private static final String ACTION_ON_MAX_ERROR = "terminate";
    private int maxProcessingUnitThreadCount = 1;
    private final CpeDescription cpeDesc = CpeDescriptorFactory.produceDescriptor();

    public void setMaxProcessingUnitThreadCount(int aMaxProcessingUnitThreadCount) {
        this.maxProcessingUnitThreadCount = aMaxProcessingUnitThreadCount;
    }

    public void setReader(CollectionReaderDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        this.cpeDesc.setAllCollectionCollectionReaders(new CpeCollectionReader[0]);
        URL descUrl = CpeBuilder.materializeDescriptor((ResourceSpecifier)aDesc).toURI().toURL();
        CpeCollectionReader reader = CpeDescriptorFactory.produceCollectionReader((String)descUrl.toString());
        this.cpeDesc.addCollectionReader(reader);
    }

    public void setAnalysisEngine(AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException, InvalidXMLException {
        this.cpeDesc.setCpeCasProcessors(null);
        if (aDesc.isPrimitive()) {
            CpeIntegratedCasProcessor proc = CpeBuilder.createProcessor("delegate", aDesc);
            this.cpeDesc.addCasProcessor((CpeCasProcessor)proc);
        } else {
            Map delegates = aDesc.getDelegateAnalysisEngineSpecifiers();
            FixedFlow flow = (FixedFlow)aDesc.getAnalysisEngineMetaData().getFlowConstraints();
            for (String key : flow.getFixedFlow()) {
                AnalysisEngineDescription aeDesc = (AnalysisEngineDescription)delegates.get(key);
                CpeIntegratedCasProcessor proc = CpeBuilder.createProcessor(key, aeDesc);
                this.cpeDesc.addCasProcessor((CpeCasProcessor)proc);
            }
        }
    }

    public CpeDescription getCpeDescription() {
        return this.cpeDesc;
    }

    public CollectionProcessingEngine createCpe(StatusCallbackListener aListener) throws ResourceInitializationException, CpeDescriptorException {
        ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
        if (this.maxProcessingUnitThreadCount == 0) {
            this.cpeDesc.getCpeCasProcessors().setPoolSize(3);
        } else {
            this.cpeDesc.getCpeCasProcessors().setPoolSize(this.maxProcessingUnitThreadCount + 2);
            this.cpeDesc.setProcessingUnitThreadCount(this.maxProcessingUnitThreadCount);
        }
        CollectionProcessingEngine cpe = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)this.cpeDesc, (ResourceManager)resMgr, null);
        if (aListener != null) {
            cpe.addStatusCallbackListener(aListener);
        }
        return cpe;
    }

    private static File materializeDescriptor(ResourceSpecifier resource) throws IOException, SAXException {
        File tempDesc = File.createTempFile("desc", ".xml");
        tempDesc.deleteOnExit();
        try (OutputStream os = Files.newOutputStream(tempDesc.toPath(), new OpenOption[0]);){
            XMLSerializer sax2xml = new XMLSerializer(os, true);
            sax2xml.setOutputProperty("version", "1.1");
            ContentHandler contentHandler = sax2xml.getContentHandler();
            contentHandler.startDocument();
            resource.toXML(sax2xml.getContentHandler(), true);
            contentHandler.endDocument();
        }
        return tempDesc;
    }

    private static CpeIntegratedCasProcessor createProcessor(String key, AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        URL descUrl = CpeBuilder.materializeDescriptor((ResourceSpecifier)aDesc).toURI().toURL();
        CpeInclude cpeInclude = UIMAFramework.getResourceSpecifierFactory().createInclude();
        cpeInclude.set(descUrl.toString());
        CpeComponentDescriptor ccd = UIMAFramework.getResourceSpecifierFactory().createDescriptor();
        ccd.setInclude(cpeInclude);
        CpeIntegratedCasProcessor proc = CpeDescriptorFactory.produceCasProcessor((String)key);
        proc.setCpeComponentDescriptor(ccd);
        proc.setAttributeValue("1", (Object)1);
        proc.setActionOnMaxError(ACTION_ON_MAX_ERROR);
        proc.setMaxErrorCount(0);
        return proc;
    }
}

