/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.core;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public final class EmailUtils {
    private static final Random RANDOM;
    private static final int RADIX = 16;
    private static final char ESCAPE_CHAR = '%';
    private static final BitSet SAFE_URL;

    public static String encodeUrl(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (byte c : input.getBytes(StandardCharsets.US_ASCII)) {
            int b = c & 0xFF;
            if (SAFE_URL.get(b)) {
                builder.append((char)b);
                continue;
            }
            builder.append('%');
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            builder.append(hex1);
            builder.append(hex2);
        }
        return builder.toString();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    private static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        StringBuilder buffer = new StringBuilder();
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && numbers && Character.isLetterOrDigit(ch) || letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                buffer.append(ch);
                continue;
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String randomAlphabetic(int count) {
        return EmailUtils.random(count, 0, 0, true, false, null, RANDOM);
    }

    public static String replaceEndOfLineCharactersWithSpaces(String input) {
        return input == null ? null : input.replace('\n', ' ').replace('\r', ' ');
    }

    public static String toLower(String value) {
        return value.toLowerCase(Locale.ROOT);
    }

    private EmailUtils() {
    }

    static {
        int i;
        RANDOM = new Random();
        SAFE_URL = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            SAFE_URL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            SAFE_URL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            SAFE_URL.set(i);
        }
        SAFE_URL.set(45);
        SAFE_URL.set(95);
        SAFE_URL.set(46);
        SAFE_URL.set(42);
        SAFE_URL.set(43);
        SAFE_URL.set(36);
        SAFE_URL.set(33);
        SAFE_URL.set(39);
        SAFE_URL.set(40);
        SAFE_URL.set(41);
        SAFE_URL.set(44);
        SAFE_URL.set(64);
    }
}

