/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.AnnotationProcessor;
import org.apache.turbine.annotation.TurbineActionEvent;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.modules.Action;
import org.apache.turbine.pipeline.PipelineData;

public abstract class ActionEvent
implements Action {
    protected Logger log = LogManager.getLogger(this.getClass());
    protected static final String BUTTON = "eventSubmit_";
    protected static final int BUTTON_LENGTH = "eventSubmit_".length();
    protected static final String DEFAULT_METHOD = "doPerform";
    protected static final String METHOD_NAME_PREFIX = "do";
    protected static final int METHOD_NAME_LENGTH = "do".length();
    protected static final int LENGTH = "eventSubmit_".length();
    @TurbineConfiguration(value="action.eventsubmit.needsvalue")
    private boolean submitValueKey = false;
    @TurbineConfiguration(value="action.event.bubbleexception")
    protected boolean bubbleUpException = true;
    private ConcurrentMap<String, Method> methodCache = new ConcurrentHashMap<String, Method>();

    protected Method getMethod(String name, Class<?>[] signature, ParameterParser pp) throws NoSuchMethodException {
        StringBuilder cacheKey = new StringBuilder(name);
        for (Class<?> clazz : signature) {
            cacheKey.append(':').append(clazz.getCanonicalName());
        }
        Method method = (Method)this.methodCache.get(cacheKey.toString());
        if (method == null) {
            Method oldMethod;
            Method[] methods;
            block1: for (Method m : methods = this.getClass().getMethods()) {
                Annotation[] annotations;
                for (Annotation a : annotations = AnnotationProcessor.getAnnotations(m)) {
                    TurbineActionEvent tae;
                    if (!(a instanceof TurbineActionEvent) || !name.equals(pp.convert((tae = (TurbineActionEvent)a).value())) || !Arrays.equals(signature, m.getParameterTypes())) continue;
                    method = m;
                    break block1;
                }
            }
            if (method == null) {
                String tmp = name.toLowerCase().substring(METHOD_NAME_LENGTH);
                method = this.getClass().getMethod(METHOD_NAME_PREFIX + StringUtils.capitalize((String)tmp), signature);
            }
            if ((oldMethod = this.methodCache.putIfAbsent(cacheKey.toString(), method)) != null) {
                method = oldMethod;
            }
        }
        return method;
    }

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        ParameterParser pp = pipelineData.get(Turbine.class, ParameterParser.class);
        this.executeEvents(pp, new Class[]{PipelineData.class}, new Object[]{pipelineData});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeEvents(ParameterParser pp, Class<?>[] signature, Object[] parameters) throws Exception {
        String theButton = null;
        String button = pp.convert(BUTTON);
        String key = null;
        for (String k : pp) {
            key = k;
            if (!key.startsWith(button) || !this.considerKey(key, pp)) continue;
            theButton = key;
            break;
        }
        if (theButton == null) {
            theButton = "eventSubmit_doPerform";
            key = null;
        }
        theButton = this.formatString(theButton, pp);
        Method method = null;
        try {
            method = this.getMethod(theButton, signature, pp);
        }
        catch (NoSuchMethodException e) {
            method = this.getMethod(DEFAULT_METHOD, signature, pp);
        }
        finally {
            if (key != null) {
                pp.remove(key);
            }
        }
        try {
            this.log.debug("Invoking {}", (Object)method);
            method.invoke((Object)this, parameters);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (this.bubbleUpException) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw ite;
            }
            this.log.error("Invokation of {}", (Object)method, (Object)t);
        }
    }

    protected String formatString(String input, ParameterParser pp) {
        String tmp = input;
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            tmp = input.toLowerCase();
            String methodName = tmp.endsWith(".x") || tmp.endsWith(".y") ? input.substring(0, input.length() - 2) : input;
            tmp = pp.getUrlFolding() == ValueParser.URLCaseFolding.NONE ? methodName.substring(BUTTON_LENGTH) : methodName.toLowerCase().substring(BUTTON_LENGTH);
        }
        return tmp;
    }

    protected boolean considerKey(String key, ParameterParser pp) {
        if (!this.submitValueKey) {
            this.log.debug("No Value required, accepting {}", (Object)key);
            return true;
        }
        String keyValue = pp.getString(key);
        this.log.debug("Key Value is {}", (Object)keyValue);
        if (StringUtils.isEmpty((CharSequence)keyValue)) {
            this.log.debug("Key is empty, rejecting {}", (Object)key);
            return false;
        }
        try {
            if (Integer.parseInt(keyValue) != 0) {
                this.log.debug("Integer != 0, accepting {}", (Object)key);
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            this.log.debug("Not a number, accepting " + key);
            return true;
        }
        this.log.debug("Rejecting {}", (Object)key);
        return false;
    }
}

