/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedMethod;
import org.python.expose.ExposedType;

@ExposedType(name="rangeiterator", base=PyObject.class, isBaseType=false)
public class PyXRangeIter
extends PyIterator {
    public static final PyType TYPE = PyType.fromClass(PyXRangeIter.class);
    private long index;
    private long start;
    private long step;
    private long len;

    public PyXRangeIter(long index, long start, long step, long len) {
        super(TYPE);
        this.index = index;
        this.start = start;
        this.step = step;
        this.len = len;
    }

    @ExposedMethod(doc="x.next() -> the next value, or raise StopIteration")
    final PyObject rangeiterator_next() {
        return super.next();
    }

    @Override
    public PyObject __iternext__() {
        if (this.index < this.len) {
            return Py.newInteger(this.start + this.index++ * this.step);
        }
        return null;
    }

    static {
        TYPE.setName("rangeiterator");
    }
}

