/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.CriteriaInterface;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.Join;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.UniqueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinBuilder {
    private JoinBuilder() {
    }

    public static void processJoins(CriteriaInterface<?> criteria, Query query) throws TorqueException {
        List<Join> criteriaJoins = criteria.getJoins();
        if (criteriaJoins.isEmpty()) {
            return;
        }
        UniqueList<FromElement> queryFromClause = query.getFromClause();
        UniqueList<String> queryWhereClause = query.getWhereClause();
        for (int i = 0; i < criteriaJoins.size(); ++i) {
            FromElement fromElement;
            PreparedStatementPart rightExpression;
            PreparedStatementPart leftExpression;
            Join join = criteriaJoins.get(i);
            JoinType joinType = join.getJoinType();
            if (joinType == null) {
                StringBuilder joinConditionStringBuilder = new StringBuilder();
                SqlBuilder.appendCriterion(join.getJoinCondition(), criteria, joinConditionStringBuilder, query);
                queryWhereClause.add(joinConditionStringBuilder.toString());
                continue;
            }
            Criterion joinCondition = join.getJoinCondition();
            if (join.getLeftTable() != null) {
                leftExpression = join.getLeftTable();
            } else {
                if (joinCondition.isComposite()) {
                    throw new TorqueException("join condition is composite and there is no leftTable defined in the join. Please define a leftTable in the join");
                }
                Object lValue = joinCondition.getLValue();
                leftExpression = SqlBuilder.getExpressionForFromClause(lValue, criteria);
            }
            if (join.getRightTable() != null) {
                rightExpression = join.getRightTable();
            } else {
                if (joinCondition.isComposite()) {
                    throw new TorqueException("join condition is composite and there is no rightTable defined in the join. Please define a rightTable in the join");
                }
                Object rValue = joinCondition.getRValue();
                rightExpression = SqlBuilder.getExpressionForFromClause(rValue, criteria);
            }
            if (!SqlBuilder.fromClauseContainsExpression(queryFromClause, rightExpression)) {
                if (!SqlBuilder.fromClauseContainsExpression(queryFromClause, leftExpression)) {
                    fromElement = new FromElement(leftExpression.getSql().toString(), null, null, leftExpression.getPreparedStatementReplacements());
                    queryFromClause.add(fromElement);
                }
                fromElement = new FromElement(rightExpression.getSql().toString(), joinType, JoinBuilder.buildJoinCondition(joinCondition, criteria));
                queryFromClause.add(fromElement);
                continue;
            }
            if (SqlBuilder.fromClauseContainsExpression(queryFromClause, leftExpression)) {
                throw new TorqueException("Unable to create a" + (Object)((Object)joinType) + "because both expressions " + leftExpression.getSql() + " and " + rightExpression.getSql() + " are already in use. Try to create an(other) alias.");
            }
            fromElement = new FromElement(leftExpression.getSql().toString(), JoinBuilder.reverseJoinType(joinType), JoinBuilder.buildJoinCondition(joinCondition, criteria));
            queryFromClause.add(fromElement);
        }
    }

    private static JoinType reverseJoinType(JoinType joinType) {
        if (JoinType.LEFT_JOIN.equals((Object)joinType)) {
            return JoinType.RIGHT_JOIN;
        }
        if (JoinType.RIGHT_JOIN.equals((Object)joinType)) {
            return JoinType.LEFT_JOIN;
        }
        return joinType;
    }

    private static PreparedStatementPart buildJoinCondition(Criterion joinCondition, CriteriaInterface<?> criteria) throws TorqueException {
        PreparedStatementPart joinPart = new PreparedStatementPart();
        JoinBuilder.appendJoinCondition(joinCondition, criteria, joinPart);
        return joinPart;
    }

    private static void appendJoinCondition(Criterion joinCondition, CriteriaInterface<?> criteria, PreparedStatementPart joinPart) throws TorqueException {
        if (joinCondition.isComposite()) {
            joinPart.getSql().append('(');
            boolean firstPart = true;
            for (Criterion part : joinCondition.getParts()) {
                if (!firstPart) {
                    joinPart.getSql().append(joinCondition.getConjunction());
                }
                JoinBuilder.appendJoinCondition(part, criteria, joinPart);
                firstPart = false;
            }
            joinPart.getSql().append(')');
            return;
        }
        PreparedStatementPart joinConditionStatementPart = SqlBuilder.processCriterion(joinCondition, criteria);
        joinPart.append(joinConditionStatementPart);
    }
}

