/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.DerbyAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public class MysqlAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = 7547291410802807010L;
    private static Log log = LogFactory.getLog(DerbyAdapter.class);

    protected MysqlAdapter() {
    }

    public String toUpperCase(String in) {
        return in;
    }

    public String ignoreCase(String in) {
        return in;
    }

    public IDMethod getIDMethodType() {
        return IDMethod.AUTO_INCREMENT;
    }

    public String getIDMethodSQL(Object obj) {
        return "SELECT LAST_INSERT_ID()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            StringBuffer stmt = new StringBuffer();
            stmt.append("LOCK TABLE ").append(table).append(" WRITE");
            statement.executeUpdate(stmt.toString());
            statement.close();
            statement = null;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Could not close statement", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockTable(Connection con, String table) throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.executeUpdate("UNLOCK TABLES");
            statement.close();
            statement = null;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Could not close statement", (Throwable)e);
                }
            }
        }
    }

    public void generateLimits(Query query, long offset, int limit) {
        if (offset > 0L) {
            if (limit >= 0) {
                query.setLimit(Integer.toString(limit));
            } else {
                query.setLimit("18446744073709551615");
            }
            query.setOffset(Long.toString(offset));
        } else if (limit >= 0) {
            query.setLimit(Integer.toString(limit));
        }
        query.setPreLimit(null);
        query.setPostLimit(null);
    }

    public boolean supportsNativeLimit() {
        return true;
    }

    public boolean supportsNativeOffset() {
        return true;
    }
}

