/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.sql.Connection;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.torque.Database;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueInstance;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.om.Persistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Torque {
    public static final String TORQUE_KEY = "torque";
    public static final String DATABASE_KEY = "database";
    public static final String DEFAULT_KEY = "default";
    public static final String SCHEMA_KEY = "schema";
    public static final String DEFAULTS_KEY = "defaults";
    public static final String DEFAULT_SCHEMA_KEY = "defaults.schema";
    public static final String MANAGER_PREFIX = "managed_class.";
    public static final String MANAGER_SUFFIX = ".manager";
    public static final String CACHE_KEY = "manager.useCache";
    public static final String TRANSACTION_MANAGER_KEY = "transactionManager";
    private static TorqueInstance torqueSingleton = null;

    private Torque() {
    }

    public static TorqueInstance getInstance() {
        if (torqueSingleton == null) {
            torqueSingleton = new TorqueInstance();
        }
        return torqueSingleton;
    }

    public static void setInstance(TorqueInstance instance) {
        torqueSingleton = instance;
    }

    public static void init(String configFile) throws TorqueException {
        Torque.getInstance().init(configFile);
    }

    public static void init(Configuration conf) throws TorqueException {
        Torque.getInstance().init(conf);
    }

    public static boolean isInit() {
        return Torque.getInstance().isInit();
    }

    public static void setConfiguration(Configuration conf) throws TorqueException {
        Torque.getInstance().setConfiguration(conf);
    }

    public static Configuration getConfiguration() {
        return Torque.getInstance().getConfiguration();
    }

    public static <T extends AbstractBaseManager<? extends Persistent>> T getManager(String name) {
        return Torque.getInstance().getManager(name);
    }

    public static <T extends AbstractBaseManager<? extends Persistent>> T getManager(String name, String defaultClassName) {
        return Torque.getInstance().getManager(name, defaultClassName);
    }

    public static void shutdown() throws TorqueException {
        Torque.getInstance().shutdown();
    }

    public static DatabaseMap getDatabaseMap() throws TorqueException {
        return Torque.getInstance().getDatabaseMap();
    }

    public static DatabaseMap getDatabaseMap(String name) throws TorqueException {
        return Torque.getInstance().getDatabaseMap(name);
    }

    public static void registerIDBroker(IDBroker idBroker) {
        Torque.getInstance().registerIDBroker(idBroker);
    }

    public static Connection getConnection() throws TorqueException {
        return Torque.getInstance().getConnection();
    }

    public static Connection getConnection(String name) throws TorqueException {
        return Torque.getInstance().getConnection(name);
    }

    public static Connection getConnection(String name, String username, String password) throws TorqueException {
        return Torque.getInstance().getConnection(name, username, password);
    }

    @Deprecated
    public static Adapter getDB(String name) throws TorqueException {
        return Torque.getInstance().getDB(name);
    }

    public static Adapter getAdapter(String name) throws TorqueException {
        return Torque.getInstance().getAdapter(name);
    }

    public static String getDefaultDB() {
        return Torque.getInstance().getDefaultDB();
    }

    public static void closeConnection(Connection con) {
        Torque.getInstance().closeConnection(con);
    }

    public static void setSchema(String name, String schema) {
        Torque.getInstance().setSchema(name, schema);
    }

    public static String getSchema(String name) throws TorqueException {
        return Torque.getInstance().getSchema(name);
    }

    public static Database getDatabase(String name) throws TorqueException {
        return Torque.getInstance().getDatabase(name);
    }

    public static Database getOrCreateDatabase(String name) {
        return Torque.getInstance().getOrCreateDatabase(name);
    }

    public static Map<String, Database> getDatabases() throws TorqueException {
        return Torque.getInstance().getDatabases();
    }
}

