/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.CondVar;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Mutex;

public class CVBuffer
implements BoundedChannel {
    private final Mutex mutex;
    private final CondVar notFull;
    private final CondVar notEmpty;
    private int count = 0;
    private int takePtr = 0;
    private int putPtr = 0;
    private final Object[] array;

    public CVBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public CVBuffer(int cap) {
        this.array = new Object[cap];
        this.mutex = new Mutex();
        this.notFull = new CondVar(this.mutex);
        this.notEmpty = new CondVar(this.mutex);
    }

    public int capacity() {
        return this.array.length;
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        boolean bl;
        this.mutex.acquire();
        try {
            if (this.count == this.array.length) {
                this.notFull.timedwait(msecs);
                if (this.count == this.array.length) {
                    boolean bl2 = false;
                    Object var6_5 = null;
                    this.mutex.release();
                    return bl2;
                }
            }
            this.array[this.putPtr] = x;
            this.putPtr = (this.putPtr + 1) % this.array.length;
            ++this.count;
            this.notEmpty.signal();
            bl = true;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.mutex.release();
            throw throwable;
        }
        Object var6_6 = null;
        this.mutex.release();
        return bl;
    }

    public Object peek() {
        try {
            Object object;
            this.mutex.acquire();
            try {
                if (this.count == 0) {
                    Object var1_1 = null;
                    Object var3_3 = null;
                    this.mutex.release();
                    return var1_1;
                }
                object = this.array[this.takePtr];
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.mutex.release();
                throw throwable;
            }
            Object var3_4 = null;
            this.mutex.release();
            return object;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        Object x = null;
        this.mutex.acquire();
        try {
            if (this.count == 0) {
                this.notEmpty.timedwait(msecs);
                if (this.count == 0) {
                    Object var4_3 = null;
                    Object var6_4 = null;
                    this.mutex.release();
                    return var4_3;
                }
            }
            x = this.array[this.takePtr];
            this.array[this.takePtr] = null;
            this.takePtr = (this.takePtr + 1) % this.array.length;
            --this.count;
            this.notFull.signal();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mutex.release();
            throw throwable;
        }
        Object var6_5 = null;
        this.mutex.release();
        return x;
    }

    public void put(Object x) throws InterruptedException {
        this.mutex.acquire();
        try {
            while (this.count == this.array.length) {
                this.notFull.await();
            }
            this.array[this.putPtr] = x;
            this.putPtr = (this.putPtr + 1) % this.array.length;
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            Object var3_2 = null;
            this.mutex.release();
        }
    }

    public Object take() throws InterruptedException {
        Object x = null;
        this.mutex.acquire();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            x = this.array[this.takePtr];
            this.array[this.takePtr] = null;
            this.takePtr = (this.takePtr + 1) % this.array.length;
            --this.count;
            this.notFull.signal();
        }
        finally {
            Object var3_2 = null;
            this.mutex.release();
        }
        return x;
    }
}

