/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer;

import java.lang.reflect.AccessibleObject;
import org.jabsorb.serializer.ObjectMatch;

public class AccessibleObjectCandidate {
    private final AccessibleObject accessibleObject;
    private final ObjectMatch[] match;
    private final Class[] parameterTypes;

    public AccessibleObjectCandidate(AccessibleObject accessibleObject, Class[] parameterTypes, ObjectMatch[] matches) {
        if (parameterTypes.length != matches.length) {
            throw new ArrayIndexOutOfBoundsException("parameter types and matches need to be of the same size");
        }
        this.accessibleObject = accessibleObject;
        this.parameterTypes = parameterTypes;
        this.match = matches;
    }

    public ObjectMatch getMatch() {
        int mismatch = ObjectMatch.OKAY.getMismatch();
        for (int i = 0; i < this.match.length; ++i) {
            mismatch = Math.max(mismatch, this.match[i].getMismatch());
        }
        if (mismatch == ObjectMatch.OKAY.getMismatch()) {
            return ObjectMatch.OKAY;
        }
        if (mismatch == ObjectMatch.SIMILAR.getMismatch()) {
            return ObjectMatch.SIMILAR;
        }
        if (mismatch == ObjectMatch.ROUGHLY_SIMILAR.getMismatch()) {
            return ObjectMatch.ROUGHLY_SIMILAR;
        }
        return new ObjectMatch(mismatch);
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public AccessibleObject getAccessibleObject() {
        return this.accessibleObject;
    }
}

