/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.velocity;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.velocity.context.Context;

public class VelocityEmail
extends SimpleEmail {
    private static Log log = LogFactory.getLog(VelocityEmail.class);
    private int wordWrap = 0;
    private String mailServer;
    private String template = null;
    private Context context = null;

    public VelocityEmail() {
    }

    public VelocityEmail(Context context) {
        this();
        this.context = context;
    }

    @Deprecated
    public VelocityEmail setTo(String toName, String toEmail) throws EmailException {
        this.addTo(toEmail, toName);
        return this;
    }

    public VelocityEmail setTemplate(String template) {
        this.template = template;
        return this;
    }

    public VelocityEmail setWordWrap(int wordWrap) {
        this.wordWrap = wordWrap;
        return this;
    }

    public VelocityEmail setContext(Context context) {
        this.context = context;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public void setMailServer(String serverAddress) {
        this.mailServer = serverAddress;
    }

    public String getMailServer() {
        return StringUtils.isNotEmpty((String)this.mailServer) ? this.mailServer : Turbine.getConfiguration().getString("mail.server", "localhost");
    }

    public String send() throws EmailException {
        String body = null;
        try {
            VelocityService velocityService = (VelocityService)TurbineServices.getInstance().getService("VelocityService");
            body = velocityService.handleRequest(this.context, this.template);
        }
        catch (Exception e) {
            throw new EmailException("Could not render velocity template", (Throwable)e);
        }
        if (this.wordWrap > 0) {
            body = WordUtils.wrap((String)body, (int)this.wordWrap, (String)System.getProperty("line.separator"), (boolean)false);
        }
        this.setMsg(body);
        this.setHostName(this.getMailServer());
        return super.send();
    }

    public String toString() {
        try {
            this.send();
        }
        catch (Exception e) {
            log.error((Object)"VelocityEmail error", (Throwable)e);
        }
        return "";
    }
}

