/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobQueue;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.services.schedule.WorkerThread;
import org.apache.turbine.util.TurbineException;

public abstract class AbstractSchedulerService
extends TurbineBaseService
implements ScheduleService {
    protected static Log log = LogFactory.getLog((String)"scheduler");
    protected JobQueue<JobEntry> scheduleQueue = null;
    protected boolean enabled = false;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;

    @Override
    public void init() throws InitializationException {
        try {
            this.setEnabled(this.getConfiguration().getBoolean("enabled", true));
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new MainLoop();
            List<? extends JobEntry> jobs = this.loadJobs();
            this.scheduleQueue.batchLoad(jobs);
            this.restart();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize the scheduler service", e);
        }
    }

    protected abstract List<? extends JobEntry> loadJobs() throws TurbineException;

    @Override
    public void shutdown() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    @Override
    public abstract JobEntry newJob(int var1, int var2, int var3, int var4, int var5, String var6) throws TurbineException;

    @Override
    public abstract JobEntry getJob(int var1) throws TurbineException;

    @Override
    public void addJob(JobEntry je) throws TurbineException {
        this.updateJob(je);
    }

    @Override
    public abstract void removeJob(JobEntry var1) throws TurbineException;

    @Override
    public abstract void updateJob(JobEntry var1) throws TurbineException;

    public List<JobEntry> listJobs() {
        return this.scheduleQueue.list();
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void startScheduler() {
        this.setEnabled(true);
        this.restart();
    }

    @Override
    public synchronized void stopScheduler() {
        log.info((Object)"Stopping job scheduler");
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
        this.enabled = false;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    protected synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.enabled) {
            log.info((Object)"Starting job scheduler");
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this.mainLoop, "SchedulerService");
                this.thread.setDaemon(true);
                this.thread.start();
            } else {
                this.notify();
            }
        }
    }

    protected synchronized JobEntry nextJob() throws TurbineException {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getNext();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String taskName = null;
            try {
                JobEntry je;
                while (AbstractSchedulerService.this.enabled && (je = AbstractSchedulerService.this.nextJob()) != null) {
                    taskName = je.getTask();
                    WorkerThread wt = new WorkerThread(je);
                    Thread helper = new Thread(wt);
                    helper.start();
                }
            }
            catch (Exception e) {
                log.error((Object)("Error running a Scheduled Job: " + taskName), (Throwable)e);
                AbstractSchedulerService.this.enabled = false;
            }
            finally {
                AbstractSchedulerService.this.clearThread();
            }
        }
    }
}

