/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsonrpc;

import java.io.CharArrayWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jabsorb.JSONRPCBridge;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONProcessor {
    private static Log log = LogFactory.getLog(JSONProcessor.class);

    public static Object processCall(CharArrayWriter cdata, JSONRPCBridge json_bridge, HttpServletRequest request) {
        JSONObject json_req = null;
        String json_res = null;
        try {
            json_req = new JSONObject(cdata.toString());
            if (log.isDebugEnabled()) {
                String methodName = json_req.getString("method");
                JSONArray arguments = json_req.getJSONArray("params");
                int object_id = json_req.optInt("objectID");
                StringBuilder sb = new StringBuilder(".doprocessCall(): call ");
                if (object_id != 0) {
                    sb.append("objectID=").append(object_id).append(" ");
                }
                sb.append(methodName).append("(").append(arguments).append(")");
                log.debug((Object)sb.toString());
            }
            json_res = json_bridge.call(new Object[]{request}, json_req);
        }
        catch (JSONException e) {
            log.error((Object)(".processCall(): can't parse call: " + cdata), (Throwable)e);
            json_res = "couldn't parse request arguments";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(".processCall():  returns " + json_res.toString()));
        }
        return json_res;
    }
}

