/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.jsonrpc.JsonRpcService;
import org.apache.turbine.util.RunData;
import org.jabsorb.JSONRPCBridge;

public class JSONScreen
extends RawScreen {
    protected static final String JSONRPC_CONTENT_TYPE = "application/json;charset=utf-8";
    protected static final int BUFFER_SIZE = 4096;
    @TurbineService
    protected JsonRpcService jsonRpcService;

    @Override
    protected String getContentType(PipelineData pipelineData) {
        return JSONRPC_CONTENT_TYPE;
    }

    @Override
    protected void doOutput(PipelineData pipelineData) throws Exception {
        int ret;
        RunData data = this.getRunData(pipelineData);
        data.declareDirectResponse();
        HttpServletRequest request = data.getRequest();
        String charset = "UTF-8";
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        CharArrayWriter cdata = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((ret = in.read(buf, 0, 4096)) != -1) {
            cdata.write(buf, 0, ret);
        }
        JSONRPCBridge json_bridge = this.jsonRpcService.getBridge(data.getSession());
        Object json_res = this.jsonRpcService.processCall(cdata, json_bridge, request);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)data.getResponse().getOutputStream(), charset));
        out.print(json_res.toString());
        out.flush();
        out.close();
    }
}

