/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.pool;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.factory.FactoryException;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.pool.ArrayCtorRecyclable;
import org.apache.fulcrum.pool.BoundedBuffer;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;
import org.apache.fulcrum.pool.Recyclable;

public class DefaultPoolService
extends AbstractLogEnabled
implements PoolService,
Serviceable,
Disposable,
Initializable,
Configurable {
    public static final String POOL_CAPACITY = "capacity";
    private int poolCapacity = 128;
    private HashMap poolRepository = new HashMap();
    private Map capacityMap;
    private FactoryService factoryService;
    private ServiceManager manager;

    public Object getInstance(String className) throws PoolException {
        try {
            Object instance = this.pollInstance(className, null, null);
            return instance == null ? this.getFactory().getInstance(className) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(String className, ClassLoader loader) throws PoolException {
        try {
            Object instance = this.pollInstance(className, null, null);
            return instance == null ? this.getFactory().getInstance(className, loader) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(String className, Object[] params, String[] signature) throws PoolException {
        try {
            Object instance = this.pollInstance(className, params, signature);
            return instance == null ? this.getFactory().getInstance(className, params, signature) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws PoolException {
        try {
            Object instance = this.pollInstance(className, params, signature);
            return instance == null ? this.getFactory().getInstance(className, loader, params, signature) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public boolean isLoaderSupported(String className) throws FactoryException {
        return this.getFactory().isLoaderSupported(className);
    }

    public Object getInstance(Class clazz) throws PoolException {
        try {
            Object instance = this.pollInstance(clazz.getName(), null, null);
            return instance == null ? this.factoryService.getInstance(clazz) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public Object getInstance(Class clazz, Object[] params, String[] signature) throws PoolException {
        try {
            Object instance = this.pollInstance(clazz.getName(), params, signature);
            return instance == null ? this.getFactory().getInstance(clazz.toString(), params, signature) : instance;
        }
        catch (FactoryException fe) {
            throw new PoolException((Exception)((Object)fe));
        }
    }

    public boolean putInstance(Object instance) {
        if (instance != null) {
            HashMap repository = this.poolRepository;
            String className = instance.getClass().getName();
            PoolBuffer pool = (PoolBuffer)repository.get(className);
            if (pool == null) {
                pool = new PoolBuffer(this.getCapacity(className));
                repository = (HashMap)repository.clone();
                repository.put(className, pool);
                this.poolRepository = repository;
                if (instance instanceof ArrayCtorRecyclable) {
                    pool.setArrayCtorRecyclable(true);
                }
            }
            return pool.offer(instance);
        }
        return false;
    }

    public int getCapacity(String className) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        if (pool == null) {
            Integer cap;
            int capacity = this.poolCapacity;
            if (this.capacityMap != null && (cap = (Integer)this.capacityMap.get(className)) != null) {
                capacity = cap;
            }
            return capacity;
        }
        return pool.capacity();
    }

    public void setCapacity(String className, int capacity) {
        HashMap<String, PoolBuffer> repository = this.poolRepository;
        repository = repository != null ? (HashMap)repository.clone() : new HashMap<String, PoolBuffer>();
        repository.put(className, new PoolBuffer(capacity));
        this.poolRepository = repository;
    }

    public int getSize(String className) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        return pool != null ? pool.size() : 0;
    }

    public void clearPool(String className) {
        HashMap repository = this.poolRepository;
        if (repository.get(className) != null) {
            repository = (HashMap)repository.clone();
            repository.remove(className);
            this.poolRepository = repository;
        }
    }

    public void clearPool() {
        this.poolRepository = new HashMap();
    }

    private Object pollInstance(String className, Object[] params, String[] signature) throws PoolException {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        return pool != null ? pool.poll(params, signature) : null;
    }

    protected FactoryService getFactory() {
        return this.factoryService;
    }

    public void configure(Configuration conf) {
        Configuration capacities = conf.getChild(POOL_CAPACITY, false);
        if (capacities != null) {
            Configuration defaultConf = capacities.getChild("default");
            int capacity = defaultConf.getValueAsInteger(128);
            if (capacity <= 0) {
                throw new IllegalArgumentException("Capacity must be >0");
            }
            this.poolCapacity = capacity;
            Configuration[] nameVal = capacities.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                if ("default".equals(key)) continue;
                capacity = nameVal[i].getValueAsInteger(this.poolCapacity);
                if (capacity < 0) {
                    capacity = this.poolCapacity;
                }
                if (this.capacityMap == null) {
                    this.capacityMap = new HashMap();
                }
                this.capacityMap.put(key, new Integer(capacity));
            }
        }
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        try {
            this.factoryService = (FactoryService)this.manager.lookup(FactoryService.ROLE);
        }
        catch (Exception e) {
            throw new Exception("DefaultPoolService.initialize: Failed to get a Factory object", e);
        }
    }

    public void dispose() {
        if (this.factoryService != null) {
            this.manager.release((Object)this.factoryService);
        }
        this.factoryService = null;
        this.manager = null;
    }

    private class PoolBuffer {
        private BoundedBuffer pool;
        private boolean arrayCtorRecyclable;
        private ArrayList recyclers;

        public PoolBuffer(int capacity) {
            this.pool = new BoundedBuffer(capacity);
        }

        public void setArrayCtorRecyclable(boolean isArrayCtor) {
            this.arrayCtorRecyclable = isArrayCtor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(Object[] params, String[] signature) throws PoolException {
            Object instance;
            block12: {
                instance = this.pool.poll();
                if (instance != null) {
                    if (this.arrayCtorRecyclable) {
                        ((ArrayCtorRecyclable)instance).recycle(params);
                    } else if (instance instanceof Recyclable) {
                        try {
                            if (signature != null && signature.length > 0) {
                                Method recycle = this.getRecycle(signature);
                                if (recycle == null) {
                                    PoolBuffer poolBuffer = this;
                                    synchronized (poolBuffer) {
                                        recycle = this.getRecycle(signature);
                                        if (recycle == null) {
                                            Class<?> clazz = instance.getClass();
                                            recycle = clazz.getMethod("recycle", DefaultPoolService.this.getFactory().getSignature(clazz, params, signature));
                                            ArrayList cache = this.recyclers != null ? (ArrayList)this.recyclers.clone() : new ArrayList();
                                            cache.add(new Recycler(recycle, signature));
                                            this.recyclers = cache;
                                        }
                                    }
                                }
                                recycle.invoke(instance, params);
                                break block12;
                            }
                            ((Recyclable)instance).recycle();
                        }
                        catch (Exception x) {
                            throw new PoolException("Recycling failed for " + instance.getClass().getName(), x);
                        }
                    }
                }
            }
            return instance;
        }

        public boolean offer(Object instance) {
            if (instance instanceof Recyclable) {
                try {
                    ((Recyclable)instance).dispose();
                }
                catch (Exception x) {
                    return false;
                }
            }
            return this.pool.offer(instance);
        }

        public int capacity() {
            return this.pool.capacity();
        }

        public int size() {
            return this.pool.size();
        }

        private Method getRecycle(String[] signature) {
            ArrayList cache = this.recyclers;
            if (cache != null) {
                Iterator i = cache.iterator();
                while (i.hasNext()) {
                    Method recycle = ((Recycler)i.next()).match(signature);
                    if (recycle == null) continue;
                    return recycle;
                }
            }
            return null;
        }

        private class Recycler {
            private final Method recycle;
            private final String[] signature;

            public Recycler(Method rec, String[] sign) {
                this.recycle = rec;
                this.signature = sign != null && sign.length > 0 ? sign : null;
            }

            public Method match(String[] sign) {
                if (sign != null && sign.length > 0) {
                    if (this.signature != null && sign.length == this.signature.length) {
                        for (int i = 0; i < this.signature.length; ++i) {
                            if (this.signature[i].equals(sign[i])) continue;
                            return null;
                        }
                        return this.recycle;
                    }
                    return null;
                }
                if (this.signature == null) {
                    return this.recycle;
                }
                return null;
            }
        }
    }
}

