/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;

public final class DaemonThreadFactory
implements ThreadFactory {
    @Nonnull
    private final String threadName;

    public DaemonThreadFactory(@Nonnull String threadName) {
        Check.notNull((Object)threadName, (String)"threadName");
        Check.notEmpty((CharSequence)threadName.trim(), (String)"threadName");
        this.threadName = threadName;
    }

    @Override
    public Thread newThread(@Nonnull Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(this.threadName);
        thread.setDaemon(true);
        return thread;
    }
}

