/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.Identifiable;

@Immutable
public final class BrowserType
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 2643535063309729806L;
    @Nonnegative
    private final int id;
    @Nonnull
    private final String name;

    public BrowserType(@Nonnegative int id, @Nonnull String name) {
        Check.notNegative((int)id, (String)"id");
        Check.notNull((Object)name, (String)"name");
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowserType other = (BrowserType)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BrowserType [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private int id = Integer.MIN_VALUE;
        private String name;

        @Nonnull
        public BrowserType build() {
            return new BrowserType(this.id, this.name);
        }

        @Nonnull
        public Builder setId(@Nonnegative int id) {
            Check.notNegative((int)id, (String)"id");
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnull String id) {
            Check.notNull((Object)id, (String)"id");
            this.setId(Integer.parseInt(id.trim()));
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            Check.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }
    }
}

