/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.factory.Factory;
import org.apache.fulcrum.factory.FactoryException;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.factory.utils.ObjectInputStreamForContext;

public class DefaultFactoryService
extends AbstractLogEnabled
implements FactoryService,
Configurable,
Initializable,
Disposable {
    protected boolean initialized = false;
    private static final String CLASS_LOADER = "classloader";
    private static final String OBJECT_FACTORY = "object-factory";
    protected static final String DEFAULT_FACTORY = "default";
    private static HashMap<String, Class<?>> primitiveClasses;
    private String[] loaderNames;
    private ArrayList<ClassLoader> classLoaders;
    private ConcurrentHashMap<String, Factory<?>> objectFactories;
    private ConcurrentHashMap<String, String> objectFactoryClasses;

    public DefaultFactoryService() {
        primitiveClasses = new HashMap(8);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.classLoaders = new ArrayList();
        this.objectFactories = new ConcurrentHashMap();
        this.objectFactoryClasses = new ConcurrentHashMap();
    }

    protected static Class<?> getPrimitiveClass(String type) {
        return primitiveClasses.get(type);
    }

    @Override
    public <T> T getInstance(String className) throws FactoryException {
        if (className == null) {
            throw new FactoryException("Missing String className");
        }
        Factory<T> factory = this.getFactory(className);
        if (factory == null) {
            Class<T> clazz;
            try {
                clazz = this.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                throw new FactoryException("Instantiation failed for class " + className, x);
            }
            return this.getInstance(clazz);
        }
        return factory.getInstance();
    }

    @Override
    public <T> T getInstance(String className, ClassLoader loader) throws FactoryException {
        Factory<T> factory = this.getFactory(className);
        if (factory == null) {
            if (loader != null) {
                Class<T> clazz;
                try {
                    clazz = this.loadClass(className, loader);
                }
                catch (ClassNotFoundException x) {
                    throw new FactoryException("Instantiation failed for class " + className, x);
                }
                return this.getInstance(clazz);
            }
            return this.getInstance(className);
        }
        return factory.getInstance(loader);
    }

    @Override
    public <T> T getInstance(String className, Object[] params, String[] signature) throws FactoryException {
        Factory<T> factory = this.getFactory(className);
        if (factory == null) {
            Class<T> clazz;
            try {
                clazz = this.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                throw new FactoryException("Instantiation failed for class " + className, x);
            }
            return this.getInstance(clazz, params, signature);
        }
        return factory.getInstance(params, signature);
    }

    @Override
    public <T> T getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws FactoryException {
        Factory<T> factory = this.getFactory(className);
        if (factory == null) {
            if (loader != null) {
                Class<T> clazz;
                try {
                    clazz = this.loadClass(className, loader);
                }
                catch (ClassNotFoundException x) {
                    throw new FactoryException("Instantiation failed for class " + className, x);
                }
                return this.getInstance(clazz, params, signature);
            }
            return this.getInstance(className, params, signature);
        }
        return factory.getInstance(loader, params, signature);
    }

    @Override
    public boolean isLoaderSupported(String className) throws FactoryException {
        Factory factory = this.getFactory(className);
        return factory != null ? factory.isLoaderSupported() : true;
    }

    @Override
    public <T> T getInstance(Class<T> clazz) throws FactoryException {
        try {
            return clazz.newInstance();
        }
        catch (Exception x) {
            throw new FactoryException("Instantiation failed for " + clazz.getName(), x);
        }
    }

    protected <T> T getInstance(Class<T> clazz, Object[] params, String[] signature) throws FactoryException {
        try {
            Class<?>[] sign = this.getSignature(clazz, params, signature);
            return clazz.getConstructor(sign).newInstance(params);
        }
        catch (Exception x) {
            throw new FactoryException("Instantiation failed for " + clazz.getName(), x);
        }
    }

    @Override
    public Class<?>[] getSignature(Class<?> clazz, Object[] params, String[] signature) throws ClassNotFoundException {
        if (signature != null) {
            ClassLoader loader = clazz.getClassLoader();
            Class[] sign = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                sign[i] = DefaultFactoryService.getPrimitiveClass(signature[i]);
                if (sign[i] != null) continue;
                if (loader != null) {
                    sign[i] = loader.loadClass(signature[i]);
                    ClassLoader tempLoader = sign[i].getClassLoader();
                    if (params[i] == null || tempLoader == null || tempLoader.equals(params[i].getClass().getClassLoader())) continue;
                    params[i] = this.switchObjectContext(params[i], loader);
                    continue;
                }
                sign[i] = this.loadClass(signature[i]);
            }
            return sign;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object switchObjectContext(Object object, ClassLoader loader) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(object);
            out.flush();
        }
        catch (IOException x) {
            return object;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStreamForContext in = null;
        try {
            in = new ObjectInputStreamForContext(bin, loader);
            Object object2 = in.readObject();
            return object2;
        }
        catch (Exception x) {
            Object object3 = object;
            return object3;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> clazz = loader != null ? loader.loadClass(className) : Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException x) {
            for (ClassLoader l : this.classLoaders) {
                try {
                    return l.loadClass(className);
                }
                catch (ClassNotFoundException xx) {
                }
            }
            throw x;
        }
    }

    protected <T> Class<T> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            return loader.loadClass(className);
        }
        return this.loadClass(className);
    }

    protected <T> Factory<T> getFactory(String className) throws FactoryException {
        Factory factory = this.objectFactories.get(className);
        if (factory == null) {
            factory = this.objectFactories.get(DEFAULT_FACTORY);
        }
        if (factory == null) {
            String factoryClass = this.objectFactoryClasses.get(className);
            if (factoryClass == null) {
                factoryClass = this.objectFactoryClasses.get(DEFAULT_FACTORY);
            }
            if (factoryClass == null) {
                return null;
            }
            try {
                factory = (Factory)this.getInstance(factoryClass);
                factory.init(className);
            }
            catch (ClassCastException x) {
                throw new FactoryException("Incorrect factory " + factoryClass + " for class " + className, x);
            }
            Factory _factory = this.objectFactories.putIfAbsent(className, factory);
            if (_factory != null) {
                factory = _factory;
            }
        }
        return factory;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration factories;
        Configuration[] loaders = conf.getChildren(CLASS_LOADER);
        if (loaders != null) {
            this.loaderNames = new String[loaders.length];
            for (int i = 0; i < loaders.length; ++i) {
                this.loaderNames[i] = loaders[i].getValue();
            }
        }
        if ((factories = conf.getChild(OBJECT_FACTORY, false)) != null) {
            Configuration[] nameVal = factories.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                String factory = nameVal[i].getValue();
                this.objectFactoryClasses.put(key, factory);
            }
        }
    }

    public void initialize() throws Exception {
        if (this.loaderNames != null) {
            for (int i = 0; i < this.loaderNames.length; ++i) {
                try {
                    ClassLoader loader = (ClassLoader)this.loadClass(this.loaderNames[i]).newInstance();
                    this.classLoaders.add(loader);
                    continue;
                }
                catch (Exception x) {
                    throw new Exception("No such class loader '" + this.loaderNames[i] + "' for DefaultFactoryService", x);
                }
            }
            this.loaderNames = null;
        }
    }

    public void dispose() {
        this.objectFactories.clear();
        this.objectFactoryClasses.clear();
        this.classLoaders.clear();
    }
}

