/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.html;

import java.util.Enumeration;
import org.apache.ecs.Element;
import org.apache.ecs.HtmlColor;
import org.apache.ecs.KeyEvents;
import org.apache.ecs.MouseEvents;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.Printable;
import org.apache.ecs.html.A;
import org.apache.ecs.html.IMG;

public class TD
extends MultiPartElement
implements Printable,
MouseEvents,
KeyEvents {
    public TD() {
        this.setElementType("td");
    }

    public TD(String string) {
        this.setElementType("td");
        this.addElement(string);
    }

    public TD(Element element) {
        this.setElementType("td");
        this.addElement(element);
    }

    public TD(boolean bl) {
        this.setElementType("td");
        this.setNeedClosingTag(bl);
    }

    public TD addElement(String string) {
        this.addElementToRegistry(string);
        return this;
    }

    public TD addElement(String string, String string2) {
        this.addElementToRegistry(string, string2);
        return this;
    }

    public TD addElement(String string, Element element) {
        this.addElementToRegistry(string, element);
        return this;
    }

    public TD addElement(Element element) {
        this.addElementToRegistry(element);
        return this;
    }

    public boolean getNeedLineBreak() {
        Enumeration enumeration = this.elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ++n2;
            Object e = enumeration.nextElement();
            if (!(e instanceof IMG) && !(e instanceof A)) continue;
            ++n;
        }
        return n != n2;
    }

    public TD removeElement(String string) {
        this.removeElementFromRegistry(string);
        return this;
    }

    public TD setAbbr(String string) {
        this.addAttribute("abbr", string);
        return this;
    }

    public TD setAlign(String string) {
        this.addAttribute("align", string);
        return this;
    }

    public TD setAxes(String string) {
        this.addAttribute("axes", string);
        return this;
    }

    public TD setAxis(String string) {
        this.addAttribute("axis", string);
        return this;
    }

    public TD setBackground(String string) {
        this.addAttribute("background", string);
        return this;
    }

    public TD setBgColor(String string) {
        this.addAttribute("bgcolor", HtmlColor.convertColor(string));
        return this;
    }

    public TD setChar(String string) {
        this.addAttribute("char", string);
        return this;
    }

    public TD setCharOff(int n) {
        this.addAttribute("charoff", Integer.toString(n));
        return this;
    }

    public TD setCharOff(String string) {
        this.addAttribute("charoff", string);
        return this;
    }

    public TD setColSpan(int n) {
        this.addAttribute("colspan", Integer.toString(n));
        return this;
    }

    public TD setColSpan(String string) {
        this.addAttribute("colspan", string);
        return this;
    }

    public TD setHeight(int n) {
        this.addAttribute("height", Integer.toString(n));
        return this;
    }

    public TD setHeight(String string) {
        this.addAttribute("height", string);
        return this;
    }

    public TD setNoWrap(boolean bl) {
        if (bl) {
            this.addAttribute("nowrap", "ECS_NO_ATTRIBUTE_VALUE");
        } else {
            this.removeAttribute("nowrap");
        }
        return this;
    }

    public void setOnClick(String string) {
        this.addAttribute("onClick", string);
    }

    public void setOnDblClick(String string) {
        this.addAttribute("onDblClick", string);
    }

    public void setOnKeyDown(String string) {
        this.addAttribute("onKeyDown", string);
    }

    public void setOnKeyPress(String string) {
        this.addAttribute("onKeyPress", string);
    }

    public void setOnKeyUp(String string) {
        this.addAttribute("onKeyUp", string);
    }

    public void setOnMouseDown(String string) {
        this.addAttribute("onMouseDown", string);
    }

    public void setOnMouseMove(String string) {
        this.addAttribute("onMouseMove", string);
    }

    public void setOnMouseOut(String string) {
        this.addAttribute("onMouseOut", string);
    }

    public void setOnMouseOver(String string) {
        this.addAttribute("onMouseOver", string);
    }

    public void setOnMouseUp(String string) {
        this.addAttribute("onMouseUp", string);
    }

    public TD setRowSpan(int n) {
        this.addAttribute("rowspan", Integer.toString(n));
        return this;
    }

    public TD setRowSpan(String string) {
        this.addAttribute("rowspan", string);
        return this;
    }

    public TD setVAlign(String string) {
        this.addAttribute("valign", string);
        return this;
    }

    public TD setWidth(int n) {
        this.addAttribute("width", Integer.toString(n));
        return this;
    }

    public TD setWidth(String string) {
        this.addAttribute("width", string);
        return this;
    }
}

