package org.apache.turbine;


/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


import org.apache.turbine.test.BaseTestCase;
import org.apache.turbine.util.TurbineConfig;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Can we call "destroy" unconditionally on our Turbine Servlet, even if
 * it hasn't configured?
 *
 * @author <a href="mailto:hps@intermeta.de">Henning P. Schmiedehausen</a>
 * @version $Id: DestroyTest.java 1606111 2014-06-27 14:46:47Z gk $
 */
public class DestroyTest
    extends BaseTestCase
{
    private static TurbineConfig tc = null;

    
    @BeforeClass
    public static void init() throws Exception {
        tc = new TurbineConfig(".", "/conf/test/TemplateService.properties");
    }
    @Test
    public void testDestroy()
        throws Exception
    {
        Turbine t = new Turbine();
        t.destroy();
    }
    @Test
    public void testInitAndDestroy()
        throws Exception
    {
        tc.initialize();
        tc.dispose();
    }

    @AfterClass
    public static void destroy()
        throws Exception
    {
        // should be already dispoesd
        //tc.dispose();
    }
}
