/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.avalon;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.Torque;
import org.apache.torque.TorqueInstance;

public class TorqueComponent
extends TorqueInstance
implements org.apache.torque.avalon.Torque,
LogEnabled,
Configurable,
Initializable,
Contextualizable,
Disposable,
ThreadSafe {
    private String appRoot = null;
    private Logger logger = null;
    private String configFile = null;

    public void enableLogging(Logger aLogger) {
        this.logger = aLogger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.getLogger().debug("configure(" + configuration + ")");
        String configurationFile = configuration.getChild("configfile").getValue();
        if (StringUtils.isNotEmpty((String)this.appRoot)) {
            if (configurationFile.startsWith("/")) {
                configurationFile = configurationFile.substring(1);
                this.getLogger().debug("Config File changes to " + configurationFile);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.appRoot);
            sb.append(File.separator);
            sb.append(configurationFile);
            configurationFile = sb.toString();
        }
        this.getLogger().debug("Config File is " + configurationFile);
        this.configFile = configurationFile;
    }

    public void contextualize(Context context) throws ContextException {
        try {
            this.appRoot = ((File)context.get((Object)"urn:avalon:home")).getAbsolutePath();
        }
        catch (ContextException ce) {
            this.appRoot = null;
        }
        if (this.appRoot == null) {
            this.appRoot = (String)context.get((Object)"componentAppRoot");
        }
        if (StringUtils.isNotEmpty((String)this.appRoot) && this.appRoot.endsWith("/")) {
            this.appRoot = this.appRoot.substring(0, this.appRoot.length() - 1);
            this.getLogger().debug("Application Root changed to " + this.appRoot);
        }
    }

    public void initialize() throws Exception {
        this.getLogger().debug("initialize()");
        TorqueInstance instance = Torque.getInstance();
        Map mapBuilders = instance.getMapBuilders();
        if (mapBuilders != null) {
            Iterator i = mapBuilders.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                this.registerMapBuilder(className);
            }
        }
        Torque.setInstance(this);
        this.init(this.configFile);
    }

    public void dispose() {
        this.getLogger().debug("dispose()");
        try {
            this.shutdown();
        }
        catch (Exception e) {
            this.getLogger().error("Error while stopping Torque", (Throwable)e);
        }
    }
}

