/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.util.ServletUtils;

public class TurbineServletService
extends TurbineBaseService
implements ServletService {
    private static Log log = LogFactory.getLog((Class)TurbineServletService.class);
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;

    public void init() {
        this.servletConfig = Turbine.getTurbineServletConfig();
        try {
            this.servletContext = this.servletConfig.getServletContext();
            log.debug((Object)"Initializing with ServletConfig");
        }
        catch (Exception e) {
            log.error((Object)"Cannot initialize TurbineServletService.", (Throwable)e);
        }
        this.setInit(true);
    }

    public void init(ServletConfig servletConfig) {
        this.init();
    }

    public URL getResource(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        URL url = null;
        try {
            url = this.getServletContext().getResource(uri);
            if (url != null && url.toString().startsWith("classloader:")) {
                url = new URL("file:" + url.toString().substring(12));
            } else if (url == null) {
                url = new URL("file:" + this.getServletContext().getRealPath(uri));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public InputStream getResourceAsStream(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        InputStream is = null;
        is = this.servletContext.getResourceAsStream(uri);
        return is;
    }

    public String getRealPath(String uri) {
        if (this.getServletContext() == null || uri == null) {
            return null;
        }
        return this.getServletContext().getRealPath(uri);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServerScheme() {
        return Turbine.getServerScheme();
    }

    public String getServerName() {
        return Turbine.getServerName();
    }

    public String getServerPort() {
        return Turbine.getServerPort();
    }

    public String getContextPath() {
        return Turbine.getContextPath();
    }

    public String expandRelative(String path) {
        return ServletUtils.expandRelative(this.getServletConfig(), path);
    }
}

