/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.factory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl;
import org.apache.fulcrum.yaafi.framework.util.InputStreamLocator;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class ServiceContainerConfiguration {
    private String serviceContainerClazzName = "org.apache.fulcrum.yaafi.framework.container.ServiceContainerImpl";
    private String componentRolesLocation = "/componentRoles.xml";
    private String isComponentRolesEncrypted = "false";
    private String componentConfigurationLocation = "/componentConfiguration.xml";
    private String isComponentConfigurationEncrypted = "false";
    private String parametersLocation = "/parameters.properties";
    private String isParametersEncrypted = "false";
    private DefaultContext context;
    private Logger logger = new ConsoleLogger();
    private String applicationRootDir;
    private String tempRootDir;
    private ClassLoader componentClassLoader;
    private String containerFlavour = "yaafi";
    private Configuration containerConfiguration;

    public ServiceContainerConfiguration() {
        this.context = new DefaultContext();
        this.applicationRootDir = new File("").getAbsolutePath();
        this.tempRootDir = System.getProperty("java.io.tmpdir", ".");
        this.componentClassLoader = this.getClass().getClassLoader();
    }

    public void addToContext(String name, Object value) {
        Validate.notEmpty(name, "name");
        Validate.notNull(value, "value");
        this.getContext().put((Object)name, value);
    }

    public void addToContext(Hashtable hashtable) {
        Validate.notNull(hashtable, "hashtable");
        String name = null;
        Object value = null;
        Enumeration keys = hashtable.keys();
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            value = hashtable.get(name);
            this.addToContext(name, value);
        }
    }

    public Context createFinalContext() {
        this.addToContext("urn:avalon:home", this.getApplicationRootDir());
        this.addToContext("urn:avalon:temp", this.getTempRootDir());
        this.addToContext("urn:avalon:name", "fulcrum-yaafi");
        this.addToContext("urn:avalon:partition", "root");
        this.addToContext("urn:avalon:classloader", this.getComponentClassLoader());
        return this.getContext();
    }

    public Configuration createFinalConfiguration() {
        DefaultConfiguration result = null;
        if (this.getContainerConfiguration() != null) {
            return this.getContainerConfiguration();
        }
        result = new DefaultConfiguration("fulcrum-yaafi");
        DefaultConfiguration containerFlavourConfig = new DefaultConfiguration("containerFlavour");
        containerFlavourConfig.setValue(this.getContainerFlavour());
        result.addChild((Configuration)containerFlavourConfig);
        DefaultConfiguration containerClazzNameConfig = new DefaultConfiguration("containerClazzName");
        containerClazzNameConfig.setValue(this.getServiceContainerClazzName());
        result.addChild((Configuration)containerClazzNameConfig);
        DefaultConfiguration componentRolesConfig = new DefaultConfiguration("componentRoles");
        DefaultConfiguration componentRolesLocation = new DefaultConfiguration("location");
        componentRolesLocation.setValue(this.getComponentRolesLocation());
        DefaultConfiguration componentRolesIsEncrypted = new DefaultConfiguration("isEncrypted");
        componentRolesIsEncrypted.setValue(this.isComponentRolesEncrypted());
        componentRolesConfig.addChild((Configuration)componentRolesLocation);
        componentRolesConfig.addChild((Configuration)componentRolesIsEncrypted);
        result.addChild((Configuration)componentRolesConfig);
        DefaultConfiguration componentConfigurationConfig = new DefaultConfiguration("componentConfiguration");
        DefaultConfiguration componentConfigurationLocation = new DefaultConfiguration("location");
        componentConfigurationLocation.setValue(this.getComponentConfigurationLocation());
        DefaultConfiguration componentConfigurationIsEncrypted = new DefaultConfiguration("isEncrypted");
        componentConfigurationIsEncrypted.setValue(this.isComponentConfigurationEncrypted());
        componentConfigurationConfig.addChild((Configuration)componentConfigurationLocation);
        componentConfigurationConfig.addChild((Configuration)componentConfigurationIsEncrypted);
        result.addChild((Configuration)componentConfigurationConfig);
        DefaultConfiguration parameterConfigurationConfig = new DefaultConfiguration("parameters");
        DefaultConfiguration parameterConfigurationLocation = new DefaultConfiguration("location");
        parameterConfigurationLocation.setValue(this.getParametersLocation());
        DefaultConfiguration parameterConfigurationIsEncrypted = new DefaultConfiguration("isEncrypted");
        parameterConfigurationIsEncrypted.setValue(this.isParametersEncrypted());
        parameterConfigurationConfig.addChild((Configuration)parameterConfigurationLocation);
        parameterConfigurationConfig.addChild((Configuration)parameterConfigurationIsEncrypted);
        result.addChild((Configuration)parameterConfigurationConfig);
        return result;
    }

    private String getServiceContainerClazzName() {
        return this.serviceContainerClazzName;
    }

    private String getComponentConfigurationLocation() {
        return this.componentConfigurationLocation;
    }

    public void setComponentConfigurationLocation(String componentConfigurationLocation) {
        Validate.notNull(componentConfigurationLocation, "componentConfigurationLocation");
        this.componentConfigurationLocation = componentConfigurationLocation;
    }

    private String getComponentRolesLocation() {
        return this.componentRolesLocation;
    }

    public void setComponentRolesLocation(String componentRolesLocation) {
        this.componentRolesLocation = componentRolesLocation;
    }

    private DefaultContext getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context instanceof DefaultContext ? (DefaultContext)context : new DefaultContext(context);
    }

    private String isComponentConfigurationEncrypted() {
        return this.isComponentConfigurationEncrypted;
    }

    public void setComponentConfigurationEncrypted(String isComponentConfigurationEncrypted) {
        this.isComponentConfigurationEncrypted = isComponentConfigurationEncrypted;
    }

    private String isComponentRolesEncrypted() {
        return this.isComponentRolesEncrypted;
    }

    public void setComponentRolesEncrypted(String isComponentRolesEncrypted) {
        this.isComponentRolesEncrypted = isComponentRolesEncrypted;
    }

    private String isParametersEncrypted() {
        return this.isParametersEncrypted;
    }

    public void setParametersEncrypted(String isParametersEncrypted) {
        Validate.notEmpty(isParametersEncrypted, "isParametersEncrypted");
        this.isParametersEncrypted = isParametersEncrypted;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private String getParametersLocation() {
        return this.parametersLocation;
    }

    public void setParametersLocation(String parametersLocation) {
        this.parametersLocation = parametersLocation;
    }

    private File getApplicationRootDir() {
        return new File(this.applicationRootDir);
    }

    public void setApplicationRootDir(String applicationRootDir) {
        Validate.notNull(applicationRootDir, "applicationRootDir");
        this.applicationRootDir = applicationRootDir.equals(".") ? new File("").getAbsolutePath() : new File(applicationRootDir).getAbsolutePath();
    }

    private File getTempRootDir() {
        return ServiceContainerConfiguration.makeAbsoluteFile(this.getApplicationRootDir(), this.tempRootDir);
    }

    public void setTempRootDir(String tempRootDir) {
        Validate.notNull(tempRootDir, "tempRootDir");
        this.tempRootDir = tempRootDir;
    }

    private ClassLoader getComponentClassLoader() {
        return this.componentClassLoader;
    }

    public void setComponentClassLoader(ClassLoader componentClassLoader) {
        Validate.notNull(componentClassLoader, "componentClassLoader");
        this.componentClassLoader = componentClassLoader;
    }

    private String getContainerFlavour() {
        return this.containerFlavour;
    }

    public void setContainerFlavour(String containerFlavour) {
        this.containerFlavour = containerFlavour;
    }

    private Configuration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public void setContainerConfiguration(Configuration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
    }

    public void loadContainerConfiguration(String location) throws IOException {
        this.loadContainerConfiguration(location, "false");
    }

    public void loadContainerConfiguration(String location, String isEncrypted) throws IOException {
        InputStream is;
        Configuration result = null;
        InputStreamLocator locator = new InputStreamLocator(this.getApplicationRootDir(), this.getLogger());
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        InputStream cis = is = locator.locate(location);
        if (is != null) {
            try {
                if (isEncrypted.equalsIgnoreCase("true")) {
                    cis = CryptoStreamFactoryImpl.getInstance().getInputStream(is);
                    result = builder.build(cis);
                    cis.close();
                }
                if (isEncrypted.equalsIgnoreCase("auto")) {
                    cis = CryptoStreamFactoryImpl.getInstance().getSmartInputStream(is);
                    result = builder.build(cis);
                    cis.close();
                } else {
                    result = builder.build(is);
                    is.close();
                }
                this.setContainerConfiguration(result);
            }
            catch (Exception e) {
                String msg = "Unable to parse the following file : " + location;
                this.getLogger().error(msg, (Throwable)e);
                throw new IOException(msg);
            }
        } else {
            String msg = "Unable to locate the containerConfiguration file : " + location;
            this.getLogger().error(msg);
            throw new IOException(msg);
        }
    }

    private static File makeAbsoluteFile(File baseDir, String fileName) {
        File result = new File(fileName);
        if (!result.isAbsolute()) {
            result = new File(baseDir, fileName);
        }
        return result;
    }
}

