/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.container;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl;
import org.apache.fulcrum.yaafi.framework.component.AvalonServiceComponentImpl;
import org.apache.fulcrum.yaafi.framework.component.ServiceComponent;
import org.apache.fulcrum.yaafi.framework.configuration.ComponentConfigurationPropertiesResolver;
import org.apache.fulcrum.yaafi.framework.container.ServiceConstants;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.context.AvalonToYaafiContextMapper;
import org.apache.fulcrum.yaafi.framework.context.YaafiToAvalonContextMapper;
import org.apache.fulcrum.yaafi.framework.role.RoleConfigurationParser;
import org.apache.fulcrum.yaafi.framework.role.RoleConfigurationParserImpl;
import org.apache.fulcrum.yaafi.framework.role.RoleEntry;
import org.apache.fulcrum.yaafi.framework.util.ConfigurationUtil;
import org.apache.fulcrum.yaafi.framework.util.InputStreamLocator;
import org.apache.fulcrum.yaafi.framework.util.ReadWriteLock;
import org.apache.fulcrum.yaafi.framework.util.StringUtils;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class ServiceContainerImpl
implements ServiceContainer,
ServiceConstants {
    private static final int RECONFIGURATION_DELAY = 0;
    private String componentRolesLocation = "/componentRoles.xml";
    private String isComponentRolesEncrypted = "false";
    private String componentRolesFlavour = "yaafi";
    private String componentConfigurationLocation = "/componentConfiguration.xml";
    private String isComponentConfigurationEncrypted = "false";
    private String parametersLocation = "/parameters.properties";
    private String isParametersEncrypted = "false";
    private File applicationRootDir;
    private File tempRootDir;
    private Logger logger;
    private ServiceManager parentServiceManager;
    private List serviceList = new ArrayList();
    private HashMap serviceMap = new HashMap();
    private Configuration roleConfiguration;
    private Configuration serviceConfiguration;
    private Context callerContext;
    private Context context;
    private Parameters parameters;
    private boolean isDisposed = false;
    private String containerFlavour = "yaafi";
    private int reconfigurationDelay = 0;
    private boolean hasDynamicProxies;
    private ArrayList defaultInterceptorServiceList;
    private ReadWriteLock readWriteLock;
    private Configuration componentConfigurationPropertiesResolverConfig;
    static /* synthetic */ Class class$org$apache$fulcrum$yaafi$framework$configuration$ComponentConfigurationPropertiesResolverImpl;

    public ServiceContainerImpl() {
        this.applicationRootDir = new File(new File("").getAbsolutePath());
        this.tempRootDir = new File(System.getProperty("java.io.tmpdir", "."));
        this.defaultInterceptorServiceList = new ArrayList();
    }

    public void enableLogging(Logger logger) {
        Validate.notNull(logger, "logger");
        this.logger = logger;
        this.readWriteLock = new ReadWriteLock("urn:yaafi:kernellock", logger);
    }

    public void contextualize(Context context) throws ContextException {
        Validate.notNull(context, "context");
        this.callerContext = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.parentServiceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Validate.notNull(configuration, "configuration");
        this.reconfigurationDelay = configuration.getChild("reconfigurationDelay").getValueAsInteger(0);
        this.hasDynamicProxies = configuration.getChild("hasDynamicProxies").getValueAsBoolean(false);
        this.setContainerFlavour(configuration.getChild("containerFlavour").getValue("yaafi"));
        this.getLogger().debug("Using the following container type : " + this.getContainerFlavour());
        try {
            AvalonToYaafiContextMapper mapper = new AvalonToYaafiContextMapper(this.getTempRootDir(), this.callerContext, this.getClassLoader());
            this.context = mapper.mapFrom(this.callerContext, this.getContainerFlavour());
            this.callerContext = null;
        }
        catch (ContextException e) {
            String msg = "Failed to parse the caller-supplied context";
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg);
        }
        Configuration currComponentRoles = configuration.getChild("componentRoles");
        this.setComponentRolesLocation(currComponentRoles.getChild("location").getValue("/componentRoles.xml"));
        this.setComponentRolesFlavour(currComponentRoles.getChild("containerFlavour").getValue("yaafi"));
        this.setComponentRolesEncrypted(currComponentRoles.getChild("isEncrypted").getValue("false"));
        Configuration currComponentConfiguration = configuration.getChild("componentConfiguration");
        this.setComponentConfigurationLocation(currComponentConfiguration.getChild("location").getValue("/componentConfiguration.xml"));
        this.setComponentConfigurationEncrypted(currComponentConfiguration.getChild("isEncrypted").getValue("false"));
        this.componentConfigurationPropertiesResolverConfig = configuration.getChild("componentConfigurationProperties");
        Configuration currParameters = configuration.getChild("parameters");
        this.setParametersLocation(currParameters.getChild("location").getValue("/parameters.properties"));
        this.setParametersEncrypted(currParameters.getChild("isEncrypted").getValue("false"));
        Configuration currInterceptorList = configuration.getChild("interceptors");
        Configuration[] interceptorConfigList = currInterceptorList.getChildren("interceptor");
        for (int j = 0; j < interceptorConfigList.length; ++j) {
            String interceptorServiceName = interceptorConfigList[j].getValue(null);
            if (StringUtils.isEmpty(interceptorServiceName) || !this.hasDynamicProxies()) continue;
            this.defaultInterceptorServiceList.add(interceptorServiceName);
            this.getLogger().debug("Using the following default interceptor service : " + interceptorServiceName);
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.parameters = parameters;
    }

    public void initialize() throws Exception {
        this.getLogger().debug("YAAFI Service Framework is starting up");
        this.setApplicationRootDir((File)this.getContext().get((Object)"urn:avalon:home"));
        this.setTempRootDir((File)this.getContext().get((Object)"urn:avalon:temp"));
        this.roleConfiguration = this.loadConfiguration(this.componentRolesLocation, this.isComponentRolesEncrypted());
        if (this.roleConfiguration == null) {
            String msg = "Unable to locate the role configuration : " + this.componentRolesLocation;
            this.getLogger().error(msg);
            throw new ConfigurationException(msg);
        }
        this.serviceConfiguration = this.loadConfiguration(this.componentConfigurationLocation, this.isComponentConfigurationEncrypted());
        Properties componentConfigurationProperties = this.loadComponentConfigurationProperties();
        ConfigurationUtil.expand(this.getLogger(), (DefaultConfiguration)this.serviceConfiguration, componentConfigurationProperties);
        if (this.getParameters() == null) {
            this.parameters = this.loadParameters(this.parametersLocation, this.isParametersEncrypted());
        }
        List currServiceList = this.createServiceComponents(this.roleConfiguration, this.getLogger());
        this.setServiceList(currServiceList);
        for (int i = 0; i < this.getServiceList().size(); ++i) {
            ServiceComponent serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            this.getServiceMap().put(serviceComponent.getName(), serviceComponent);
        }
        this.incarnateAll(this.getServiceList());
        this.isDisposed = false;
        this.getLogger().debug("YAAFI Avalon Service Container is up and running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object lock = null;
        if (this.isDisposed) {
            return;
        }
        try {
            lock = this.getWriteLock();
            if (this.getLogger() != null) {
                this.getLogger().debug("Disposing all services");
            }
            this.decommisionAll(this.getServiceList());
            this.disposeAll(this.getServiceList());
            this.getServiceList().clear();
            this.getServiceMap().clear();
            this.componentRolesLocation = null;
            this.componentConfigurationLocation = null;
            this.context = null;
            this.parametersLocation = null;
            this.roleConfiguration = null;
            this.serviceConfiguration = null;
            this.parameters = null;
            this.isDisposed = true;
            if (this.getLogger() != null) {
                this.getLogger().debug("All services are disposed");
            }
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Configuration configuration) throws ConfigurationException {
        Validate.notNull(configuration, "configuration");
        Object lock = null;
        int exceptionCounter = 0;
        ServiceComponent serviceComponent = null;
        this.getLogger().warn("Reconfiguring all services ...");
        try {
            lock = this.getWriteLock();
            this.serviceConfiguration = configuration;
            Properties componentConfigurationProperties = this.loadComponentConfigurationProperties();
            ConfigurationUtil.expand(this.getLogger(), (DefaultConfiguration)this.serviceConfiguration, componentConfigurationProperties);
            for (int i = 0; i < this.getServiceList().size(); ++i) {
                serviceComponent = (ServiceComponent)this.getServiceList().get(i);
                Configuration serviceComponentConfiguraton = this.getServiceConfiguration().getChild(serviceComponent.getShorthand());
                try {
                    serviceComponent.setConfiguration(serviceComponentConfiguraton);
                    serviceComponent.reconfigure();
                    continue;
                }
                catch (Throwable t) {
                    String msg = "Reconfiguring of " + serviceComponent.getShorthand() + " failed";
                    this.getLogger().error(msg);
                    ++exceptionCounter;
                }
            }
            if (exceptionCounter > 0) {
                String msg = "The reconfiguration failed with " + exceptionCounter + " exception(s)";
                this.getLogger().error(msg);
                throw new ConfigurationException(msg);
            }
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleEntry getRoleEntry(String name) throws ServiceException {
        Object lock = null;
        try {
            lock = this.getReadLock();
            RoleEntry roleEntry = this.getServiceComponentEx(name).getRoleEntry();
            return roleEntry;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleEntry[] getRoleEntries() {
        Object lock = null;
        try {
            lock = this.getReadLock();
            List serviceList = this.getServiceList();
            ServiceComponent serviceComponent = null;
            RoleEntry[] result = new RoleEntry[serviceList.size()];
            for (int i = 0; i < result.length; ++i) {
                serviceComponent = (ServiceComponent)serviceList.get(i);
                result[i] = serviceComponent.getRoleEntry();
            }
            RoleEntry[] roleEntryArray = result;
            return roleEntryArray;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(String[] names) throws ServiceException, ConfigurationException {
        Validate.notNull(names, "names");
        Validate.noNullElements(names, "names");
        Object lock = null;
        try {
            lock = this.getWriteLock();
            for (int i = 0; i < names.length; ++i) {
                if (this.getServiceMap().get(names[i]) == null) continue;
                this.reconfigure(names[i]);
            }
        }
        finally {
            this.release(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasService(String name) {
        Validate.notEmpty(name, "name");
        boolean result = false;
        Object lock = null;
        ServiceComponent serviceComponent = null;
        try {
            lock = this.getReadLock();
            serviceComponent = this.getLocalServiceComponent(name);
            result = serviceComponent != null;
        }
        finally {
            this.releaseLock(lock);
        }
        if (!result && this.hasParentServiceManager()) {
            result = this.getParentServiceManager().hasService(name);
        }
        return result;
    }

    public Object lookup(String name) throws ServiceException {
        Validate.notEmpty(name, "name");
        Object lock = null;
        Object result = null;
        ServiceComponent serviceComponent = null;
        try {
            lock = this.getReadLock();
            serviceComponent = this.getLocalServiceComponent(name);
            if (serviceComponent != null) {
                result = serviceComponent.getInstance();
            }
        }
        catch (Throwable t) {
            String msg = "Failed to lookup a service " + name;
            this.getLogger().error(msg, t);
            throw new ServiceException(name, msg, t);
        }
        finally {
            this.releaseLock(lock);
        }
        if (result == null && this.hasParentServiceManager()) {
            result = this.getParentServiceManager().lookup(name);
        }
        if (result == null) {
            String msg = "The following component does not exist : " + name;
            this.getLogger().error(msg);
            throw new ServiceException("yaafi", name);
        }
        return result;
    }

    public void release(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommision(String name) throws ServiceException {
        Object lock = null;
        try {
            lock = this.getWriteLock();
            ServiceComponent serviceComponent = this.getServiceComponentEx(name);
            this.decommision(serviceComponent);
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameters getParameters() {
        Object lock = null;
        try {
            lock = this.getReadLock();
            Parameters parameters = this.parameters;
            return parameters;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("applicationRootDir", this.getApplicationRootDir());
        toStringBuilder.append("tempRootDir", this.getTempRootDir());
        toStringBuilder.append("componentRolesLocation", this.componentRolesLocation);
        toStringBuilder.append("componentConfigurationLocation", this.componentConfigurationLocation);
        toStringBuilder.append("parametersLocation", this.parametersLocation);
        toStringBuilder.append("logger", this.getLogger().getClass().getName());
        toStringBuilder.append("hasDynamicProxies", this.hasDynamicProxies);
        toStringBuilder.append("containerFlavour", this.containerFlavour);
        toStringBuilder.append("componentRolesFlavour", this.componentRolesFlavour);
        toStringBuilder.append("isComponentRolesEncrypted", this.isComponentRolesEncrypted);
        toStringBuilder.append("isComponentConfigurationEncrypted", this.isComponentConfigurationEncrypted);
        toStringBuilder.append("isParametersEncrypted", this.isParametersEncrypted);
        return toStringBuilder.toString();
    }

    private RoleConfigurationParser createRoleConfigurationParser() {
        return new RoleConfigurationParserImpl(this.getComponentRolesFlavour());
    }

    private void reconfigure(String name) throws ServiceException, ConfigurationException {
        Validate.notEmpty(name, "name");
        ServiceComponent serviceComponent = this.getServiceComponentEx(name);
        try {
            serviceComponent.reconfigure();
        }
        catch (ConfigurationException e) {
            String msg = "Reconfiguring failed : " + serviceComponent.getShorthand();
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg, (Throwable)e);
        }
        catch (Throwable t) {
            String msg = "Reconfiguring failed : " + serviceComponent.getShorthand();
            this.getLogger().error(msg, t);
            throw new ConfigurationException(msg, t);
        }
    }

    private ServiceComponent getServiceComponentEx(String name) throws ServiceException {
        Validate.notEmpty(name, "name");
        ServiceComponent result = (ServiceComponent)this.getServiceMap().get(name);
        if (result == null) {
            String msg = "The following component does not exist : " + name;
            this.getLogger().error(msg);
            throw new ServiceException("yaafi", name);
        }
        return result;
    }

    private ServiceComponent getLocalServiceComponent(String name) {
        Validate.notEmpty(name, "name");
        ServiceComponent result = (ServiceComponent)this.getServiceMap().get(name);
        return result;
    }

    private void setComponentConfigurationLocation(String string) {
        this.componentConfigurationLocation = string;
    }

    private void setComponentRolesLocation(String string) {
        this.componentRolesLocation = string;
    }

    private void setParametersLocation(String string) {
        this.parametersLocation = string;
    }

    private Logger getLogger() {
        return this.logger;
    }

    private HashMap getServiceMap() {
        return this.serviceMap;
    }

    private void incarnateAll(List serviceList) throws Exception {
        int i;
        ServiceComponent serviceComponent = null;
        for (i = 0; i < serviceList.size(); ++i) {
            serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            this.configure(serviceComponent);
        }
        for (i = 0; i < serviceList.size(); ++i) {
            serviceComponent = (ServiceComponent)this.getServiceList().get(i);
            this.incarnate(serviceComponent);
        }
    }

    private void configure(ServiceComponent serviceComponent) throws Exception {
        this.getLogger().debug("Configuring the service component " + serviceComponent.getShorthand());
        YaafiToAvalonContextMapper mapper = new YaafiToAvalonContextMapper(serviceComponent.getName(), this.getClassLoader());
        RoleEntry roleEntry = serviceComponent.getRoleEntry();
        String componentFlavour = roleEntry.getComponentFlavour();
        DefaultContext serviceComponentContext = mapper.mapTo(this.getContext(), componentFlavour);
        serviceComponentContext.put((Object)"urn:yaafi:kernellock", (Object)this.readWriteLock);
        Logger serviceComponentLogger = this.getLogger().getChildLogger(roleEntry.getLogCategory());
        Configuration serviceComponentConfiguraton = this.getServiceConfiguration().getChild(roleEntry.getShorthand());
        Parameters serviceComponentParameters = this.getParameters();
        serviceComponent.setLogger(serviceComponentLogger);
        serviceComponent.setServiceManager(this);
        serviceComponent.setContext((Context)serviceComponentContext);
        serviceComponent.setConfiguration(serviceComponentConfiguraton);
        serviceComponent.setParameters(serviceComponentParameters);
        serviceComponent.loadImplemtationClass(this.getClassLoader());
    }

    private void incarnate(ServiceComponent serviceComponent) throws Exception {
        this.getLogger().debug("Incarnating the service " + serviceComponent.getShorthand());
        serviceComponent.incarnate();
    }

    private void decommisionAll(List serviceList) {
        ServiceComponent serviceComponent = null;
        for (int i = serviceList.size() - 1; i >= 0; --i) {
            serviceComponent = (ServiceComponent)serviceList.get(i);
            this.decommision(serviceComponent);
        }
    }

    private void decommision(ServiceComponent serviceComponent) {
        this.getLogger().debug("Decommision the service " + serviceComponent.getShorthand());
        try {
            serviceComponent.decommision();
        }
        catch (Throwable e) {
            String msg = "Decommisioning the following service failed : " + serviceComponent.getName();
            this.getLogger().error(msg, e);
        }
    }

    private void disposeAll(List serviceList) {
        ServiceComponent serviceComponent = null;
        for (int i = serviceList.size() - 1; i >= 0; --i) {
            serviceComponent = (ServiceComponent)serviceList.get(i);
            this.dispose(serviceComponent);
        }
    }

    private void dispose(ServiceComponent serviceComponent) {
        this.getLogger().debug("Disposing the service " + serviceComponent.getShorthand());
        try {
            serviceComponent.dispose();
        }
        catch (Throwable e) {
            String msg = "Disposing the following service failed : " + serviceComponent.getName();
            this.getLogger().error(msg, e);
        }
    }

    private List getServiceList() {
        return this.serviceList;
    }

    private void setServiceList(List list) {
        this.serviceList = list;
    }

    private Configuration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    private List createServiceComponents(Configuration roleConfiguration, Logger logger) throws ConfigurationException {
        Validate.notNull(roleConfiguration, "roleConfiguration");
        Validate.notNull(logger, "logger");
        ArrayList<ServiceComponent> result = new ArrayList<ServiceComponent>();
        ServiceComponent serviceComponent = null;
        RoleConfigurationParser roleConfigurationParser = this.createRoleConfigurationParser();
        RoleEntry[] roleEntryList = roleConfigurationParser.parse(roleConfiguration);
        ArrayList defaultInterceptorList = this.getDefaultInterceptorServiceList();
        for (int i = 0; i < roleEntryList.length; ++i) {
            try {
                RoleEntry roleEntry = roleEntryList[i];
                if (this.hasDynamicProxies()) {
                    roleEntry.addInterceptors(defaultInterceptorList);
                } else {
                    roleEntry.setHasDynamicProxy(false);
                }
                serviceComponent = new AvalonServiceComponentImpl(roleEntry, this.getLogger(), logger, this.readWriteLock);
                result.add(serviceComponent);
                continue;
            }
            catch (Throwable t) {
                String msg = "Failed to load the service " + serviceComponent.getName();
                this.getLogger().error(msg, t);
                throw new ConfigurationException(msg, t);
            }
        }
        return result;
    }

    private Configuration loadConfiguration(String location, String isEncrypted) throws Exception {
        Configuration result = null;
        InputStreamLocator locator = this.createInputStreamLocator();
        InputStream is = locator.locate(location);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        if (is != null) {
            try {
                if (!isEncrypted.equalsIgnoreCase("false")) {
                    is = this.getDecryptingInputStream(is, isEncrypted);
                }
                result = builder.build(is);
                is.close();
                is = null;
            }
            catch (Exception e) {
                String msg = "Unable to parse the following file : " + location;
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    private Properties loadComponentConfigurationProperties() throws ConfigurationException {
        Properties result = new Properties();
        ComponentConfigurationPropertiesResolver resolver = null;
        String className = this.componentConfigurationPropertiesResolverConfig.getChild("resolver").getValue((class$org$apache$fulcrum$yaafi$framework$configuration$ComponentConfigurationPropertiesResolverImpl == null ? (class$org$apache$fulcrum$yaafi$framework$configuration$ComponentConfigurationPropertiesResolverImpl = ServiceContainerImpl.class$("org.apache.fulcrum.yaafi.framework.configuration.ComponentConfigurationPropertiesResolverImpl")) : class$org$apache$fulcrum$yaafi$framework$configuration$ComponentConfigurationPropertiesResolverImpl).getName());
        try {
            Class<?> resolverClass = this.getClassLoader().loadClass(className);
            resolver = (ComponentConfigurationPropertiesResolver)resolverClass.newInstance();
            ContainerUtil.enableLogging((Object)resolver, (Logger)this.getLogger());
            ContainerUtil.contextualize((Object)resolver, (Context)this.getContext());
            ContainerUtil.configure((Object)resolver, (Configuration)this.componentConfigurationPropertiesResolverConfig);
            result = resolver.resolve(null);
            this.getLogger().debug("Using the following componentConfigurationProperties: " + result);
        }
        catch (Exception e) {
            String msg = "Resolving componentConfigurationProperties failed using the following class : " + className;
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg, (Throwable)e);
        }
        return result;
    }

    private Parameters loadParameters(String location, String isEncrypted) throws Exception {
        InputStreamLocator locator = this.createInputStreamLocator();
        InputStream is = locator.locate(location);
        Parameters result = new Parameters();
        if (is != null) {
            if (!isEncrypted.equalsIgnoreCase("false")) {
                is = this.getDecryptingInputStream(is, isEncrypted);
            }
            Properties props = new Properties();
            props.load(is);
            result = Parameters.fromProperties((Properties)props);
            is.close();
            is = null;
        }
        return result;
    }

    private InputStreamLocator createInputStreamLocator() {
        return new InputStreamLocator(this.getApplicationRootDir(), this.getLogger());
    }

    private File setApplicationRootDir(File dir) {
        this.getLogger().debug("Setting applicationRootDir to " + dir.getAbsolutePath());
        Validate.notNull(dir, "applicationRootDir is <null>");
        Validate.isTrue(dir.exists(), "applicationRootDir does not exist");
        this.applicationRootDir = dir;
        return this.applicationRootDir;
    }

    private File getApplicationRootDir() {
        return this.applicationRootDir;
    }

    private ServiceManager getParentServiceManager() {
        return this.parentServiceManager;
    }

    private boolean hasParentServiceManager() {
        return this.getParentServiceManager() != null;
    }

    private File setTempRootDir(File dir) {
        this.getLogger().debug("Setting tempRootDir to " + dir.getAbsolutePath());
        Validate.notNull(dir, "tempRootDir is <null>");
        Validate.isTrue(dir.exists(), "tempRootDir does not exist");
        Validate.isTrue(dir.canWrite(), "tempRootDir is not writeable");
        this.tempRootDir = dir;
        return this.tempRootDir;
    }

    private File getTempRootDir() {
        return this.tempRootDir;
    }

    private String isComponentConfigurationEncrypted() {
        return this.isComponentConfigurationEncrypted;
    }

    private void setComponentConfigurationEncrypted(String isComponentConfigurationEncrypted) {
        this.isComponentConfigurationEncrypted = isComponentConfigurationEncrypted;
    }

    private String isComponentRolesEncrypted() {
        return this.isComponentRolesEncrypted;
    }

    private void setComponentRolesEncrypted(String isComponentRolesEncrypted) {
        this.isComponentRolesEncrypted = isComponentRolesEncrypted;
    }

    private String isParametersEncrypted() {
        return this.isParametersEncrypted;
    }

    private void setParametersEncrypted(String isParametersEncrypted) {
        this.isParametersEncrypted = isParametersEncrypted;
    }

    private InputStream getDecryptingInputStream(InputStream is, String isEncrypted) throws IOException, GeneralSecurityException {
        InputStream result = null;
        result = isEncrypted.equalsIgnoreCase("true") ? CryptoStreamFactoryImpl.getInstance().getInputStream(is) : (isEncrypted.equalsIgnoreCase("auto") ? CryptoStreamFactoryImpl.getInstance().getSmartInputStream(is) : is);
        return result;
    }

    private String getContainerFlavour() {
        return this.containerFlavour;
    }

    private void setContainerFlavour(String containerFlavour) {
        this.containerFlavour = containerFlavour;
    }

    private String getComponentRolesFlavour() {
        return this.componentRolesFlavour;
    }

    private void setComponentRolesFlavour(String componentRolesFlavour) {
        this.componentRolesFlavour = componentRolesFlavour;
    }

    private Context getContext() {
        return this.context;
    }

    private final boolean hasDynamicProxies() {
        return this.hasDynamicProxies;
    }

    private ArrayList getDefaultInterceptorServiceList() {
        return this.defaultInterceptorServiceList;
    }

    private final Object getReadLock() {
        try {
            return this.readWriteLock.getReadLock("yaafi");
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while getting read lock";
            throw new RuntimeException(msg);
        }
    }

    private final Object getWriteLock() {
        Object result = null;
        try {
            result = this.readWriteLock.getWriteLock("yaafi");
            try {
                Thread.sleep(this.reconfigurationDelay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return result;
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while getting read lock";
            throw new RuntimeException(msg);
        }
    }

    private final void releaseLock(Object lock) {
        this.readWriteLock.releaseLock(lock, "yaafi");
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

