/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.event;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodNotFoundException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;

public class MethodExpressionActionListener
implements ActionListener,
StateHolder {
    private MethodExpression methodExpressionOneArg = null;
    private MethodExpression methodExpressionZeroArg = null;
    private boolean isTransient;
    private static final Class<?>[] ACTION_LISTENER_ZEROARG_SIG = new Class[0];

    public MethodExpressionActionListener() {
    }

    public MethodExpressionActionListener(MethodExpression methodExpressionOneArg) {
        this.methodExpressionOneArg = methodExpressionOneArg;
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        this.methodExpressionZeroArg = context.getApplication().getExpressionFactory().createMethodExpression(elContext, methodExpressionOneArg.getExpressionString(), Void.class, (Class[])ACTION_LISTENER_ZEROARG_SIG);
    }

    public MethodExpressionActionListener(MethodExpression methodExpressionOneArg, MethodExpression methodExpressionZeroArg) {
        this.methodExpressionOneArg = methodExpressionOneArg;
        this.methodExpressionZeroArg = methodExpressionZeroArg;
    }

    @Override
    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        try {
            try {
                this.methodExpressionOneArg.invoke(elContext, new Object[]{actionEvent});
            }
            catch (MethodNotFoundException mnfe) {
                this.methodExpressionZeroArg.invoke(elContext, new Object[0]);
            }
        }
        catch (ELException ee) {
            if (ee.getCause() instanceof AbortProcessingException) {
                throw (AbortProcessingException)ee.getCause();
            }
            throw ee;
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return new Object[]{this.methodExpressionOneArg, this.methodExpressionZeroArg};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        this.methodExpressionOneArg = (MethodExpression)((Object[])state)[0];
        this.methodExpressionZeroArg = (MethodExpression)((Object[])state)[1];
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }
}

