/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.StateManagementStrategy;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FaceletPartialStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private static final Set<VisitHint> SKIP_ITERATION_HINT = EnumSet.of(VisitHint.SKIP_ITERATION);
    private static final Set<VisitHint> SKIP_ITERATION_AND_EXECUTE_LIFECYCLE_HINTS = EnumSet.of(VisitHint.SKIP_ITERATION, VisitHint.EXECUTE_LIFECYCLE);

    public FaceletPartialStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public FaceletPartialStateManagementStrategy(FacesContext context) {
    }

    private UIComponent locateComponentByClientId(FacesContext context, UIComponent subTree, String clientId) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletPartialStateManagementStrategy.locateComponentByClientId", clientId);
        }
        ArrayList found = new ArrayList();
        UIComponent result = null;
        VisitContext visitContext = VisitContext.createVisitContext(context, null, SKIP_ITERATION_HINT);
        subTree.visitTree(visitContext, (visitContext1, component) -> {
            VisitResult result1 = VisitResult.ACCEPT;
            if (component.getClientId(visitContext1.getFacesContext()).equals(clientId)) {
                found.add(component);
                result1 = VisitResult.COMPLETE;
            } else if (component instanceof UIForm) {
                UIForm form = (UIForm)component;
                if (form.isPrependId() && !clientId.startsWith(form.getClientId(visitContext1.getFacesContext()))) {
                    result1 = VisitResult.REJECT;
                }
            } else if (component instanceof NamingContainer && !clientId.startsWith(component.getClientId(visitContext1.getFacesContext()))) {
                result1 = VisitResult.REJECT;
            }
            return result1;
        });
        if (!found.isEmpty()) {
            result = (UIComponent)found.get(0);
        }
        return result;
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> dynamicActionList, ComponentStruct struct) {
        int firstIndex;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.pruneAndReAddToDynamicActions");
        }
        if ((firstIndex = dynamicActionList.indexOf(struct)) == -1) {
            dynamicActionList.add(struct);
        } else {
            int lastIndex = dynamicActionList.lastIndexOf(struct);
            if (lastIndex == -1 || lastIndex == firstIndex) {
                dynamicActionList.add(struct);
            } else {
                if ("ADD".equals(struct.getAction())) {
                    dynamicActionList.remove(lastIndex);
                    dynamicActionList.remove(firstIndex);
                    dynamicActionList.add(struct);
                }
                if ("REMOVE".equals(struct.getAction())) {
                    dynamicActionList.remove(lastIndex);
                }
            }
        }
    }

    private void restoreDynamicActions(FacesContext context, StateContext stateContext, Map<String, Object> stateMap) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.restoreDynamicActions");
        }
        List savedActions = (List)stateMap.get("com.sun.faces.DynamicActions");
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        if (!Util.isEmpty(savedActions)) {
            for (Object savedAction : savedActions) {
                ComponentStruct action = new ComponentStruct();
                action.restoreState(context, savedAction);
                if ("ADD".equals(action.getAction())) {
                    this.restoreDynamicAdd(context, stateMap, action);
                }
                if ("REMOVE".equals(action.getAction())) {
                    this.restoreDynamicRemove(context, action);
                }
                this.pruneAndReAddToDynamicActions(actions, action);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext context, Map<String, Object> state, ComponentStruct struct) {
        UIComponent parent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.restoreDynamicAdd");
        }
        if ((parent = this.locateComponentByClientId(context, context.getViewRoot(), struct.getParentClientId())) != null) {
            StateHolderSaver saver;
            UIComponent child = this.locateComponentByClientId(context, parent, struct.getClientId());
            if (child != null) {
                if (struct.getFacetName() == null) {
                    parent.getChildren().remove(child);
                } else {
                    parent.getFacets().remove(struct.getFacetName());
                }
            }
            if (child == null && (saver = (StateHolderSaver)state.get(struct.getClientId())) != null) {
                child = (UIComponent)saver.restore(context);
            }
            StateContext stateContext = StateContext.getStateContext(context);
            if (child == null) {
                child = stateContext.getDynamicComponents().get(struct.getClientId());
            }
            if (child != null) {
                if (struct.getFacetName() != null) {
                    parent.getFacets().put(struct.getFacetName(), child);
                } else {
                    int childIndex = -1;
                    if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                        childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                    }
                    child.setId(struct.getId());
                    if (childIndex >= parent.getChildCount() || childIndex == -1) {
                        parent.getChildren().add(child);
                    } else {
                        parent.getChildren().add(childIndex, child);
                    }
                    child.getClientId();
                }
                child.getAttributes().put("com.sun.faces.DynamicComponent", child.getParent().getChildren().indexOf(child));
                stateContext.getDynamicComponents().put(struct.getClientId(), child);
            }
        }
    }

    private void restoreDynamicRemove(FacesContext context, ComponentStruct struct) {
        UIComponent child;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.restoreDynamicRemove");
        }
        if ((child = this.locateComponentByClientId(context, context.getViewRoot(), struct.getClientId())) != null) {
            StateContext stateContext = StateContext.getStateContext(context);
            stateContext.getDynamicComponents().put(struct.getClientId(), child);
            UIComponent parent = child.getParent();
            if (struct.getFacetName() != null) {
                parent.getFacets().remove(struct.getFacetName());
            } else {
                parent.getChildren().remove(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletPartialStateManagementStrategy.restoreView", new Object[]{viewId, renderKitId});
        }
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        boolean processingEvents = context.isProcessingEvents();
        UIViewRoot viewRoot = context.getViewRoot();
        Object[] rawState = (Object[])rsm.getState(context, viewId);
        if (rawState == null) {
            return null;
        }
        Map state = (Map)rawState[1];
        StateContext stateContext = StateContext.getStateContext(context);
        if (state != null) {
            try {
                stateContext.setTrackViewModifications(false);
                VisitContext visitContext = VisitContext.createVisitContext(context, null, SKIP_ITERATION_AND_EXECUTE_LIFECYCLE_HINTS);
                viewRoot.visitTree(visitContext, (context1, target) -> {
                    VisitResult result = VisitResult.ACCEPT;
                    String cid = target.getClientId(context1.getFacesContext());
                    Object stateObj = state.get(cid);
                    if (stateObj != null && !stateContext.componentAddedDynamically(target)) {
                        boolean restoreStateNow = true;
                        if (stateObj instanceof StateHolderSaver) {
                            boolean bl = restoreStateNow = !((StateHolderSaver)stateObj).componentAddedDynamically();
                        }
                        if (restoreStateNow) {
                            try {
                                target.restoreState(context1.getFacesContext(), stateObj);
                            }
                            catch (Exception e) {
                                String msg = MessageUtils.getExceptionMessageString("com.sun.faces.partial.statesaving.ERROR_RESTORING_STATE_FOR_COMPONENT", cid, e.toString());
                                throw new FacesException(msg, e);
                            }
                        }
                    }
                    return result;
                });
                this.restoreDynamicActions(context, stateContext, state);
            }
            finally {
                stateContext.setTrackViewModifications(true);
            }
        } else {
            viewRoot = null;
        }
        context.setProcessingEvents(processingEvents);
        return viewRoot;
    }

    private void saveDynamicActions(FacesContext context, StateContext stateContext, Map<String, Object> stateMap) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.saveDynamicActions");
        }
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        HashMap<String, UIComponent> componentMap = stateContext.getDynamicComponents();
        if (actions != null) {
            ArrayList<Object> savedActions = new ArrayList<Object>(actions.size());
            for (ComponentStruct action : actions) {
                UIComponent component = componentMap.get(action.getClientId());
                if (component == null && context.isProjectStage(ProjectStage.Development)) {
                    LOGGER.log(Level.WARNING, "Unable to save dynamic action with clientId ''{0}'' because the UIComponent cannot be found", action.getClientId());
                }
                if (component == null) continue;
                savedActions.add(action.saveState(context));
            }
            stateMap.put("com.sun.faces.DynamicActions", savedActions);
        }
    }

    @Override
    public Object saveView(FacesContext context) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.saveView");
        }
        if (context == null) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        Util.checkIdUniqueness(context, viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        StateContext stateContext = StateContext.getStateContext(context);
        VisitContext visitContext = VisitContext.createVisitContext(context, null, SKIP_ITERATION_HINT);
        FacesContext finalContext = context;
        viewRoot.visitTree(visitContext, (context1, target) -> {
            VisitResult result = VisitResult.ACCEPT;
            if (!target.isTransient()) {
                Object stateObj;
                if (stateContext.componentAddedDynamically(target)) {
                    target.getAttributes().put("com.sun.faces.DynamicComponent", target.getParent().getChildren().indexOf(target));
                    stateObj = new StateHolderSaver(finalContext, target);
                } else {
                    stateObj = target.saveState(context1.getFacesContext());
                }
                if (stateObj != null) {
                    stateMap.put(target.getClientId(context1.getFacesContext()), stateObj);
                }
            } else {
                return VisitResult.REJECT;
            }
            return result;
        });
        this.saveDynamicActions(context, stateContext, stateMap);
        StateContext.release(context);
        return new Object[]{null, stateMap};
    }
}

