/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class JRSqlAbstractEqualClause
implements JRClauseFunction {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_EQUAL_CLAUSE_DB_COLUMN_TOKEN_MISSING = "query.equal.clause.db.column.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_EQUAL_CLAUSE_PARAMETER_TOKEN_MISSING = "query.equal.clause.parameter.token.missing";
    public static final int POSITION_DB_COLUMN = 1;
    public static final int POSITION_PARAMETER = 2;

    protected JRSqlAbstractEqualClause() {
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (col == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_EQUAL_CLAUSE_DB_COLUMN_TOKEN_MISSING, (Object[])null);
        }
        if (param == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_EQUAL_CLAUSE_PARAMETER_TOKEN_MISSING, (Object[])null);
        }
        StringBuffer sbuffer = queryContext.queryBuffer();
        sbuffer.append(col);
        sbuffer.append(' ');
        this.handleEqualOperator(sbuffer, param, queryContext);
    }

    protected void finalizeClause(StringBuffer sbuffer, String param, JRQueryClauseContext queryContext) {
        sbuffer.append(' ');
        sbuffer.append('?');
        queryContext.addQueryParameter(param);
    }

    protected abstract void handleEqualOperator(StringBuffer var1, String var2, JRQueryClauseContext var3);
}

