/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import io.dropwizard.util.Duration;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;

@Provider
@PreMatching
public class RuntimeFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final float NANOS_IN_SECOND = Duration.seconds((long)1L).toNanoseconds();
    private static final String RUNTIME_HEADER = "X-Runtime";
    private static final String RUNTIME_PROPERTY = "io.dropwizard.jersey.filter.runtime";
    private Supplier<Long> currentTimeProvider = System::nanoTime;

    void setCurrentTimeProvider(Supplier<Long> currentTimeProvider) {
        this.currentTimeProvider = currentTimeProvider;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        request.setProperty(RUNTIME_PROPERTY, (Object)this.currentTimeProvider.get());
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        Long startTime = (Long)request.getProperty(RUNTIME_PROPERTY);
        if (startTime != null) {
            float seconds = (float)(this.currentTimeProvider.get() - startTime) / NANOS_IN_SECOND;
            response.getHeaders().putSingle((Object)RUNTIME_HEADER, (Object)String.format(Locale.ROOT, "%.6f", Float.valueOf(seconds)));
        }
    }
}

